/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import io.quarkus.domino.inspect.DependencyTreeBuilder;
import io.quarkus.domino.inspect.DependencyTreeError;
import io.quarkus.domino.inspect.DependencyTreeRequest;
import io.quarkus.domino.inspect.DependencyTreeVisitContext;
import io.quarkus.domino.inspect.DependencyTreeVisitSchedulerBase;
import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.NodeProcessor;
import io.quarkus.domino.processor.ParallelTreeProcessor;
import io.quarkus.domino.processor.TaskResult;
import java.util.List;
import java.util.function.Function;
import org.eclipse.aether.graph.DependencyNode;

class ParallelTreeVisitScheduler<E>
extends DependencyTreeVisitSchedulerBase<E> {
    final ParallelTreeProcessor<Integer, DependencyTreeRequest, DependencyNode> treeProcessor;

    ParallelTreeVisitScheduler(final DependencyTreeVisitContext<E> ctx, int treesTotal, final DependencyTreeBuilder treeBuilder, String progressTrackerPrefix) {
        super(ctx, treesTotal, progressTrackerPrefix);
        this.treeProcessor = ParallelTreeProcessor.with(new NodeProcessor<Integer, DependencyTreeRequest, DependencyNode>(){

            private TaskResult<Integer, DependencyTreeRequest, DependencyNode> apply(ExecutionContext<Integer, DependencyTreeRequest, DependencyNode> execution) {
                DependencyTreeRequest request = execution.getNode();
                try {
                    DependencyNode node = treeBuilder.buildTree(request);
                    ctx.log.info(ParallelTreeVisitScheduler.this.getResolvedTreeMessage(request.getArtifact()));
                    return execution.success(node);
                }
                catch (Exception e) {
                    return execution.failure((DependencyNode)e);
                }
            }

            @Override
            public Integer getNodeId(DependencyTreeRequest request) {
                return request.getId();
            }

            @Override
            public Iterable<DependencyTreeRequest> getChildren(DependencyTreeRequest node) {
                return List.of();
            }

            @Override
            public Function<ExecutionContext<Integer, DependencyTreeRequest, DependencyNode>, TaskResult<Integer, DependencyTreeRequest, DependencyNode>> createFunction() {
                return this::apply;
            }
        });
    }

    @Override
    public void process(DependencyTreeRequest root) {
        this.treeProcessor.addRoot(root);
    }

    @Override
    public void waitForCompletion() {
        List<TaskResult<Integer, DependencyTreeRequest, DependencyNode>> results = this.treeProcessor.schedule().join();
        for (TaskResult<Integer, DependencyTreeRequest, DependencyNode> r : results) {
            if (r.isFailure()) {
                this.errors.add(new DependencyTreeError(r.getNode(), r.getException()));
                this.ctx.getLog().error(this.formatErrorMessage(r.getNode(), r.getException()));
                continue;
            }
            this.ctx.root = r.getOutcome();
            this.ctx.visitor.visit(this.ctx);
        }
    }
}

