/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import java.util.Map;

public final class PropertyResolver {
    public static String resolveProperty(String expr, Map<String, String> props) {
        return PropertyResolver.resolveProperty(expr, props, false);
    }

    public static String resolvePropertyOrNull(String expr, Map<String, String> props) {
        return PropertyResolver.resolveProperty(expr, props, true);
    }

    private static String resolveProperty(String expr, Map<String, String> props, boolean nullIfNotResolved) {
        while (true) {
            StringBuilder sb = null;
            int i = 0;
            while (i < expr.length()) {
                char c;
                if ((c = expr.charAt(i++)) == '$' && i + 1 < expr.length() && expr.charAt(i) == '{') {
                    PropertyParsingResult r = PropertyResolver.resolveProperty(expr, i - 1, props, nullIfNotResolved);
                    if (r.value == null) {
                        return null;
                    }
                    if (sb == null) {
                        if (i == 0 && r.endIndex == expr.length()) {
                            return r.value;
                        }
                        sb = new StringBuilder();
                        sb.append(expr.substring(0, i - 1));
                    }
                    sb.append(r.value);
                    i = r.endIndex;
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
            }
            if (sb == null) {
                return expr;
            }
            String resolved = sb.toString();
            if (expr.equals(resolved)) {
                return expr;
            }
            expr = resolved;
        }
    }

    private static PropertyParsingResult resolveProperty(String s, int start, Map<String, String> props, boolean nullIfNotResolved) {
        StringBuilder buf = new StringBuilder();
        int i = start + 2;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '$' && i + 1 < s.length() && s.charAt(i) == '{') {
                PropertyParsingResult result = PropertyResolver.resolveProperty(s, i - 1, props, nullIfNotResolved);
                if (result.value == null) {
                    return null;
                }
                i = result.endIndex;
                buf.append(result.value);
                continue;
            }
            if (c == '}') {
                String value = props.get(buf.toString());
                if (value == null && !nullIfNotResolved) {
                    throw new IllegalArgumentException("Failed to resolve " + String.valueOf(buf) + " with the following known properties " + String.valueOf(props.keySet()));
                }
                return PropertyParsingResult.of(value, i);
            }
            buf.append(c);
        }
        if (buf.length() == 0) {
            return PropertyParsingResult.of(start == 0 ? s : s.substring(start), i);
        }
        return PropertyParsingResult.of("${" + String.valueOf(buf), i);
    }

    private static class PropertyParsingResult {
        final int endIndex;
        final String value;

        private static PropertyParsingResult of(String value, int endIndex) {
            return new PropertyParsingResult(value, endIndex);
        }

        private PropertyParsingResult(String value, int endIndex) {
            this.value = value;
            this.endIndex = endIndex;
        }
    }
}

