/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.inspect.DependencyTreeBuilder;
import io.quarkus.domino.inspect.DependencyTreeError;
import io.quarkus.domino.inspect.DependencyTreeRequest;
import io.quarkus.domino.inspect.DependencyTreeVisitContext;
import io.quarkus.domino.inspect.DependencyTreeVisitSchedulerBase;
import io.quarkus.domino.inspect.DependencyTreeVisitor;
import io.quarkus.domino.inspect.ParallelTreeVisitScheduler;
import io.quarkus.domino.inspect.SequentialTreeVisitScheduler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class DependencyTreeInspector {
    private String settings;
    private List<String> profiles = List.of();
    private String repoDir;
    private MavenArtifactResolver resolver;
    private boolean resolveDependencies;
    private DependencyTreeBuilder treeBuilder;
    private DependencyTreeVisitor<?> visitor;
    private boolean parallelProcessing;
    private MessageWriter log;
    private List<DependencyTreeRequest> roots = new ArrayList<DependencyTreeRequest>();
    private String progressTrackerPrefix;

    public static DependencyTreeInspector configure() {
        return new DependencyTreeInspector();
    }

    private DependencyTreeInspector() {
    }

    public DependencyTreeInspector setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public DependencyTreeInspector setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
        return this;
    }

    public DependencyTreeInspector setTreeBuilder(DependencyTreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public DependencyTreeInspector setTreeVisitor(DependencyTreeVisitor<?> treeVisitor) {
        this.visitor = treeVisitor;
        return this;
    }

    public DependencyTreeInspector setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
        return this;
    }

    public DependencyTreeInspector setMessageWriter(MessageWriter log) {
        this.log = log;
        return this;
    }

    public DependencyTreeInspector inspectAsDependency(Artifact artifact) {
        return this.inspectAsDependency(artifact, List.of(), List.of());
    }

    public DependencyTreeInspector inspectAsDependency(Artifact artifact, List<Dependency> constraints) {
        return this.inspectAsDependency(artifact, constraints, List.of());
    }

    public DependencyTreeInspector inspectAsDependency(Artifact artifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        return this.inspect(DependencyTreeRequest.ofDependency(artifact, constraints, exclusions));
    }

    public DependencyTreeInspector inspectAsRoot(Artifact artifact, List<Dependency> constraints, Collection<Exclusion> exclusions) {
        return this.inspect(DependencyTreeRequest.ofRoot(artifact, constraints, exclusions));
    }

    public DependencyTreeInspector inspectPlugin(Artifact artifact) {
        return this.inspect(DependencyTreeRequest.ofPlugin(artifact));
    }

    public DependencyTreeInspector inspectPlugin(Artifact artifact, Collection<Exclusion> exclusions) {
        return this.inspect(DependencyTreeRequest.ofPlugin(artifact, exclusions));
    }

    public DependencyTreeInspector inspect(DependencyTreeRequest request) {
        this.roots.add(request);
        return this;
    }

    public DependencyTreeInspector setProgressTrackerPrefix(String progressTrackerPrefix) {
        this.progressTrackerPrefix = progressTrackerPrefix;
        return this;
    }

    public void complete() {
        if (this.resolver == null) {
            BootstrapMavenContextConfig config = BootstrapMavenContext.config().setWorkspaceDiscovery(false).setArtifactTransferLogging(false);
            if (this.settings != null) {
                File f = new File(this.settings);
                if (!f.exists()) {
                    throw new IllegalArgumentException(String.valueOf(f) + " does not exist");
                }
                config.setUserSettings(f);
            }
            if (this.repoDir != null) {
                config.setLocalRepository(this.repoDir);
            }
            if (this.profiles != null && !this.profiles.isEmpty()) {
                System.setProperty("quarkus-internal.maven-cmd-line-args", "-P" + String.valueOf(this.profiles));
            }
            try {
                this.resolver = new MavenArtifactResolver(new BootstrapMavenContext(config));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
            }
        }
        if (this.treeBuilder == null) {
            Objects.requireNonNull(this.resolver);
            DependencyTreeBuilder dependencyTreeBuilder = this.treeBuilder = this.resolveDependencies ? DependencyTreeBuilder.resolvingTreeBuilder(this.resolver) : DependencyTreeBuilder.nonResolvingTreeBuilder(this.resolver);
        }
        if (this.log == null) {
            this.log = MessageWriter.info();
        }
        if (this.visitor == null) {
            this.visitor = new DependencyTreeVisitor<Object>(){

                @Override
                public void visit(DependencyTreeVisitor.DependencyTreeVisit<Object> ctx) {
                }

                @Override
                public void onEvent(Object event, MessageWriter log) {
                }

                @Override
                public void handleResolutionFailures(Collection<DependencyTreeError> requests) {
                }
            };
        }
        DependencyTreeVisitSchedulerBase scheduler = this.parallelProcessing ? new ParallelTreeVisitScheduler(new DependencyTreeVisitContext(this.visitor, this.log), this.roots.size(), this.treeBuilder, this.progressTrackerPrefix) : new SequentialTreeVisitScheduler(new DependencyTreeVisitContext(this.visitor, this.log), this.roots.size(), this.treeBuilder, this.progressTrackerPrefix);
        for (DependencyTreeRequest r : this.roots) {
            scheduler.process(r);
        }
        scheduler.waitForCompletion();
        if (!scheduler.getResolutionFailures().isEmpty()) {
            this.visitor.handleResolutionFailures(scheduler.getResolutionFailures());
        }
    }
}

