/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.processor;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyResolver;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.NodeProcessor;
import io.quarkus.domino.processor.ParallelTreeProcessor;
import io.quarkus.domino.processor.TaskResult;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

public class ParallelExecution {
    private static final String AUTOBUILD_SUFFIX = "-autobuild-";
    private static final int MIN_BUILD_NUMBER = 1;
    private static final int MAX_BUILD_NUMBER = 99999;
    private static final char[] PROJECT_NAME_SEPARATORS = new char[]{'/', ':', '?', '='};
    private final Path localMavenRepo;
    private final Path projects;
    private MavenArtifactResolver resolver;
    private final Map<ScmRevision, ProjectInfo> projectInfos = new HashMap<ScmRevision, ProjectInfo>();
    private final Map<ArtifactCoords, ProjectInfo> artifactProjects = new HashMap<ArtifactCoords, ProjectInfo>();
    private final AtomicInteger projectsBuilt = new AtomicInteger();
    private final AtomicInteger projectsBuilding = new AtomicInteger();
    private final AtomicInteger projectsRemaining = new AtomicInteger();

    public static void main(String[] args) throws Exception {
        Path workDir = Path.of("target", new String[0]).resolve("parallel-build").normalize().toAbsolutePath();
        IoUtils.recursiveDelete((Path)workDir);
        Path configFile = ParallelExecution.generateConfig(workDir.resolve("dependency-config.yaml"));
        ParallelExecution pe = new ParallelExecution(workDir);
        pe.run(configFile);
    }

    private static Path generateConfig(Path configFile) throws Exception {
        ProjectDependencyConfig.builder().setProjectBom(ArtifactCoords.pom((String)"io.vertx", (String)"vertx-dependencies", (String)"4.3.4")).setExcludeGroupIds(Set.of("org.junit.platform", "org.junit.jupiter")).setWarnOnResolutionErrors(true).setLogCodeRepos(true).setLogArtifactsToBuild(true).setLogModulesToBuild(true).setLogSummary(true).persist(configFile);
        return configFile;
    }

    ParallelExecution(Path workDir) throws Exception {
        this.localMavenRepo = IoUtils.mkdirs((Path)workDir.resolve("maven-repo"));
        this.projects = IoUtils.mkdirs((Path)workDir.resolve("projects"));
    }

    void run(Path configFile) throws Exception {
        this.run(ProjectDependencyConfig.fromFile(configFile));
    }

    void run(ProjectDependencyConfig config) throws Exception {
        this.resolver = MavenArtifactResolver.builder().build();
        Collection<ReleaseRepo> allRepos = ProjectDependencyResolver.builder().setDependencyConfig(config).setArtifactResolver(this.resolver).build().getSortedReleaseRepos();
        this.generateProjectSources(allRepos);
        this.projectsRemaining.set(allRepos.size());
        long startTime = System.currentTimeMillis();
        this.buildInParallel(allRepos);
        ParallelExecution.log(String.format("Built %s artifacts from %s repositories in %.2f sec", this.artifactProjects.size(), allRepos.size(), (double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildInSequence(Collection<ReleaseRepo> allRepos) throws Exception {
        HashMap<String, CallSite> versionProps = new HashMap<String, CallSite>();
        for (ReleaseRepo repo : allRepos) {
            ProjectInfo project = this.projectInfos.get(repo.getRevision());
            String version = project.originalVersion + AUTOBUILD_SUFFIX + ParallelExecution.generateBuildNumber();
            ArrayList<String> command = new ArrayList<String>();
            command.add("mvn");
            command.add("install");
            command.add("-Drevision=" + version);
            for (String prop : project.getBuildProperties()) {
                String value = (String)versionProps.get(prop);
                if (value == null) {
                    throw new IllegalStateException("Version property " + prop + " is not available");
                }
                command.add("-D" + prop + "=" + value);
            }
            command.add("-Dmaven.repo.local=" + String.valueOf(this.localMavenRepo));
            Process process = null;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(command).redirectOutput(project.dir.resolve("build.log").toFile()).redirectErrorStream(true).directory(project.dir.toFile());
                this.projectsRemaining.decrementAndGet();
                this.projectsBuilding.incrementAndGet();
                ParallelExecution.log(this.getProgressPrefix().append("launching build ").append(project.name).append(" ").append(version));
                process = processBuilder.start();
                if (process.waitFor() != 0) {
                    throw new IllegalStateException("Failed building " + project.name + "-" + version);
                }
                this.projectsBuilding.decrementAndGet();
                this.projectsBuilt.incrementAndGet();
                ParallelExecution.log(this.getProgressPrefix().append("finished building ").append(project.name).append(" ").append(version));
                versionProps.put(project.getVersionProperty(), (CallSite)((Object)version));
            }
            finally {
                if (process == null) continue;
                process.destroy();
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void buildInParallel(Collection<ReleaseRepo> allRepos) {
        ParallelTreeProcessor<ScmRevision, ReleaseRepo, Map<String, String>> treeProcessor = ParallelTreeProcessor.with(new NodeProcessor<ScmRevision, ReleaseRepo, Map<String, String>>(){

            @Override
            public ScmRevision getNodeId(ReleaseRepo node) {
                return node.getRevision();
            }

            @Override
            public Iterable<ReleaseRepo> getChildren(ReleaseRepo node) {
                return node.getDependencies();
            }

            @Override
            public Function<ExecutionContext<ScmRevision, ReleaseRepo, Map<String, String>>, TaskResult<ScmRevision, ReleaseRepo, Map<String, String>>> createFunction() {
                return ctx -> {
                    TaskResult taskResult;
                    ProjectInfo project = ParallelExecution.this.projectInfos.get(((ReleaseRepo)ctx.getNode()).getRevision());
                    String version = project.originalVersion + ParallelExecution.AUTOBUILD_SUFFIX + ParallelExecution.generateBuildNumber();
                    ArrayList<String> command = new ArrayList<String>();
                    command.add("mvn");
                    command.add("install");
                    command.add("-Drevision=" + version);
                    for (ScmRevision dep : ctx.getDependencies()) {
                        TaskResult result = ctx.getDependencyResult(dep);
                        if (result.isCanceled() || result.isFailure()) {
                            return ctx.canceled(Map.of());
                        }
                        for (Map.Entry prop : ((Map)result.getOutcome()).entrySet()) {
                            command.add("-D" + (String)prop.getKey() + "=" + (String)prop.getValue());
                        }
                    }
                    command.add("-Dmaven.repo.local=" + String.valueOf(ParallelExecution.this.localMavenRepo));
                    Process process = null;
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(command).redirectOutput(project.dir.resolve("build.log").toFile()).redirectErrorStream(true).directory(project.dir.toFile());
                        ParallelExecution.this.projectsRemaining.decrementAndGet();
                        ParallelExecution.this.projectsBuilding.incrementAndGet();
                        ParallelExecution.log(ParallelExecution.this.getProgressPrefix().append("launching build ").append(project.name).append(" ").append(version));
                        process = processBuilder.start();
                        if (process.waitFor() != 0) {
                            ParallelExecution.log("Failed building " + project.name + "-" + version);
                            taskResult = ctx.failure(Map.of());
                            return taskResult;
                        }
                        ParallelExecution.this.projectsBuilding.decrementAndGet();
                        ParallelExecution.this.projectsBuilt.incrementAndGet();
                        ParallelExecution.log(ParallelExecution.this.getProgressPrefix().append("finished building ").append(project.name).append(" ").append(version));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        taskResult = ctx.failure(Map.of());
                        return taskResult;
                    }
                    finally {
                        if (process != null) {
                            process.destroy();
                            try {
                                process.waitFor();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return ctx.success(Map.of(project.getVersionProperty(), version));
                };
            }
        });
        for (ReleaseRepo r : allRepos) {
            if (!r.isRoot()) continue;
            treeProcessor.addRoot(r);
        }
        List<TaskResult<ScmRevision, ReleaseRepo, Map<String, String>>> results = treeProcessor.schedule().join();
    }

    private void generateProjectSources(Collection<ReleaseRepo> releaseRepos) throws Exception {
        HashMap<ScmRepository, String> projectNames = new HashMap<ScmRepository, String>();
        for (ReleaseRepo repo : releaseRepos) {
            this.initProjectInfo(repo, projectNames);
        }
        for (ProjectInfo r : this.projectInfos.values()) {
            this.generateProject(r);
        }
    }

    private void initProjectInfo(ReleaseRepo repo, Map<ScmRepository, String> projectNames) {
        String projectName = ParallelExecution.deriveProjectName(repo.getRevision().getRepository(), projectNames);
        String projectVersion = repo.getArtifacts().keySet().iterator().next().getVersion();
        Path projectDir = IoUtils.mkdirs((Path)this.projects.resolve(projectName + "-" + projectVersion));
        ProjectInfo info = new ProjectInfo(repo, projectVersion, projectDir, projectName);
        this.projectInfos.put(info.release.getRevision(), info);
        for (ArtifactCoords c : repo.getArtifacts().keySet()) {
            if (!c.getVersion().equals(info.originalVersion)) {
                ParallelExecution.log("WARN: inconsistent versioning detected in " + String.valueOf(repo.getRevision()));
            }
            if (c.getType().equals("jar") || c.getType().equals("pom")) {
                this.artifactProjects.put(c, info);
                continue;
            }
            ParallelExecution.log("ERROR: unsupported artifact type " + String.valueOf(c));
        }
    }

    private void generateProject(ProjectInfo project) throws Exception {
        ParallelExecution.log("Generating project: " + project.id);
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setVersion("${revision}");
        Set<ArtifactCoords> artifacts = project.release.getArtifacts().keySet();
        if (artifacts.size() == 1) {
            ArtifactCoords a = (ArtifactCoords)artifacts.iterator().next();
            pom.setGroupId(a.getGroupId());
            pom.setArtifactId(a.getArtifactId());
            pom.setPackaging(a.getType());
            this.configureDependencies(project, pom, a);
        } else {
            String groupId = null;
            ArtifactCoords parentPom = null;
            for (ArtifactCoords d : artifacts) {
                groupId = d.getGroupId();
                if (!d.getArtifactId().endsWith("-parent")) continue;
                parentPom = d;
                break;
            }
            pom.setGroupId(groupId);
            pom.setArtifactId((String)(parentPom == null ? project.name + "-parent" : parentPom.getArtifactId()));
            pom.setPackaging("pom");
            HashMap<String, Model> addedModules = new HashMap<String, Model>();
            for (ArtifactCoords d : artifacts) {
                PluginExecution e;
                if (parentPom != null && d.getArtifactId().equals(parentPom.getArtifactId())) continue;
                String moduleName = d.getArtifactId();
                Model moduleModel = (Model)addedModules.get(moduleName);
                if (moduleModel == null) {
                    pom.addModule(moduleName);
                    moduleModel = this.generateModule(project, pom, IoUtils.mkdirs((Path)project.dir.resolve(moduleName)), d);
                    addedModules.put(moduleName, moduleModel);
                }
                if (d.getClassifier().isEmpty()) continue;
                Build build = moduleModel.getBuild();
                if (build == null) {
                    build = new Build();
                    moduleModel.setBuild(build);
                }
                Plugin jarPlugin = null;
                for (Plugin pl : build.getPlugins()) {
                    if (!pl.getArtifactId().equals("maven-jar-plugin")) continue;
                    jarPlugin = pl;
                    break;
                }
                if (jarPlugin == null) {
                    jarPlugin = new Plugin();
                    jarPlugin.setArtifactId("maven-jar-plugin");
                    jarPlugin.setVersion("3.3.0");
                    e = new PluginExecution();
                    e.setId("default-jar");
                    e.setGoals(List.of("jar"));
                    jarPlugin.addExecution(e);
                    build.addPlugin(jarPlugin);
                }
                e = new PluginExecution();
                e.setId(d.getClassifier() + "-jar");
                e.setGoals(List.of("jar"));
                Xpp3Dom config = new Xpp3Dom("configuration");
                e.setConfiguration((Object)config);
                Xpp3Dom classifierDom = new Xpp3Dom("classifier");
                classifierDom.setValue(d.getClassifier());
                config.addChild(classifierDom);
                jarPlugin.addExecution(e);
                ModelUtils.persistModel((Path)project.dir.resolve(moduleName).resolve("pom.xml"), (Model)moduleModel);
            }
        }
        this.configureFlattenPlugin(pom);
        ModelUtils.persistModel((Path)project.dir.resolve("pom.xml"), (Model)pom);
    }

    private Model generateModule(ProjectInfo project, Model parentPom, Path moduleDir, ArtifactCoords artifact) throws Exception {
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        Parent parent = new Parent();
        parent.setGroupId(parentPom.getGroupId());
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(parentPom.getVersion());
        pom.setParent(parent);
        if (!parentPom.getGroupId().equals(artifact.getGroupId())) {
            pom.setGroupId(artifact.getGroupId());
        }
        pom.setArtifactId(artifact.getArtifactId());
        if (artifact.getType().equals("pom")) {
            pom.setPackaging("pom");
        }
        this.configureDependencies(project, pom, artifact);
        ModelUtils.persistModel((Path)moduleDir.resolve("pom.xml"), (Model)pom);
        return pom;
    }

    private void configureDependencies(ProjectInfo project, Model pom, ArtifactCoords moduleArtifact) throws BootstrapMavenException {
        for (Dependency directDep : this.resolver.resolveDescriptor((Artifact)new DefaultArtifact(moduleArtifact.getGroupId(), moduleArtifact.getArtifactId(), moduleArtifact.getClassifier(), moduleArtifact.getType(), moduleArtifact.getVersion())).getDependencies()) {
            String versionProp;
            Artifact depArtifact = directDep.getArtifact();
            ProjectInfo projectDep = this.artifactProjects.get(ArtifactCoords.of((String)depArtifact.getGroupId(), (String)depArtifact.getArtifactId(), (String)depArtifact.getClassifier(), (String)depArtifact.getExtension(), (String)depArtifact.getVersion()));
            if (projectDep == null) continue;
            if (projectDep != project) {
                versionProp = projectDep.getVersionProperty();
                if (!pom.getProperties().containsKey(versionProp)) {
                    pom.getProperties().setProperty(versionProp, "placeholder");
                    project.addBuildProperty(versionProp);
                }
            } else {
                versionProp = "project.version";
            }
            org.apache.maven.model.Dependency modelDep = new org.apache.maven.model.Dependency();
            modelDep.setGroupId(depArtifact.getGroupId());
            modelDep.setArtifactId(depArtifact.getArtifactId());
            modelDep.setVersion("${" + versionProp + "}");
            if (!depArtifact.getExtension().equals("jar")) {
                modelDep.setType(depArtifact.getExtension());
            }
            if (!depArtifact.getClassifier().isEmpty()) {
                modelDep.setClassifier(depArtifact.getClassifier());
            }
            pom.addDependency(modelDep);
        }
    }

    private void configureFlattenPlugin(Model pom) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("org.codehaus.mojo");
        plugin.setArtifactId("flatten-maven-plugin");
        plugin.setVersion("1.1.0");
        Xpp3Dom config = new Xpp3Dom("configuration");
        plugin.setConfiguration((Object)config);
        Xpp3Dom updatePomFile = new Xpp3Dom("updatePomFile");
        updatePomFile.setValue("true");
        config.addChild(updatePomFile);
        Xpp3Dom flattenMode = new Xpp3Dom("flattenMode");
        flattenMode.setValue("resolveCiFriendliesOnly");
        config.addChild(flattenMode);
        Xpp3Dom pomElements = new Xpp3Dom("pomElements");
        config.addChild(pomElements);
        Xpp3Dom deps = new Xpp3Dom("dependencies");
        deps.setValue("flatten");
        pomElements.addChild(deps);
        PluginExecution e = new PluginExecution();
        e.setId("flatten");
        e.setPhase("process-resources");
        e.addGoal("flatten");
        plugin.addExecution(e);
        e = new PluginExecution();
        e.setId("flatten.clean");
        e.setPhase("clean");
        e.addGoal("clean");
        plugin.addExecution(e);
    }

    private static String deriveProjectName(ScmRepository o, Map<ScmRepository, String> projectNames) {
        int j;
        Object name = projectNames.get(o);
        if (name != null) {
            return name;
        }
        String[] split = o.toString().split("/");
        if (split[j = split.length - 1].isEmpty()) {
            --j;
        }
        if (j <= 0) {
            name = split[0];
        } else {
            name = split[j - 1];
            if (!((String)name).isEmpty()) {
                name = (String)name + "-";
            }
            name = (String)name + split[j];
        }
        if (((String)name).contains("${")) {
            name = ((String)name).replace("${", "");
            name = ((String)name).replace("}", "");
            name = ((String)name).replace("env.", "");
            name = ((String)name).toLowerCase();
        }
        for (int i = 0; i < PROJECT_NAME_SEPARATORS.length; ++i) {
            name = ((String)name).replace(PROJECT_NAME_SEPARATORS[i], '-');
        }
        if (projectNames.values().contains(name)) {
            ParallelExecution.log("WARN: duplicate project name " + (String)name + " for " + o.toString());
        }
        projectNames.put(o, (String)name);
        return name;
    }

    private StringBuilder getProgressPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Remaining: ").append(this.projectsRemaining.get());
        sb.append(", in progress: ").append(this.projectsBuilding.get());
        sb.append(", done: ").append(this.projectsBuilt.get()).append("] ");
        return sb;
    }

    private static String generateBuildNumber() {
        int n = (int)(Math.random() * 99999.0 + 1.0);
        return String.format("%05d", n);
    }

    private static void log(Object o) {
        System.out.println(o == null ? "null" : o.toString());
    }

    private static class ProjectInfo {
        final String id;
        final String name;
        final String originalVersion;
        final Path dir;
        final ReleaseRepo release;
        final Set<String> buildProperties = new HashSet<String>();

        ProjectInfo(ReleaseRepo release, String originalVersion, Path dir, String name) {
            this.id = name + "-" + originalVersion;
            this.originalVersion = originalVersion;
            this.release = release;
            this.dir = dir;
            this.name = name;
        }

        String getVersionProperty() {
            return this.id + ".version";
        }

        void addBuildProperty(String name) {
            this.buildProperties.add(name);
        }

        Collection<String> getBuildProperties() {
            return this.buildProperties;
        }
    }
}

