/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.domino.ArtifactCoordsCollectionSorter;
import io.quarkus.domino.ProductInfo;
import io.quarkus.domino.ProductInfoImpl;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyConfigExcludeScopesFilter;
import io.quarkus.domino.ProjectDependencyConfigIncludeNonManagedFilter;
import io.quarkus.domino.ProjectDependencyConfigLevelFilter;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ProjectDependencyConfigImpl
implements ProjectDependencyConfig {
    static final String WILDCARD = "*";
    private final ProductInfo productInfo;
    private final Path projectDir;
    private final ArtifactCoords projectBom;
    private final List<ArtifactCoords> nonProjectBoms;
    private final Collection<ArtifactCoords> projectArtifacts;
    private final Collection<ArtifactCoords> includeArtifacts;
    private final Collection<ArtifactCoords> includePatterns;
    private final Collection<ArtifactCoords> excludePatterns;
    private final Collection<String> excludeScopes;
    private final boolean includeNonManaged;
    private final boolean excludeParentPoms;
    private final boolean excludeBomImports;
    private final int level;
    private final boolean verboseGraphs;
    private final boolean logArtifactsToBuild;
    private final boolean logModulesToBuild;
    private final boolean logTrees;
    private final String logTreesFor;
    private final boolean logRemaining;
    private final boolean logSummary;
    private final boolean logNonManagedVisited;
    private final boolean logCodeRepos;
    private final boolean logCodeRepoTree;
    private final List<String> recipeRepos;
    private final boolean validateCodeRepoTags;
    private final boolean legacyScmLocator;
    private final boolean warnOnResolutionErrors;
    private final boolean warnOnMissingScm;
    private final boolean includeAlreadyBuilt;
    private final boolean includeOptionalDeps;
    private final Collection<String> hideArtifacts;
    private final boolean gradleJava8;
    private final String gradleJavaHome;

    private ProjectDependencyConfigImpl(ProjectDependencyConfig other) {
        ProductInfo productInfo = other.getProductInfo();
        this.productInfo = productInfo instanceof ProductInfo.Mutable ? ((ProductInfo.Mutable)productInfo).build() : productInfo;
        this.projectDir = other.getProjectDir();
        this.projectBom = other.getProjectBom();
        this.nonProjectBoms = ProjectDependencyConfigImpl.toUnmodifiableList(other.getNonProjectBoms());
        this.projectArtifacts = ProjectDependencyConfigImpl.toUnmodifiableList(other.getProjectArtifacts());
        this.includeArtifacts = ProjectDependencyConfigImpl.toUnmodifiableList(other.getIncludeArtifacts());
        this.includePatterns = ProjectDependencyConfigImpl.toUnmodifiableList(other.getIncludePatterns());
        this.excludePatterns = ProjectDependencyConfigImpl.toUnmodifiableList(other.getExcludePatterns());
        this.excludeScopes = ProjectDependencyConfigImpl.toUnmodifiableList(other.getExcludeScopes());
        this.includeNonManaged = other.isIncludeNonManaged();
        this.excludeParentPoms = other.isExcludeParentPoms();
        this.excludeBomImports = other.isExcludeBomImports();
        this.level = other.getLevel();
        this.verboseGraphs = other.isVerboseGraphs();
        this.logArtifactsToBuild = other.isLogArtifactsToBuild();
        this.logModulesToBuild = other.isLogModulesToBuild();
        this.logTrees = other.isLogTrees();
        this.logTreesFor = other.getLogTreesFor();
        this.logRemaining = other.isLogRemaining();
        this.logSummary = other.isLogSummary();
        this.logNonManagedVisited = other.isLogNonManagedVisitied();
        this.logCodeRepos = other.isLogCodeRepos();
        this.logCodeRepoTree = other.isLogCodeRepoTree();
        this.includeAlreadyBuilt = other.isIncludeAlreadyBuilt();
        this.hideArtifacts = ProjectDependencyConfigImpl.toUnmodifiableList(other.getHideArtifacts());
        this.recipeRepos = ProjectDependencyConfigImpl.toUnmodifiableList(other.getRecipeRepos());
        this.validateCodeRepoTags = other.isValidateCodeRepoTags();
        this.legacyScmLocator = other.isLegacyScmLocator();
        this.warnOnResolutionErrors = other.isWarnOnResolutionErrors();
        this.warnOnMissingScm = other.isWarnOnMissingScm();
        this.includeOptionalDeps = other.isIncludeOptionalDeps();
        this.gradleJava8 = other.isGradleJava8();
        this.gradleJavaHome = other.getGradleJavaHome();
    }

    @Override
    @JsonDeserialize(as=ProductInfoImpl.Builder.class)
    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    @Override
    public Path getProjectDir() {
        return this.projectDir;
    }

    @Override
    public ArtifactCoords getProjectBom() {
        return this.projectBom;
    }

    @Override
    @JsonSerialize(converter=ArtifactCoordsCollectionSorter.class)
    public List<ArtifactCoords> getNonProjectBoms() {
        return this.nonProjectBoms;
    }

    @Override
    @JsonSerialize(converter=ArtifactCoordsCollectionSorter.class)
    public Collection<ArtifactCoords> getProjectArtifacts() {
        return this.projectArtifacts;
    }

    @Override
    @JsonSerialize(converter=ArtifactCoordsCollectionSorter.class)
    public Collection<ArtifactCoords> getIncludeArtifacts() {
        return this.includeArtifacts;
    }

    @Override
    @JsonSerialize(converter=ArtifactCoordsCollectionSorter.class)
    public Collection<ArtifactCoords> getIncludePatterns() {
        return this.includePatterns;
    }

    @Override
    @JsonSerialize(converter=ArtifactCoordsCollectionSorter.class)
    public Collection<ArtifactCoords> getExcludePatterns() {
        return this.excludePatterns;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ProjectDependencyConfigExcludeScopesFilter.class)
    public Collection<String> getExcludeScopes() {
        return this.excludeScopes;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ProjectDependencyConfigIncludeNonManagedFilter.class)
    public boolean isIncludeNonManaged() {
        return this.includeNonManaged;
    }

    @Override
    public boolean isExcludeParentPoms() {
        return this.excludeParentPoms;
    }

    @Override
    public boolean isExcludeBomImports() {
        return this.excludeBomImports;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ProjectDependencyConfigLevelFilter.class)
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isVerboseGraphs() {
        return this.verboseGraphs;
    }

    @Override
    public boolean isLogArtifactsToBuild() {
        return this.logArtifactsToBuild;
    }

    @Override
    public boolean isLogModulesToBuild() {
        return this.logModulesToBuild;
    }

    @Override
    public boolean isLogTrees() {
        return this.logTrees;
    }

    @Override
    public String getLogTreesFor() {
        return this.logTreesFor;
    }

    @Override
    public boolean isLogRemaining() {
        return this.logRemaining;
    }

    @Override
    public boolean isLogSummary() {
        return this.logSummary;
    }

    @Override
    public boolean isLogNonManagedVisitied() {
        return this.logNonManagedVisited;
    }

    @Override
    public boolean isLogCodeRepos() {
        return this.logCodeRepos;
    }

    @Override
    public boolean isLogCodeRepoTree() {
        return this.logCodeRepoTree;
    }

    @Override
    public List<String> getRecipeRepos() {
        return this.recipeRepos;
    }

    @Override
    @Deprecated(since="0.0.78")
    public boolean isValidateCodeRepoTags() {
        return this.validateCodeRepoTags;
    }

    @Override
    public boolean isLegacyScmLocator() {
        return this.legacyScmLocator;
    }

    @Override
    public boolean isWarnOnResolutionErrors() {
        return this.warnOnResolutionErrors;
    }

    @Override
    public boolean isWarnOnMissingScm() {
        return this.warnOnMissingScm;
    }

    @Override
    public boolean isIncludeAlreadyBuilt() {
        return this.includeAlreadyBuilt;
    }

    @Override
    public boolean isIncludeOptionalDeps() {
        return this.includeOptionalDeps;
    }

    @Override
    public Collection<String> getHideArtifacts() {
        return this.hideArtifacts;
    }

    @Override
    public boolean isGradleJava8() {
        return this.gradleJava8;
    }

    @Override
    public String getGradleJavaHome() {
        return this.gradleJavaHome;
    }

    static <T> List<T> toUnmodifiableList(Collection<T> o) {
        if (o == null || o.isEmpty()) {
            return List.of();
        }
        return List.copyOf(o);
    }

    static class Builder
    implements ProjectDependencyConfig.Mutable {
        private ProductInfo productInfo;
        private Path projectDir;
        private ArtifactCoords projectBom;
        private List<ArtifactCoords> nonProjectBoms = List.of();
        private Collection<ArtifactCoords> projectArtifacts = new ArrayList<ArtifactCoords>();
        private Collection<ArtifactCoords> includeArtifacts = new ArrayList<ArtifactCoords>();
        private Collection<ArtifactCoords> includePatterns = new ArrayList<ArtifactCoords>();
        private Collection<ArtifactCoords> excludePatterns = new ArrayList<ArtifactCoords>();
        private Collection<String> excludeScopes = Set.of("provided", "test");
        private boolean includeNonManaged = true;
        private boolean excludeParentPoms;
        private boolean excludeBomImports;
        private int level = -1;
        private boolean verboseGraphs;
        private boolean logArtifactsToBuild;
        private boolean logModulesToBuild;
        private boolean logTrees;
        private String logTreesFor;
        private boolean logRemaining;
        private boolean logSummary;
        private boolean logNonManagedVisited;
        private boolean logCodeRepos;
        private boolean logCodeRepoTree;
        private List<String> recipeRepoUrls = List.of();
        private boolean validateCodeRepoTags;
        private boolean legacyScmLocator;
        private boolean warnOnResolutionErrors;
        private boolean warnOnMissingScm;
        private boolean includeAlreadyBuilt;
        private boolean includeOptionalDeps;
        private Collection<String> hideArtifacts = new ArrayList<String>(0);
        private boolean gradleJava8;
        private String gradleJavaHome;

        Builder() {
        }

        Builder(ProjectDependencyConfig other) {
            this.productInfo = other.getProductInfo();
            this.projectDir = other.getProjectDir();
            this.projectBom = other.getProjectBom();
            this.nonProjectBoms = new ArrayList<ArtifactCoords>(other.getNonProjectBoms());
            this.projectArtifacts.addAll(other.getProjectArtifacts());
            this.includeArtifacts.addAll(other.getIncludeArtifacts());
            this.includePatterns.addAll(other.getIncludePatterns());
            this.excludePatterns.addAll(other.getExcludePatterns());
            this.excludeScopes = other.getExcludeScopes();
            this.includeNonManaged = other.isIncludeNonManaged();
            this.excludeParentPoms = other.isExcludeParentPoms();
            this.excludeBomImports = other.isExcludeBomImports();
            this.level = other.getLevel();
            this.verboseGraphs = other.isVerboseGraphs();
            this.logArtifactsToBuild = other.isLogArtifactsToBuild();
            this.logModulesToBuild = other.isLogModulesToBuild();
            this.logTrees = other.isLogTrees();
            this.logTreesFor = other.getLogTreesFor();
            this.logRemaining = other.isLogRemaining();
            this.logSummary = other.isLogSummary();
            this.logNonManagedVisited = other.isLogNonManagedVisitied();
            this.logCodeRepos = other.isLogCodeRepos();
            this.logCodeRepoTree = other.isLogCodeRepoTree();
            this.validateCodeRepoTags = other.isValidateCodeRepoTags();
            this.warnOnResolutionErrors = other.isWarnOnResolutionErrors();
            this.warnOnMissingScm = other.isWarnOnMissingScm();
            this.includeAlreadyBuilt = other.isIncludeAlreadyBuilt();
            this.includeOptionalDeps = other.isIncludeOptionalDeps();
            this.gradleJava8 = other.isGradleJava8();
            this.gradleJavaHome = other.getGradleJavaHome();
        }

        @Override
        @JsonDeserialize(as=ProductInfoImpl.Builder.class)
        public ProductInfo getProductInfo() {
            return this.productInfo;
        }

        @Override
        public Path getProjectDir() {
            return this.projectDir;
        }

        @Override
        public ProjectDependencyConfig.Mutable setProjectDir(Path projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        @Override
        public ArtifactCoords getProjectBom() {
            return this.projectBom;
        }

        @Override
        public List<ArtifactCoords> getNonProjectBoms() {
            return this.nonProjectBoms;
        }

        @Override
        public Collection<ArtifactCoords> getProjectArtifacts() {
            return this.projectArtifacts;
        }

        @Override
        public Collection<ArtifactCoords> getIncludeArtifacts() {
            return this.includeArtifacts;
        }

        @Override
        public Collection<ArtifactCoords> getIncludePatterns() {
            return this.includePatterns;
        }

        @Override
        public Collection<ArtifactCoords> getExcludePatterns() {
            return this.excludePatterns;
        }

        @Override
        public Collection<String> getExcludeScopes() {
            return this.excludeScopes;
        }

        @Override
        public boolean isIncludeNonManaged() {
            return this.includeNonManaged;
        }

        @Override
        public boolean isExcludeParentPoms() {
            return this.excludeParentPoms;
        }

        @Override
        public boolean isExcludeBomImports() {
            return this.excludeBomImports;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public boolean isVerboseGraphs() {
            return this.verboseGraphs;
        }

        @Override
        public boolean isLogArtifactsToBuild() {
            return this.logArtifactsToBuild;
        }

        @Override
        public boolean isLogModulesToBuild() {
            return this.logModulesToBuild;
        }

        @Override
        public boolean isLogTrees() {
            return this.logTrees;
        }

        @Override
        public String getLogTreesFor() {
            return this.logTreesFor;
        }

        @Override
        public boolean isLogRemaining() {
            return this.logRemaining;
        }

        @Override
        public boolean isLogSummary() {
            return this.logSummary;
        }

        @Override
        public boolean isLogNonManagedVisitied() {
            return this.logNonManagedVisited;
        }

        @Override
        public boolean isLogCodeRepos() {
            return this.logCodeRepos;
        }

        @Override
        public boolean isLogCodeRepoTree() {
            return this.logCodeRepoTree;
        }

        @Override
        public List<String> getRecipeRepos() {
            return this.recipeRepoUrls;
        }

        @Override
        public boolean isValidateCodeRepoTags() {
            return this.validateCodeRepoTags;
        }

        @Override
        @Deprecated(since="0.0.78")
        public boolean isLegacyScmLocator() {
            return this.legacyScmLocator;
        }

        @Override
        public boolean isWarnOnResolutionErrors() {
            return this.warnOnResolutionErrors;
        }

        @Override
        public boolean isWarnOnMissingScm() {
            return this.warnOnMissingScm;
        }

        @Override
        public boolean isIncludeAlreadyBuilt() {
            return this.includeAlreadyBuilt;
        }

        @Override
        public boolean isIncludeOptionalDeps() {
            return this.includeOptionalDeps;
        }

        @Override
        public Collection<String> getHideArtifacts() {
            return this.hideArtifacts;
        }

        @Override
        public boolean isGradleJava8() {
            return this.gradleJava8;
        }

        @Override
        public String getGradleJavaHome() {
            return this.gradleJavaHome;
        }

        @Override
        public ProjectDependencyConfig.Mutable setProductInfo(ProductInfo productInfo) {
            this.productInfo = productInfo;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setProjectBom(ArtifactCoords bom) {
            this.projectBom = bom;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setNonProjectBoms(List<ArtifactCoords> nonProjectBoms) {
            this.nonProjectBoms = nonProjectBoms;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setProjectArtifacts(Collection<ArtifactCoords> projectArtifacts) {
            this.projectArtifacts = projectArtifacts;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable addProjectArtifacts(ArtifactCoords projectArtifact) {
            this.projectArtifacts.add(projectArtifact);
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setIncludeArtifacts(Collection<ArtifactCoords> artifacts) {
            this.includeArtifacts = artifacts;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setIncludePatterns(Collection<ArtifactCoords> artifacts) {
            this.includePatterns = artifacts;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable addIncludePattern(ArtifactCoords artifact) {
            this.includePatterns.add(artifact);
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setExcludePatterns(Collection<ArtifactCoords> artifacts) {
            this.excludePatterns = artifacts;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setExcludeScopes(Collection<String> excludeScopes) {
            this.excludeScopes = excludeScopes;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable addExcludePattern(ArtifactCoords artifact) {
            if (this.excludePatterns.isEmpty()) {
                this.excludePatterns = new ArrayList<ArtifactCoords>();
            }
            this.excludePatterns.add(artifact);
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setIncludeNonManaged(boolean includeNonManaged) {
            this.includeNonManaged = includeNonManaged;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setExcludeParentPoms(boolean excludeParentPoms) {
            this.excludeParentPoms = excludeParentPoms;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setExcludeBomImports(boolean excludeBomImports) {
            this.excludeBomImports = excludeBomImports;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLevel(int level) {
            this.level = level;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setVerboseGraphs(boolean verboseGraphs) {
            this.verboseGraphs = verboseGraphs;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogArtifactsToBuild(boolean logArtifactsToBuild) {
            this.logArtifactsToBuild = logArtifactsToBuild;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogModulesToBuild(boolean logModulesToBuild) {
            this.logModulesToBuild = logModulesToBuild;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogTrees(boolean logTrees) {
            this.logTrees = logTrees;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogTreesFor(String logTreesFor) {
            this.logTreesFor = logTreesFor;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogRemaining(boolean logRemaining) {
            this.logRemaining = logRemaining;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogSummary(boolean logSummary) {
            this.logSummary = logSummary;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogNonManagedVisited(boolean logNonManagedVisited) {
            this.logNonManagedVisited = logNonManagedVisited;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogCodeRepos(boolean logCodeRepos) {
            this.logCodeRepos = logCodeRepos;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLogCodeRepoTree(boolean logCodeRepoTree) {
            this.logCodeRepoTree = logCodeRepoTree;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setRecipeRepos(List<String> recipeRepoUrls) {
            this.recipeRepoUrls = recipeRepoUrls;
            return this;
        }

        @Override
        @Deprecated
        public ProjectDependencyConfig.Mutable setValidateCodeRepoTags(boolean validateTags) {
            this.validateCodeRepoTags = validateTags;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setLegacyScmLocator(boolean legacyScmLocator) {
            this.legacyScmLocator = legacyScmLocator;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setWarnOnResolutionErrors(boolean warn) {
            this.warnOnResolutionErrors = warn;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setWarnOnMissingScm(boolean warnOnMissingScm) {
            this.warnOnMissingScm = warnOnMissingScm;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setIncludeAlreadyBuilt(boolean includeAlreadyBuilt) {
            this.includeAlreadyBuilt = includeAlreadyBuilt;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setIncludeOptionalDeps(boolean includeOptionalDeps) {
            this.includeOptionalDeps = includeOptionalDeps;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setHideArtifacts(Collection<String> hidePatterns) {
            this.hideArtifacts = hidePatterns;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setGradleJava8(boolean java8) {
            this.gradleJava8 = java8;
            return this;
        }

        @Override
        public ProjectDependencyConfig.Mutable setGradleJavaHome(String javaHome) {
            this.gradleJavaHome = javaHome;
            return this;
        }

        @Override
        public ProjectDependencyConfig build() {
            return new ProjectDependencyConfigImpl(this);
        }
    }
}

