/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.domino.ArtifactSet;
import io.quarkus.domino.CircularReleaseDependency;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ReleaseCollection
implements Iterable<ReleaseRepo> {
    private final Collection<ReleaseRepo> releases;

    static List<ReleaseRepo> filter(Collection<ReleaseRepo> repos, ArtifactSet artifactSelector) {
        ArrayList<ReleaseRepo> result = new ArrayList<ReleaseRepo>(repos.size());
        for (ReleaseRepo repo : repos) {
            repo.getArtifacts().keySet().removeIf(artifactCoords -> !artifactSelector.contains((ArtifactCoords)artifactCoords));
            if (repo.getArtifacts().isEmpty()) continue;
            result.add(repo);
        }
        return result;
    }

    static List<ReleaseRepo> sort(Collection<ReleaseRepo> releaseRepos) {
        int codeReposTotal = releaseRepos.size();
        ArrayList<ReleaseRepo> sorted = new ArrayList<ReleaseRepo>(codeReposTotal);
        HashSet<ScmRevision> processedRepos = new HashSet<ScmRevision>(codeReposTotal);
        for (ReleaseRepo r : releaseRepos) {
            if (!r.isRoot()) continue;
            ReleaseCollection.sort(r, processedRepos, sorted);
        }
        return sorted;
    }

    private static void sort(ReleaseRepo repo, Set<ScmRevision> processed, List<ReleaseRepo> sorted) {
        if (!processed.add(repo.revision)) {
            return;
        }
        for (ReleaseRepo d : repo.dependencies.values()) {
            ReleaseCollection.sort(d, processed, sorted);
        }
        sorted.add(repo);
    }

    static Collection<CircularReleaseDependency> detectCircularDependencies(Collection<ReleaseRepo> releaseRepos) {
        HashMap<Set<ScmRevision>, CircularReleaseDependency> circularDeps = new HashMap<Set<ScmRevision>, CircularReleaseDependency>();
        for (ReleaseRepo r : releaseRepos) {
            ArrayList<ScmRevision> chain = new ArrayList<ScmRevision>();
            ReleaseCollection.detectCircularDeps(r, chain, circularDeps);
        }
        return circularDeps.values();
    }

    private static void detectCircularDeps(ReleaseRepo r, List<ScmRevision> chain, Map<Set<ScmRevision>, CircularReleaseDependency> circularDeps) {
        int i = chain.indexOf(r.revision);
        if (i >= 0) {
            ArrayList<ScmRevision> loop = new ArrayList<ScmRevision>(chain.size() - i + 1);
            for (int j = i; j < chain.size(); ++j) {
                loop.add(chain.get(j));
            }
            loop.add(r.revision);
            circularDeps.computeIfAbsent(new HashSet(loop), k -> CircularReleaseDependency.of(loop));
            return;
        }
        chain.add(r.revision);
        for (ReleaseRepo d : r.dependencies.values()) {
            ReleaseCollection.detectCircularDeps(d, chain, circularDeps);
        }
        chain.remove(chain.size() - 1);
    }

    public static ReleaseCollection of(Collection<ReleaseRepo> releaseRepos) {
        return new ReleaseCollection(releaseRepos);
    }

    private ReleaseCollection(Collection<ReleaseRepo> releases) {
        this.releases = releases;
    }

    public ReleaseCollection sort() {
        return new ReleaseCollection(ReleaseCollection.sort(this.releases));
    }

    public Collection<CircularReleaseDependency> getCircularDependencies() {
        return ReleaseCollection.detectCircularDependencies(this.releases);
    }

    @Override
    public Iterator<ReleaseRepo> iterator() {
        return this.releases.iterator();
    }

    public boolean isEmpty() {
        return this.releases.isEmpty();
    }

    public int size() {
        return this.releases.size();
    }

    public Iterable<ReleaseRepo> getRootReleaseRepos() {
        return new Iterable<ReleaseRepo>(){

            @Override
            public Iterator<ReleaseRepo> iterator() {
                return new Iterator<ReleaseRepo>(){
                    final Iterator<ReleaseRepo> i;
                    ReleaseRepo next;
                    {
                        this.i = ReleaseCollection.this.releases.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            while (this.i.hasNext()) {
                                ReleaseRepo n = this.i.next();
                                if (!n.isRoot()) continue;
                                this.next = n;
                                break;
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public ReleaseRepo next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ReleaseRepo n = this.next;
                        this.next = null;
                        return n;
                    }
                };
            }
        };
    }

    Collection<ReleaseRepo> getReleases() {
        return this.releases;
    }
}

