/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.inspect;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.inspect.DependencyTreeRequest;
import io.quarkus.domino.inspect.NonResolvingDependencyTreeBuilder;
import io.quarkus.domino.inspect.ResolvingDependencyTreeBuilder;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class DependencyTreeBuilder {
    private static final Artifact root = new DefaultArtifact("io.domino", "domino-tree-builder", "pom", "1");
    protected final MavenArtifactResolver resolver;

    public static DependencyTreeBuilder resolvingTreeBuilder(MavenArtifactResolver resolver) {
        return new ResolvingDependencyTreeBuilder(resolver);
    }

    public static DependencyTreeBuilder nonResolvingTreeBuilder(MavenArtifactResolver resolver) {
        return new NonResolvingDependencyTreeBuilder(resolver);
    }

    DependencyTreeBuilder(MavenArtifactResolver resolver) {
        this.resolver = Objects.requireNonNull(resolver);
    }

    public DependencyNode buildTree(DependencyTreeRequest root) {
        DependencyNode rootNode = this.doBuildTree(root);
        if (root.isDependency()) {
            if (rootNode.getChildren().size() != 1) {
                throw new RuntimeException("Expected a single child node but got " + String.valueOf(rootNode.getChildren()));
            }
            return (DependencyNode)rootNode.getChildren().get(0);
        }
        return rootNode;
    }

    public abstract DependencyNode doBuildTree(DependencyTreeRequest var1);

    protected CollectRequest createCollectRequest(DependencyTreeRequest root) {
        CollectRequest req = new CollectRequest().setManagedDependencies(root.getConstraints());
        if (root.isPlugin()) {
            try {
                req.setRepositories(this.resolver.getMavenContext().getRemotePluginRepositories());
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException(e);
            }
        } else {
            req.setRepositories(this.resolver.getRepositories());
        }
        Dependency dep = new Dependency(root.getArtifact(), "runtime", Boolean.valueOf(false), root.getExclusions());
        if (root.isDependency()) {
            req.setRootArtifact(DependencyTreeBuilder.root).setDependencies(List.of(dep));
        } else {
            req.setRoot(dep);
        }
        return req;
    }
}

