/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyResolver;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Property;
import org.cyclonedx.util.LicenseResolver;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ManifestGenerator {
    private final BootstrapMavenContext mavenCtx;
    private final MavenArtifactResolver artifactResolver;
    private final ModelBuilder modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
    private final ModelResolver modelResolver;
    private final ModelCache modelCache;
    private final Map<ArtifactCoords, Model> effectiveModels = new HashMap<ArtifactCoords, Model>();
    private final Path outputFile;

    public static Builder builder() {
        return new Builder();
    }

    private ManifestGenerator(Builder builder) {
        this.artifactResolver = builder.getInitializedResolver();
        this.mavenCtx = this.artifactResolver.getMavenContext();
        try {
            this.modelResolver = BootstrapModelResolver.newInstance((BootstrapMavenContext)this.mavenCtx, null);
            this.modelCache = new BootstrapModelCache(this.mavenCtx.getRepositorySystemSession());
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven model resolver", e);
        }
        this.outputFile = builder.outputFile;
    }

    public static void main(String[] args) throws Exception {
        MavenArtifactResolver artifactResolver = ((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).build();
        ProjectDependencyResolver.builder().setArtifactResolver(artifactResolver).setDependencyConfig(ProjectDependencyConfig.builder().setProjectBom(ArtifactCoords.pom((String)"io.vertx", (String)"vertx-dependencies", (String)"4.3.5")).setWarnOnResolutionErrors(true).setIncludeNonManaged(true).build()).build().consumeSorted(ManifestGenerator.builder().setArtifactResolver(artifactResolver).build().toConsumer());
    }

    public Consumer<Collection<ReleaseRepo>> toConsumer() {
        return releases -> {
            Bom bom = new Bom();
            for (ReleaseRepo r : releases) {
                for (Map.Entry<ArtifactCoords, List<RemoteRepository>> entry : r.getArtifacts().entrySet()) {
                    ArtifactCoords coords = entry.getKey();
                    if ("pom".equals(coords.getType())) continue;
                    Model model = this.resolveModel(this.modelResolver, coords, entry.getValue());
                    Component c = new Component();
                    ManifestGenerator.extractMetadata(r, model, c);
                    if (c.getPublisher() == null) {
                        c.setPublisher("central");
                    }
                    c.setGroup(coords.getGroupId());
                    c.setName(coords.getArtifactId());
                    c.setVersion(coords.getVersion());
                    TreeMap<String, String> qualifiers = new TreeMap<String, String>();
                    qualifiers.put("type", coords.getType());
                    if (!coords.getClassifier().isEmpty()) {
                        qualifiers.put("classifier", coords.getClassifier());
                    }
                    try {
                        c.setPurl(new PackageURL("maven", coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), qualifiers, null));
                    }
                    catch (MalformedPackageURLException e) {
                        throw new RuntimeException("Failed to generate Purl for " + coords.toCompactCoords(), e);
                    }
                    Property pkgType = new Property();
                    pkgType.setName("package:type");
                    pkgType.setValue("maven");
                    Property pkgLang = new Property();
                    pkgLang.setName("package:language");
                    pkgLang.setValue("java");
                    c.setProperties(List.of(pkgType, pkgLang));
                    c.setType(Component.Type.LIBRARY);
                    bom.addComponent(c);
                }
            }
            BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)ManifestGenerator.schemaVersion(), (Bom)bom);
            String bomString = bomGenerator.toJsonString();
            if (this.outputFile == null) {
                System.out.println(bomString);
            } else {
                if (this.outputFile.getParent() != null) {
                    try {
                        Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create " + this.outputFile.getParent(), e);
                    }
                }
                try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);){
                    writer.write(bomString);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write to " + this.outputFile, e);
                }
            }
        };
    }

    private static void extractMetadata(ReleaseRepo release, Model project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(ManifestGenerator.resolveMavenLicenses(project.getLicenses(), false));
        }
        if (CycloneDxSchema.Version.VERSION_10 != ManifestGenerator.schemaVersion()) {
            if (project.getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.WEBSITE, project.getUrl(), component);
            }
            if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
            }
            if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    if (list.getArchive() != null) {
                        if (ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                        ManifestGenerator.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                        continue;
                    }
                    if (list.getSubscribe() == null || ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    ManifestGenerator.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
                }
            }
            if (!ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.VCS, release.id().origin().toString(), component);
            }
        }
    }

    private static LicenseChoice resolveMavenLicenses(List<License> projectLicenses, boolean includeLicenseText) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)includeLicenseText);
                resolved = ManifestGenerator.resolveLicenseInfo(licenseChoice, resolvedByName);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)includeLicenseText);
                resolved = ManifestGenerator.resolveLicenseInfo(licenseChoice, resolvedByUrl);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (artifactLicense.getUrl() != null && !artifactLicense.getUrl().isBlank()) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private static boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != ManifestGenerator.schemaVersion()) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    private static CycloneDxSchema.Version schemaVersion() {
        return CycloneDxSchema.Version.VERSION_14;
    }

    private Model resolveModel(ModelResolver modelResolver, ArtifactCoords artifact, List<RemoteRepository> repos) {
        ArtifactCoords pom = artifact.getType().equals("pom") ? artifact : ArtifactCoords.pom((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion());
        return this.effectiveModels.computeIfAbsent(pom, k -> {
            Model rawModel;
            File pomFile;
            try {
                pomFile = this.artifactResolver.resolve((Artifact)new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getClassifier(), pom.getType(), pom.getVersion()), repos).getArtifact().getFile();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve " + pom.toCompactCoords(), e);
            }
            try {
                rawModel = ModelUtils.readModel((Path)pomFile.toPath());
            }
            catch (IOException e1) {
                throw new RuntimeException("Failed to read " + pomFile, e1);
            }
            Parent parent = rawModel.getParent();
            if (parent != null) {
                Path parentPomPath;
                DefaultArtifact parentPom = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "pom", parent.getVersion());
                try {
                    parentPomPath = this.artifactResolver.resolve((Artifact)parentPom, repos).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException("Failed to resolve " + (Artifact)parentPom, e);
                }
                rawModel.getParent().setRelativePath(pomFile.toPath().getParent().relativize(parentPomPath).toString());
            }
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
            req.setPomFile(pomFile);
            req.setRawModel(rawModel);
            req.setModelResolver(modelResolver);
            req.setSystemProperties(System.getProperties());
            req.setUserProperties(System.getProperties());
            req.setModelCache(this.modelCache);
            try {
                return this.modelBuilder.build((ModelBuildingRequest)req).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                throw new RuntimeException("Failed to resolve the effective model of " + pom.toCompactCoords(), e);
            }
        });
    }

    private static boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private static void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    static class BootstrapModelCache
    implements ModelCache {
        private final RepositorySystemSession session;
        private final RepositoryCache cache;

        BootstrapModelCache(RepositorySystemSession session) {
            this.session = session;
            this.cache = session.getCache() == null ? new DefaultRepositoryCache() : session.getCache();
        }

        public Object get(String groupId, String artifactId, String version, String tag) {
            return this.cache.get(this.session, (Object)new Key(groupId, artifactId, version, tag));
        }

        public void put(String groupId, String artifactId, String version, String tag, Object data) {
            this.cache.put(this.session, (Object)new Key(groupId, artifactId, version, tag), data);
        }

        static class Key {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String tag;
            private final int hash;

            public Key(String groupId, String artifactId, String version, String tag) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.tag = tag;
                int h = 17;
                h = h * 31 + this.groupId.hashCode();
                h = h * 31 + this.artifactId.hashCode();
                h = h * 31 + this.version.hashCode();
                this.hash = h = h * 31 + this.tag.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (null == obj || !this.getClass().equals(obj.getClass())) {
                    return false;
                }
                Key that = (Key)obj;
                return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
            }

            public int hashCode() {
                return this.hash;
            }
        }
    }

    public static class Builder {
        private MavenArtifactResolver resolver;
        private Path outputFile;

        private Builder() {
        }

        public Builder setArtifactResolver(MavenArtifactResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder setOutputFile(Path outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public ManifestGenerator build() {
            return new ManifestGenerator(this);
        }

        private MavenArtifactResolver getInitializedResolver() {
            if (this.resolver == null) {
                try {
                    return MavenArtifactResolver.builder().build();
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
                }
            }
            return this.resolver;
        }
    }
}

