/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.domino.ArtifactCoordsPattern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ArtifactSet {
    private static final List<ArtifactCoordsPattern> EMPTY_LIST = Collections.emptyList();
    private static final ArtifactSet INCLUDE_ALL = new ArtifactSet(Collections.singletonList(ArtifactCoordsPattern.matchAll()), EMPTY_LIST);
    private final List<ArtifactCoordsPattern> excludes;
    private final int hashcode;
    private final List<ArtifactCoordsPattern> includes;

    private static void append(List<ArtifactCoordsPattern> cludes, Appendable out) throws IOException {
        boolean first = true;
        for (ArtifactCoordsPattern gavPattern : cludes) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append(gavPattern.toString());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ArtifactSet includeAll() {
        return INCLUDE_ALL;
    }

    private static boolean matches(String groupId, String artifactId, String type, String classifier, String version, List<ArtifactCoordsPattern> patterns) {
        for (ArtifactCoordsPattern pattern : patterns) {
            if (!pattern.matches(groupId, artifactId, classifier, type, version)) continue;
            return true;
        }
        return false;
    }

    ArtifactSet(List<ArtifactCoordsPattern> includes, List<ArtifactCoordsPattern> excludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.hashcode = 31 * (31 + excludes.hashCode()) + includes.hashCode();
    }

    public void appendExcludes(Appendable out) throws IOException {
        ArtifactSet.append(this.excludes, out);
    }

    public void appendIncludes(Appendable out) throws IOException {
        ArtifactSet.append(this.includes, out);
    }

    public boolean contains(String groupId, String artifactId, String type, String classifier, String version) {
        return ArtifactSet.matches(groupId, artifactId, type, classifier, version, this.includes) && !ArtifactSet.matches(groupId, artifactId, type, classifier, version, this.excludes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactSet other = (ArtifactSet)obj;
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        return !(this.includes == null ? other.includes != null : !this.includes.equals(other.includes));
    }

    public List<ArtifactCoordsPattern> getExcludes() {
        return this.excludes;
    }

    public List<ArtifactCoordsPattern> getIncludes() {
        return this.includes;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return "GavSet [excludes=" + this.excludes + ", includes=" + this.includes + "]";
    }

    public static class Builder {
        private List<ArtifactCoordsPattern> excludes = new ArrayList<ArtifactCoordsPattern>();
        private List<ArtifactCoordsPattern> includes = new ArrayList<ArtifactCoordsPattern>();

        private Builder() {
        }

        public ArtifactSet build() {
            if (this.includes.isEmpty()) {
                this.includes.add(ArtifactCoordsPattern.matchAll());
            }
            List<ArtifactCoordsPattern> useIncludes = Collections.unmodifiableList(this.includes);
            List<ArtifactCoordsPattern> useExcludes = Collections.unmodifiableList(this.excludes);
            this.includes = null;
            this.excludes = null;
            return new ArtifactSet(useIncludes, useExcludes);
        }

        public Builder exclude(String rawPattern) {
            this.excludes.add(ArtifactCoordsPattern.of(rawPattern));
            return this;
        }

        public Builder exclude(ArtifactCoordsPattern pattern) {
            this.excludes.add(pattern);
            return this;
        }

        public Builder excludes(Collection<String> rawPatterns) {
            if (rawPatterns != null) {
                for (String rawPattern : rawPatterns) {
                    this.excludes.add(ArtifactCoordsPattern.of(rawPattern));
                }
            }
            return this;
        }

        public Builder excludes(String ... rawPatterns) {
            if (rawPatterns != null) {
                for (String rawPattern : rawPatterns) {
                    this.excludes.add(ArtifactCoordsPattern.of(rawPattern));
                }
            }
            return this;
        }

        public Builder excludes(String rawPatterns) {
            if (rawPatterns != null) {
                StringTokenizer st = new StringTokenizer(rawPatterns, ", \t\n\r\f");
                while (st.hasMoreTokens()) {
                    this.excludes.add(ArtifactCoordsPattern.of(st.nextToken()));
                }
            }
            return this;
        }

        public Builder excludeSnapshots() {
            this.excludes.add(ArtifactCoordsPattern.matchSnapshots());
            return this;
        }

        public Builder include(String rawPattern) {
            this.includes.add(ArtifactCoordsPattern.of(rawPattern));
            return this;
        }

        public Builder include(ArtifactCoordsPattern pattern) {
            this.includes.add(pattern);
            return this;
        }

        public Builder includes(Collection<String> rawPatterns) {
            if (rawPatterns != null) {
                for (String rawPattern : rawPatterns) {
                    this.includes.add(ArtifactCoordsPattern.of(rawPattern));
                }
            }
            return this;
        }

        public Builder includes(String rawPatterns) {
            if (rawPatterns != null) {
                StringTokenizer st = new StringTokenizer(rawPatterns, ", \t\n\r\f");
                while (st.hasMoreTokens()) {
                    this.includes.add(ArtifactCoordsPattern.of(st.nextToken()));
                }
            }
            return this;
        }

        public Builder includes(String ... rawPatterns) {
            if (rawPatterns != null) {
                for (String rawPattern : rawPatterns) {
                    this.includes.add(ArtifactCoordsPattern.of(rawPattern));
                }
            }
            return this;
        }
    }
}

