/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;

public class MavenProjectReader {
    public static List<ArtifactCoords> resolveModuleDependencies(MavenArtifactResolver resolver) {
        LocalWorkspace ws = resolver.getMavenContext().getWorkspace();
        final ArrayList createdDirs = new ArrayList();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                for (Path p : createdDirs) {
                    IoUtils.recursiveDelete((Path)p);
                }
            }
        }));
        ws.getProjects().values().forEach(p -> MavenProjectReader.ensureResolvable(p, createdDirs));
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>();
        for (LocalProject project : ws.getProjects().values()) {
            if (!MavenProjectReader.isPublished(project)) continue;
            String type = project.getRawModel().getPackaging();
            if ("maven-archetype".equals(type)) {
                type = "jar";
            }
            result.add(ArtifactCoords.of((String)project.getGroupId(), (String)project.getArtifactId(), (String)"", (String)type, (String)project.getVersion()));
        }
        return result;
    }

    private static boolean isPublished(LocalProject project) {
        Model model = project.getModelBuildingResult() == null ? project.getRawModel() : project.getModelBuildingResult().getEffectiveModel();
        String skipStr = model.getProperties().getProperty("maven.install.skip");
        if (skipStr != null && Boolean.parseBoolean(skipStr)) {
            return false;
        }
        skipStr = model.getProperties().getProperty("maven.deploy.skip");
        if (skipStr != null && Boolean.parseBoolean(skipStr)) {
            return false;
        }
        if (model.getBuild() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                if (!plugin.getArtifactId().equals("maven-install-plugin") && !plugin.getArtifactId().equals("maven-deploy-plugin")) continue;
                for (PluginExecution e : plugin.getExecutions()) {
                    if (!e.getId().startsWith("default-") || !e.getPhase().equals("none")) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void ensureResolvable(LocalProject project, List<Path> createdDirs) {
        Path classesDir;
        if (!project.getRawModel().getPackaging().equals("pom") && !Files.exists(classesDir = project.getClassesDir(), new LinkOption[0])) {
            Path topDirToCreate = classesDir;
            while (!Files.exists(topDirToCreate.getParent(), new LinkOption[0])) {
                topDirToCreate = topDirToCreate.getParent();
            }
            try {
                Files.createDirectories(classesDir, new FileAttribute[0]);
                createdDirs.add(topDirToCreate);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + classesDir, e);
            }
        }
    }
}

