/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import com.redhat.hacbs.recipies.GAV;
import com.redhat.hacbs.recipies.scm.GitScmLocator;
import com.redhat.hacbs.recipies.scm.RepositoryInfo;
import com.redhat.hacbs.recipies.scm.ScmLocator;
import com.redhat.hacbs.recipies.scm.TagInfo;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.ArtifactCoordsPattern;
import io.quarkus.domino.BuildTool;
import io.quarkus.domino.GradleProjectReader;
import io.quarkus.domino.MavenProjectReader;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.PropertyResolver;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class ProjectDependencyResolver {
    private static final String SCM_LOCATOR_STATS_PROP = "scm-locator-stats";
    private static final String NOT_MANAGED = " [not managed]";
    private final MavenArtifactResolver resolver;
    private final ProjectDependencyConfig config;
    private MessageWriter log;
    private List<ArtifactCoordsPattern> excludeSet = new ArrayList<ArtifactCoordsPattern>();
    private List<ArtifactCoordsPattern> includeSet = new ArrayList<ArtifactCoordsPattern>();
    private PrintStream fileOutput;
    private final Path logOutputFile;
    private final boolean appendOutput;
    private boolean includeTestJars;
    private Function<ArtifactCoords, List<Dependency>> artifactConstraintsProvider;
    private Set<ArtifactCoords> targetBomConstraints;
    private List<Dependency> targetBomManagedDeps;
    private final Map<ArtifactCoords, List<RemoteRepository>> allDepsToBuild = new HashMap<ArtifactCoords, List<RemoteRepository>>();
    private final Set<ArtifactCoords> nonManagedVisited = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> skippedDeps = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> remainingDeps = new HashSet<ArtifactCoords>();
    private final Map<ArtifactCoords, ArtifactDependency> artifactDeps = new HashMap<ArtifactCoords, ArtifactDependency>();
    private final Map<ReleaseId, ReleaseRepo> releaseRepos = new HashMap<ReleaseId, ReleaseRepo>();
    private final Map<ArtifactCoords, Map<String, String>> effectivePomProps = new HashMap<ArtifactCoords, Map<String, String>>();
    private final Map<Set<ReleaseId>, List<ReleaseId>> circularRepoDeps = new HashMap<Set<ReleaseId>, List<ReleaseId>>();
    private Map<ArtifactCoords, DependencyNode> preResolvedRootArtifacts = Map.of();
    private ReleaseId projectReleaseId;

    private static boolean isScmLocatorStats() {
        if (!System.getProperties().containsKey(SCM_LOCATOR_STATS_PROP)) {
            return false;
        }
        String s = System.getProperty(SCM_LOCATOR_STATS_PROP);
        return s == null || Boolean.parseBoolean(s);
    }

    private static ArtifactCoordsPattern toPattern(ArtifactCoords c) {
        ArtifactCoordsPattern.Builder pattern = ArtifactCoordsPattern.builder();
        pattern.groupIdPattern(c.getGroupId());
        pattern.artifactIdPattern(c.getArtifactId());
        if (c.getClassifier() != null && !c.getClassifier().isEmpty()) {
            pattern.classifierPattern(c.getClassifier());
        }
        if (c.getType() != null && !c.getType().isEmpty()) {
            pattern.typePattern(c.getType());
        }
        pattern.versionPattern(c.getVersion());
        return pattern.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ProjectDependencyResolver(Builder builder) {
        this.resolver = builder.getInitializedResolver();
        this.log = builder.getInitializedLog();
        this.artifactConstraintsProvider = builder.artifactConstraintsProvider;
        this.logOutputFile = builder.logOutputFile;
        this.appendOutput = builder.appendOutput;
        this.config = Objects.requireNonNull(builder.depConfig);
        this.config.getExcludePatterns().forEach(p -> this.excludeSet.add(ProjectDependencyResolver.toPattern(p)));
        this.config.getIncludePatterns().forEach(p -> this.includeSet.add(ProjectDependencyResolver.toPattern(p)));
        this.config.getIncludeArtifacts().forEach(c -> this.includeSet.add(ProjectDependencyResolver.toPattern(c)));
    }

    public ProjectDependencyConfig getConfig() {
        return this.config;
    }

    public Collection<ReleaseRepo> getReleaseRepos() {
        this.buildModel();
        this.initReleaseRepos();
        this.detectCircularRepoDeps();
        return new ArrayList<ReleaseRepo>(this.releaseRepos.values());
    }

    public Collection<ReleaseRepo> getSortedReleaseRepos() {
        return ProjectDependencyResolver.sortReleaseRepos(this.getReleaseRepos());
    }

    public void consumeSorted(Consumer<Collection<ReleaseRepo>> consumer) {
        consumer.accept(this.getSortedReleaseRepos());
    }

    public <T> T applyToSorted(Function<Collection<ReleaseRepo>, T> func) {
        return func.apply(this.getSortedReleaseRepos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        boolean logCodeRepos = this.config.isLogCodeRepos() || this.config.isLogCodeRepoTree();
        this.buildModel();
        try {
            List<ReleaseRepo> sorted;
            int codeReposTotal = 0;
            if (this.config.isLogArtifactsToBuild() && !this.allDepsToBuild.isEmpty()) {
                this.logComment("Artifacts to be built from source from " + (this.config.getProjectBom() == null ? "" : this.config.getProjectBom().toCompactCoords()) + ":");
                if (logCodeRepos) {
                    this.initReleaseRepos();
                    this.detectCircularRepoDeps();
                    codeReposTotal = this.releaseRepos.size();
                    sorted = ProjectDependencyResolver.sortReleaseRepos(this.releaseRepos.values());
                    for (ReleaseRepo e : sorted) {
                        this.logComment("repo-url " + e.id().origin());
                        this.logComment("tag " + e.id().version().asString());
                        for (String s : ProjectDependencyResolver.toSortedStrings(e.artifacts.keySet(), this.config.isLogModulesToBuild())) {
                            this.log(s);
                        }
                    }
                    if (!this.circularRepoDeps.isEmpty()) {
                        this.logComment("ERROR: The following circular dependency chains were detected among releases:");
                        Iterator<Object> chains = this.circularRepoDeps.values().iterator();
                        int i = 0;
                        while (chains.hasNext()) {
                            this.logComment("  Chain #" + ++i + ":");
                            ((List)chains.next()).forEach(id -> this.logComment("    " + id));
                            this.logComment("");
                        }
                    }
                    if (this.config.isLogCodeRepoTree()) {
                        this.logComment("");
                        this.logComment("Code repository dependency graph");
                        for (ReleaseRepo r : this.releaseRepos.values()) {
                            if (!r.isRoot()) continue;
                            this.logReleaseRepoDep(r, 0);
                        }
                        this.logComment("");
                    }
                } else {
                    for (String s : ProjectDependencyResolver.toSortedStrings(this.allDepsToBuild.keySet(), this.config.isLogModulesToBuild())) {
                        this.log(s);
                    }
                }
            }
            if (this.config.isLogNonManagedVisitied() && !this.nonManagedVisited.isEmpty()) {
                this.logComment("Non-managed dependencies visited walking dependency trees:");
                sorted = ProjectDependencyResolver.toSortedStrings(this.nonManagedVisited, this.config.isLogModulesToBuild());
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)((Object)sorted.get(i)));
                }
            }
            if (this.config.isLogRemaining()) {
                this.logComment("Remaining artifacts include:");
                sorted = ProjectDependencyResolver.toSortedStrings(this.remainingDeps, this.config.isLogModulesToBuild());
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)((Object)sorted.get(i)));
                }
            }
            if (this.config.isLogSummary()) {
                StringBuilder sb = new StringBuilder().append("Selecting ");
                if (this.config.getLevel() < 0) {
                    sb.append("all the");
                } else {
                    sb.append(this.config.getLevel()).append(" level(s) of");
                }
                if (this.config.isIncludeNonManaged()) {
                    sb.append(" managed and non-managed");
                } else {
                    sb.append(" managed (stopping at the first non-managed one)");
                }
                sb.append(" dependencies of supported extensions");
                if (this.config.getProjectBom() != null) {
                    sb.append(" from ").append(this.config.getProjectBom().toCompactCoords());
                }
                sb.append(" will result in:");
                this.logComment(sb.toString());
                sb.setLength(0);
                sb.append(this.allDepsToBuild.size()).append(" artifacts");
                if (codeReposTotal > 0) {
                    sb.append(" from ").append(codeReposTotal).append(" code repositories");
                }
                sb.append(" to build from source");
                this.logComment(sb.toString());
                if (this.config.isIncludeNonManaged() && !this.nonManagedVisited.isEmpty()) {
                    this.logComment("  * " + this.nonManagedVisited.size() + " of which is/are not managed by the BOM");
                }
                if (!this.skippedDeps.isEmpty()) {
                    this.logComment(this.skippedDeps.size() + " dependency nodes skipped");
                }
                this.logComment(this.allDepsToBuild.size() + this.skippedDeps.size() + " dependencies visited in total");
            }
        }
        finally {
            if (this.fileOutput != null) {
                this.log.info("Saving the report in " + this.logOutputFile.toAbsolutePath());
                this.fileOutput.close();
            }
        }
    }

    private void buildModel() {
        this.targetBomManagedDeps = this.getBomConstraints(this.config.getProjectBom());
        this.targetBomConstraints = new HashSet<ArtifactCoords>(this.targetBomManagedDeps.size());
        for (Dependency d : this.targetBomManagedDeps) {
            this.targetBomConstraints.add(ProjectDependencyResolver.toCoords(d.getArtifact()));
        }
        if (this.artifactConstraintsProvider == null) {
            this.artifactConstraintsProvider = t -> this.targetBomManagedDeps;
        }
        for (ArtifactCoords coords : this.getProjectArtifacts()) {
            if (!this.isIncluded(coords) && this.isExcluded(coords)) continue;
            this.processRootArtifact(coords, this.artifactConstraintsProvider.apply(coords));
        }
        for (ArtifactCoords coords : this.config.getIncludeArtifacts()) {
            if (!this.isIncluded(coords) && this.isExcluded(coords)) continue;
            this.processRootArtifact(coords, this.artifactConstraintsProvider.apply(coords));
        }
        if (!this.config.isIncludeAlreadyBuilt()) {
            this.removeProductizedDeps();
        }
    }

    private static List<ReleaseRepo> sortReleaseRepos(Collection<ReleaseRepo> releaseRepos) {
        int codeReposTotal = releaseRepos.size();
        ArrayList<ReleaseRepo> sorted = new ArrayList<ReleaseRepo>(codeReposTotal);
        HashSet<ReleaseId> processedRepos = new HashSet<ReleaseId>(codeReposTotal);
        for (ReleaseRepo r : releaseRepos) {
            if (!r.isRoot()) continue;
            ProjectDependencyResolver.sort(r, processedRepos, sorted);
        }
        return sorted;
    }

    private static void sort(ReleaseRepo repo, Set<ReleaseId> processed, List<ReleaseRepo> sorted) {
        if (!processed.add(repo.id)) {
            return;
        }
        for (ReleaseRepo d : repo.dependencies.values()) {
            ProjectDependencyResolver.sort(d, processed, sorted);
        }
        sorted.add(repo);
    }

    private void removeProductizedDeps() {
        Set alreadyBuiltKeys = this.allDepsToBuild.keySet().stream().filter(c -> RhVersionPattern.isRhVersion(c.getVersion())).map(ArtifactCoords::getKey).collect(Collectors.toSet());
        if (!alreadyBuiltKeys.isEmpty()) {
            Iterator<ArtifactCoords> i = this.allDepsToBuild.keySet().iterator();
            while (i.hasNext()) {
                ArtifactCoords coords = i.next();
                if (!alreadyBuiltKeys.contains(coords.getKey())) continue;
                i.remove();
                this.artifactDeps.remove(coords);
                this.artifactDeps.values().forEach(d -> d.removeDependency(coords));
            }
        }
    }

    protected Iterable<ArtifactCoords> getProjectArtifacts() {
        if (this.config.getProjectDir() != null) {
            Collection<ArtifactCoords> result;
            BuildTool buildTool = BuildTool.forProjectDir(this.config.getProjectDir());
            if (BuildTool.MAVEN.equals((Object)buildTool)) {
                result = MavenProjectReader.resolveModuleDependencies(this.resolver);
            } else if (BuildTool.GRADLE.equals((Object)buildTool)) {
                this.preResolvedRootArtifacts = GradleProjectReader.resolveModuleDependencies(this.config.getProjectDir(), this.config.isGradleJava8(), this.config.getGradleJavaHome(), this.resolver);
                result = this.preResolvedRootArtifacts.keySet();
                try {
                    Repository gitRepo = Git.open((File)this.config.getProjectDir().toFile()).getRepository();
                    String repoUrl = gitRepo.getConfig().getString("remote", "origin", "url");
                    this.projectReleaseId = ReleaseIdFactory.forScmAndTag((String)repoUrl, (String)gitRepo.getBranch());
                }
                catch (IOException e) {
                    this.log.warn("Failed to determine the Git repository URL: ", new Object[]{e.getLocalizedMessage()});
                    ArtifactCoords a = result.iterator().next();
                    this.projectReleaseId = ReleaseIdFactory.forGav((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
                }
            } else {
                throw new IllegalStateException("Unrecognized build tool " + buildTool);
            }
            return result;
        }
        if (this.config.getProjectArtifacts().isEmpty()) {
            ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>();
            for (ArtifactCoords d : this.targetBomConstraints) {
                if (!d.getGroupId().startsWith(this.config.getProjectBom().getGroupId()) || !d.isJar() || this.isExcluded(d)) continue;
                result.add(d);
                this.log.debug(d.toCompactCoords() + " selected as a top level artifact to build");
            }
            return result;
        }
        return this.config.getProjectArtifacts();
    }

    private void processRootArtifact(ArtifactCoords rootArtifact, List<Dependency> managedDeps) {
        boolean addDependency;
        DependencyNode root = this.collectDependencies(rootArtifact, managedDeps);
        if (root == null) {
            return;
        }
        if (this.config.isLogTrees()) {
            if (this.targetBomConstraints.contains(rootArtifact)) {
                this.logComment(rootArtifact.toCompactCoords());
            } else {
                this.logComment(rootArtifact.toCompactCoords() + NOT_MANAGED);
            }
        }
        try {
            addDependency = this.addDependencyToBuild(rootArtifact, root);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process " + rootArtifact, e);
        }
        if (addDependency) {
            ArtifactDependency extDep = this.getOrCreateArtifactDep(rootArtifact);
            if (!this.config.isExcludeParentPoms() && this.config.isLogTrees()) {
                extDep.logBomImportsAndParents();
            }
            for (DependencyNode d : root.getChildren()) {
                if (d.getDependency().isOptional() && !this.config.isIncludeOptionalDeps() && !this.isIncluded(ProjectDependencyResolver.toCoords(d.getArtifact()))) continue;
                this.processNodes(extDep, d, 1, false);
            }
        } else if (this.config.isLogRemaining()) {
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(null, d, 1, true);
            }
        }
        if (this.config.isLogTrees()) {
            this.logComment("");
        }
    }

    private DependencyNode collectDependencies(ArtifactCoords coords, List<Dependency> managedDeps) {
        DependencyNode root = this.preResolvedRootArtifacts.get(coords);
        if (root != null) {
            return root;
        }
        try {
            DefaultArtifact a = ProjectDependencyResolver.toAetherArtifact(coords);
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), new CollectRequest().setManagedDependencies(managedDeps).setRepositories(this.resolver.getRepositories()).setRoot(new Dependency((Artifact)a, "runtime"))).getRoot();
            if (root.getChildren().isEmpty()) {
                this.resolver.resolve((Artifact)a);
            }
        }
        catch (Exception e) {
            if (this.config.isWarnOnResolutionErrors()) {
                this.log.warn(e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage());
                this.allDepsToBuild.remove(coords);
                return null;
            }
            throw new RuntimeException("Failed to collect dependencies of " + coords.toCompactCoords(), e);
        }
        return root;
    }

    private static DefaultArtifact toAetherArtifact(ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private void initReleaseRepos() {
        ReleaseIdResolver idResolver = ProjectDependencyResolver.newReleaseIdResolver(this.resolver, this.log, this.config, this.getRhCoordsUpstreamVersions());
        HashMap<ArtifactCoords, ReleaseId> artifactReleases = new HashMap<ArtifactCoords, ReleaseId>();
        for (Map.Entry<ArtifactCoords, List<RemoteRepository>> c : this.allDepsToBuild.entrySet()) {
            ReleaseId releaseId;
            if (this.preResolvedRootArtifacts.containsKey(c.getKey())) {
                releaseId = this.projectReleaseId;
            } else {
                try {
                    releaseId = idResolver.releaseId((Artifact)ProjectDependencyResolver.toAetherArtifact(c.getKey()), c.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to resolve release id for " + c, e);
                }
            }
            this.getOrCreateRepo((ReleaseId)releaseId).artifacts.put(c.getKey(), c.getValue());
            artifactReleases.put(c.getKey(), releaseId);
        }
        Iterator<Map.Entry<ReleaseId, ReleaseRepo>> i = this.releaseRepos.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getValue().artifacts.isEmpty()) continue;
            i.remove();
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            List directDeps;
            ArtifactCoords c = d.coords;
            try {
                directDeps = this.resolver.resolveDescriptor((Artifact)new DefaultArtifact(c.getGroupId(), c.getArtifactId(), "pom", c.getVersion())).getDependencies();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve artifact descriptor for " + c, e);
            }
            for (Dependency directDep : directDeps) {
                Artifact a = directDep.getArtifact();
                ArtifactDependency dirArt = this.artifactDeps.get(ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion()));
                if (dirArt == null) continue;
                d.addDependency(dirArt);
            }
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ReleaseRepo repo = this.getRepo((ReleaseId)artifactReleases.get(d.coords));
            for (ArtifactDependency c : d.getAllDependencies()) {
                repo.addRepoDependency(this.getRepo((ReleaseId)artifactReleases.get(c.coords)));
            }
        }
    }

    private Map<ArtifactCoords, String> getRhCoordsUpstreamVersions() {
        if (!this.config.isIncludeAlreadyBuilt()) {
            return Map.of();
        }
        HashMap<String, List> upstreamVersions = new HashMap<String, List>();
        ArrayList<ArtifactCoords> rhCoords = new ArrayList<ArtifactCoords>();
        ArrayList<ArtifactCoords> allCoords = new ArrayList<ArtifactCoords>(this.allDepsToBuild.size());
        for (ArtifactCoords c : this.allDepsToBuild.keySet()) {
            if (RhVersionPattern.isRhVersion(c.getVersion())) {
                rhCoords.add(c);
                if (allCoords.isEmpty()) continue;
                for (ArtifactCoords coords : allCoords) {
                    upstreamVersions.computeIfAbsent(coords.getGroupId(), k -> new ArrayList()).add(new DefaultArtifactVersion(coords.getVersion()));
                }
                allCoords.clear();
                continue;
            }
            if (rhCoords.isEmpty()) {
                allCoords.add(c);
                continue;
            }
            upstreamVersions.computeIfAbsent(c.getGroupId(), k -> new ArrayList()).add(new DefaultArtifactVersion(c.getVersion()));
        }
        if (rhCoords.isEmpty()) {
            return Map.of();
        }
        HashMap<ArtifactCoords, String> rhCoordsUpstreamVersions = new HashMap<ArtifactCoords, String>(rhCoords.size());
        block4: for (ArtifactCoords c : rhCoords) {
            List originalVersions = (List)upstreamVersions.get(c.getGroupId());
            if (originalVersions == null) continue;
            DefaultArtifactVersion noRhSuffixVersion = new DefaultArtifactVersion(RhVersionPattern.ensureNoRhSuffix(c.getVersion()));
            for (ArtifactVersion v : originalVersions) {
                if (!v.equals(noRhSuffixVersion)) continue;
                try {
                    this.resolver.resolve((Artifact)new DefaultArtifact(c.getGroupId(), c.getArtifactId(), c.getClassifier(), c.getType(), v.toString()));
                    rhCoordsUpstreamVersions.put(c, v.toString());
                }
                catch (BootstrapMavenException e) {
                    rhCoordsUpstreamVersions.put(c, noRhSuffixVersion.toString());
                }
                continue block4;
            }
        }
        return rhCoordsUpstreamVersions;
    }

    private static ReleaseIdResolver newReleaseIdResolver(MavenArtifactResolver artifactResolver, final MessageWriter log, ProjectDependencyConfig config, Map<ArtifactCoords, String> versionMapping) {
        if (config.isLegacyScmLocator()) {
            return ProjectDependencyResolver.getLegacyReleaseIdResolver(artifactResolver, log, config.isValidateCodeRepoTags(), versionMapping);
        }
        final List releaseDetectors = ServiceLoader.load(ReleaseIdDetector.class).stream().map(p -> (ReleaseIdDetector)p.get()).collect(Collectors.toList());
        final AtomicReference<ReleaseIdResolver> ref = new AtomicReference<ReleaseIdResolver>();
        GitScmLocator scmLocator = GitScmLocator.builder().setRecipeRepos(config.getRecipeRepos()).setCacheRepoTags(true).setFallback(new ScmLocator(){

            public TagInfo resolveTagInfo(GAV gav) {
                DefaultArtifact pomArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "pom", gav.getVersion());
                ReleaseId releaseId = null;
                for (ReleaseIdDetector rd : releaseDetectors) {
                    try {
                        ReleaseId rid = rd.detectReleaseId((ReleaseIdResolver)ref.get(), (Artifact)pomArtifact);
                        if (releaseId == null || !releaseId.origin().isUrl() || !releaseId.origin().toString().contains("git")) continue;
                        releaseId = rid;
                        break;
                    }
                    catch (BomDecomposerException e) {
                        log.warn("Failed to determine SCM for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + ": " + e.getLocalizedMessage());
                    }
                }
                if (releaseId == null) {
                    try {
                        releaseId = ((ReleaseIdResolver)ref.get()).defaultReleaseId((Artifact)pomArtifact);
                    }
                    catch (BomDecomposerException e) {
                        log.warn("Failed to determine SCM for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + " from POM metadata: " + e.getLocalizedMessage());
                    }
                }
                if (releaseId != null && releaseId.origin().isUrl() && releaseId.origin().toString().contains("git")) {
                    log.warn("The SCM recipe database is missing an entry for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + ", " + releaseId + " will be used as a fallback");
                    return new TagInfo(new RepositoryInfo("git", releaseId.origin().toString()), releaseId.version().asString(), null);
                }
                return null;
            }
        }).build();
        boolean scmLocatorStats = ProjectDependencyResolver.isScmLocatorStats();
        ReleaseIdDetector hacbsScmLocator = new ReleaseIdDetector((ScmLocator)scmLocator, scmLocatorStats, config, log){
            int total;
            int succeeded;
            final /* synthetic */ ScmLocator val$scmLocator;
            final /* synthetic */ boolean val$scmLocatorStats;
            final /* synthetic */ ProjectDependencyConfig val$config;
            final /* synthetic */ MessageWriter val$log;
            {
                this.val$scmLocator = scmLocator;
                this.val$scmLocatorStats = bl;
                this.val$config = projectDependencyConfig;
                this.val$log = messageWriter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
                GAV gav = new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                ++this.total;
                Exception error = null;
                try {
                    TagInfo tag = this.val$scmLocator.resolveTagInfo(gav);
                    if (tag != null) {
                        ++this.succeeded;
                        ReleaseId releaseId = ReleaseIdFactory.forScmAndTag((String)tag.getRepoInfo().getUri(), (String)tag.getTag());
                        return releaseId;
                    }
                }
                catch (Exception e) {
                    error = e;
                }
                finally {
                    if (this.val$scmLocatorStats) {
                        System.out.println("ScmLocator resolved " + this.succeeded + " out of " + this.total);
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to determine SCM for ").append(artifact);
                if (this.val$config.isWarnOnMissingScm()) {
                    if (error != null) {
                        sb.append(": ").append(error.getLocalizedMessage());
                    }
                } else {
                    throw new RuntimeException(sb.toString(), error);
                }
                this.val$log.warn(sb.toString());
                return null;
            }
        };
        ReleaseIdResolver releaseResolver = new ReleaseIdResolver(artifactResolver, List.of(hacbsScmLocator), log, config.isValidateCodeRepoTags(), versionMapping);
        ref.set(releaseResolver);
        return releaseResolver;
    }

    private static ReleaseIdResolver getLegacyReleaseIdResolver(MavenArtifactResolver artifactResolver, MessageWriter log, boolean validateCodeRepoTags, Map<ArtifactCoords, String> versionMapping) {
        ArrayList<3> releaseDetectors = new ArrayList<3>();
        releaseDetectors.add(new ReleaseIdDetector(){
            final Set<String> artifactIdRepos = Set.of("vertx-service-proxy", "vertx-amqp-client", "vertx-health-check", "vertx-camel-bridge", "vertx-redis-client", "vertx-json-schema", "vertx-lang-groovy", "vertx-mail-client", "vertx-http-service-factory", "vertx-tcp-eventbus-bridge", "vertx-dropwizard-metrics", "vertx-consul-client", "vertx-maven-service-factory", "vertx-cassandra-client", "vertx-circuit-breaker", "vertx-jdbc-client", "vertx-reactive-streams", "vertx-rabbitmq-client", "vertx-mongo-client", "vertx-sockjs-service-proxy", "vertx-kafka-client", "vertx-micrometer-metrics", "vertx-service-factory");

            public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
                if (!"io.vertx".equals(artifact.getGroupId())) {
                    return null;
                }
                String s = artifact.getArtifactId();
                if (!s.startsWith("vertx-")) {
                    return releaseResolver.defaultReleaseId(artifact);
                }
                if (s.equals("vertx-uri-template") || s.equals("vertx-codegen") || s.equals("vertx-http-proxy")) {
                    return ReleaseIdFactory.forScmAndTag((String)("https://github.com/eclipse-vertx/" + s), (String)artifact.getVersion());
                }
                if (s.equals("vertx-core")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vert.x", (String)artifact.getVersion());
                }
                if (s.startsWith("vertx-tracing") || s.equals("vertx-opentelemetry") || s.equals("vertx-opentracing") || s.equals("vertx-zipkin")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vertx-tracing", (String)artifact.getVersion());
                }
                ReleaseId defaultReleaseId = releaseResolver.defaultReleaseId(artifact);
                if (defaultReleaseId.origin().toString().endsWith("vertx-sql-client")) {
                    return defaultReleaseId;
                }
                if (s.startsWith("vertx-ext")) {
                    s = "vertx-ext-parent";
                } else if (!this.artifactIdRepos.contains(s)) {
                    int i;
                    if (s.startsWith("vertx-lang-kotlin")) {
                        s = "vertx-lang-kotlin";
                    } else if (s.startsWith("vertx-service-discovery")) {
                        s = "vertx-service-discovery";
                    } else if (s.equals("vertx-template-engines")) {
                        s = "vertx-web";
                    } else if (s.equals("vertx-web-sstore-infinispan")) {
                        s = "vertx-infinispan";
                    } else if (s.startsWith("vertx-junit5-rx")) {
                        s = "vertx-rx";
                    } else if (!s.equals("vertx-bridge-common") && (i = s.indexOf(45, "vertx-".length())) > 0) {
                        s = s.substring(0, i);
                    }
                }
                return ReleaseIdFactory.forScmAndTag((String)("https://github.com/vert-x3/" + s), (String)artifact.getVersion());
            }
        });
        releaseDetectors.addAll(ServiceLoader.load(ReleaseIdDetector.class).stream().map(p -> (ReleaseIdDetector)p.get()).collect(Collectors.toList()));
        return new ReleaseIdResolver(artifactResolver, releaseDetectors, log, validateCodeRepoTags, versionMapping);
    }

    private void logReleaseRepoDep(ReleaseRepo repo, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(repo.id().origin()).append(' ').append(repo.id().version());
        this.logComment(sb.toString());
        for (ReleaseRepo child : repo.dependencies.values()) {
            this.logReleaseRepoDep(child, depth + 1);
        }
    }

    private static List<String> toSortedStrings(Collection<ArtifactCoords> coords, boolean asModules) {
        ArrayList<String> list;
        if (asModules) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (ArtifactCoords c : coords) {
                set.add((CallSite)((Object)(c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion())));
            }
            list = new ArrayList(set);
        } else {
            list = new ArrayList<String>(coords.size());
            for (ArtifactCoords c : coords) {
                list.add(c.toGACTVString());
            }
        }
        Collections.sort(list);
        return list;
    }

    private PrintStream getOutput() {
        if (this.logOutputFile == null) {
            return System.out;
        }
        if (this.fileOutput == null) {
            try {
                OpenOption[] openOptionArray;
                if (this.logOutputFile.getParent() != null) {
                    Files.createDirectories(this.logOutputFile.getParent(), new FileAttribute[0]);
                }
                if (this.appendOutput) {
                    OpenOption[] openOptionArray2 = new OpenOption[2];
                    openOptionArray2[0] = StandardOpenOption.CREATE;
                    openOptionArray = openOptionArray2;
                    openOptionArray2[1] = StandardOpenOption.APPEND;
                } else {
                    openOptionArray = new OpenOption[]{};
                }
                OpenOption[] oo = openOptionArray;
                this.fileOutput = new PrintStream(Files.newOutputStream(this.logOutputFile, oo), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open " + this.logOutputFile + " for writing", e);
            }
        }
        return this.fileOutput;
    }

    private void logComment(String msg) {
        this.log("# " + msg);
    }

    private void log(String msg) {
        this.getOutput().println(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNodes(ArtifactDependency parent, DependencyNode node, int level, boolean remaining) {
        ArtifactCoords coords = ProjectDependencyResolver.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        ArtifactDependency artDep = null;
        if (remaining) {
            this.addToRemaining(coords);
        } else if (this.config.getLevel() < 0 || level <= this.config.getLevel()) {
            if (this.addDependencyToBuild(coords, node)) {
                if (this.config.isLogTrees()) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < level; ++i) {
                        buf.append("  ");
                    }
                    buf.append(coords.toCompactCoords());
                    if (!this.targetBomConstraints.contains(coords)) {
                        buf.append(' ').append(NOT_MANAGED);
                    }
                    this.logComment(buf.toString());
                }
                if (parent != null) {
                    artDep = this.getOrCreateArtifactDep(coords);
                    parent.addDependency(artDep);
                    if (this.config.isLogTrees()) {
                        artDep.logBomImportsAndParents(level + 1);
                    }
                }
            } else {
                if (!this.config.isLogRemaining()) return;
                remaining = true;
            }
        } else {
            this.addToSkipped(coords);
            if (!this.config.isLogRemaining()) return;
            remaining = true;
            this.addToRemaining(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(artDep, child, level + 1, remaining);
        }
    }

    private boolean addDependencyToBuild(ArtifactCoords coords, DependencyNode node) {
        if (!this.addArtifactToBuild(coords, node.getRepositories())) {
            return false;
        }
        if (!this.config.isExcludeParentPoms() && !this.isExcludeParentPoms(coords)) {
            this.addImportedBomsAndParentPomToBuild(coords, node);
        }
        return true;
    }

    private boolean isExcludeParentPoms(ArtifactCoords coords) {
        return this.preResolvedRootArtifacts.containsKey(coords);
    }

    private boolean addArtifactToBuild(ArtifactCoords coords, List<RemoteRepository> repos) {
        boolean managed = this.targetBomConstraints.contains(coords);
        if (!managed) {
            this.nonManagedVisited.add(coords);
        }
        if (managed || this.config.isIncludeNonManaged() || this.isIncluded(coords) || !this.config.isExcludeParentPoms() && coords.getType().equals("pom")) {
            this.allDepsToBuild.put(coords, repos);
            this.skippedDeps.remove(coords);
            this.remainingDeps.remove(coords);
            return true;
        }
        this.addToSkipped(coords);
        if (this.config.isLogRemaining()) {
            this.addToRemaining(coords);
        }
        return false;
    }

    private Map<String, String> addImportedBomsAndParentPomToBuild(ArtifactCoords coords, DependencyNode node) {
        Model model;
        Path pomXml;
        ArtifactCoords pomCoords;
        ArtifactCoords artifactCoords = pomCoords = coords.getType().equals("pom") ? coords : ArtifactCoords.pom((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion());
        if (this.allDepsToBuild.containsKey(pomCoords)) {
            return this.effectivePomProps.getOrDefault(pomCoords, Map.of());
        }
        try {
            pomXml = this.resolver.resolve((Artifact)ProjectDependencyResolver.toAetherArtifact(pomCoords), node.getRepositories()).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            if (this.config.isWarnOnResolutionErrors()) {
                this.log.warn(e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage());
                this.allDepsToBuild.remove(pomCoords);
                return Map.of();
            }
            throw new IllegalStateException("Failed to resolve " + pomCoords, e);
        }
        try {
            model = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + pomXml, e);
        }
        ArtifactDependency artDep = this.getOrCreateArtifactDep(coords);
        Map<String, String> parentPomProps = null;
        Parent parent = model.getParent();
        if (parent != null) {
            ArtifactCoords parentPomCoords;
            String parentVersion = parent.getVersion();
            if (ModelUtils.isUnresolvedVersion((String)parentVersion)) {
                if (model.getVersion() == null || model.getVersion().equals(parentVersion)) {
                    parentVersion = pomCoords.getVersion();
                } else {
                    this.log.warn("Failed to resolve the version of" + parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " as a parent of " + pomCoords);
                    parentVersion = null;
                }
            }
            if (parentVersion != null && !this.isExcluded(parentPomCoords = ArtifactCoords.pom((String)parent.getGroupId(), (String)parent.getArtifactId(), (String)parentVersion))) {
                artDep.setParentPom(this.getOrCreateArtifactDep(parentPomCoords));
                parentPomProps = this.addImportedBomsAndParentPomToBuild(parentPomCoords, node);
                this.addArtifactToBuild(parentPomCoords, node.getRepositories());
            }
        }
        if (this.config.isExcludeBomImports()) {
            return Map.of();
        }
        Map<String, String> pomProps = ProjectDependencyResolver.toMap(model.getProperties());
        for (Profile profile : model.getProfiles()) {
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault() || profile.getProperties().isEmpty()) continue;
            ProjectDependencyResolver.addAll(pomProps, profile.getProperties());
        }
        pomProps.put("project.version", pomCoords.getVersion());
        pomProps.put("project.groupId", pomCoords.getGroupId());
        if (parentPomProps != null) {
            HashMap<String, String> tmp = new HashMap<String, String>(parentPomProps.size() + pomProps.size());
            tmp.putAll(parentPomProps);
            tmp.putAll(pomProps);
            pomProps = tmp;
        }
        this.effectivePomProps.put(pomCoords, pomProps);
        this.addImportedBomsToBuild(artDep, model, pomProps, node);
        return pomProps;
    }

    private void addImportedBomsToBuild(ArtifactDependency pomArtDep, Model model, Map<String, String> effectiveProps, DependencyNode node) {
        DependencyManagement dm = model.getDependencyManagement();
        if (dm == null) {
            return;
        }
        for (org.apache.maven.model.Dependency d : dm.getDependencies()) {
            ArtifactCoords bomCoords;
            if (!"import".equals(d.getScope()) || !"pom".equals(d.getType())) continue;
            String groupId = this.resolveProperty(d.getGroupId(), d, effectiveProps);
            String artifactId = this.resolveProperty(d.getArtifactId(), d, effectiveProps);
            String version = this.resolveProperty(d.getVersion(), d, effectiveProps);
            if (groupId == null || version == null || artifactId == null || this.isExcluded(bomCoords = ArtifactCoords.pom((String)groupId, (String)artifactId, (String)version))) continue;
            if (pomArtDep != null) {
                ArtifactDependency bomDep = this.getOrCreateArtifactDep(bomCoords);
                pomArtDep.addBomImport(bomDep);
            }
            this.addImportedBomsAndParentPomToBuild(bomCoords, node);
            this.addArtifactToBuild(bomCoords, node.getRepositories());
        }
    }

    private String resolveProperty(String expr, org.apache.maven.model.Dependency dep, Map<String, String> props) {
        String value = PropertyResolver.resolvePropertyOrNull(expr, props);
        if (value == null) {
            this.log.warn("Failed to resolve property " + expr + " from " + dep);
            throw new RuntimeException();
        }
        return value;
    }

    private void addToSkipped(ArtifactCoords coords) {
        if (!this.allDepsToBuild.containsKey(coords)) {
            this.skippedDeps.add(coords);
        }
    }

    private void addToRemaining(ArtifactCoords coords) {
        if (!this.allDepsToBuild.containsKey(coords)) {
            this.remainingDeps.add(coords);
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        for (ArtifactCoordsPattern pattern : this.excludeSet) {
            boolean matches = pattern.matches(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
            if (!matches) continue;
            return true;
        }
        return !this.includeTestJars && coords.getClassifier().equals("tests");
    }

    private boolean isIncluded(ArtifactCoords coords) {
        for (ArtifactCoordsPattern pattern : this.includeSet) {
            if (!pattern.matches(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion())) continue;
            return true;
        }
        return false;
    }

    private List<Dependency> getBomConstraints(ArtifactCoords bomCoords) {
        List managedDeps;
        if (bomCoords == null) {
            return List.of();
        }
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve the descriptor of " + bomCoords, e);
        }
        if (managedDeps.isEmpty()) {
            throw new RuntimeException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ArtifactDependency getOrCreateArtifactDep(ArtifactCoords c) {
        return this.artifactDeps.computeIfAbsent(c, k -> new ArtifactDependency(c));
    }

    private ReleaseRepo getOrCreateRepo(ReleaseId id) {
        return this.releaseRepos.computeIfAbsent(id, k -> new ReleaseRepo(id));
    }

    private ReleaseRepo getRepo(ReleaseId id) {
        return Objects.requireNonNull(this.releaseRepos.get(id));
    }

    private void detectCircularRepoDeps() {
        for (ReleaseRepo r : this.releaseRepos.values()) {
            ArrayList<ReleaseId> chain = new ArrayList<ReleaseId>();
            this.detectCircularRepoDeps(r, chain);
        }
    }

    private void detectCircularRepoDeps(ReleaseRepo r, List<ReleaseId> chain) {
        int i = chain.indexOf(r.id);
        if (i >= 0) {
            ArrayList<ReleaseId> loop = new ArrayList<ReleaseId>(chain.size() - i + 1);
            for (int j = i; j < chain.size(); ++j) {
                loop.add(chain.get(j));
            }
            loop.add(r.id);
            this.circularRepoDeps.computeIfAbsent(new HashSet(loop), k -> loop);
            return;
        }
        chain.add(r.id);
        for (ReleaseRepo d : r.dependencies.values()) {
            this.detectCircularRepoDeps(d, chain);
        }
        chain.remove(chain.size() - 1);
    }

    private static Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(ProjectDependencyResolver.toString(e.getKey()), ProjectDependencyResolver.toString(e.getValue()));
        }
        return map;
    }

    private static void addAll(Map<String, String> map, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(ProjectDependencyResolver.toString(e.getKey()), ProjectDependencyResolver.toString(e.getValue()));
        }
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private class ArtifactDependency {
        final ArtifactCoords coords;
        final Map<ArtifactCoords, ArtifactDependency> children = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        final Map<ArtifactCoords, ArtifactDependency> bomImports = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        ArtifactDependency parentPom;

        ArtifactDependency(ArtifactCoords coords) {
            this.coords = coords;
        }

        public void addBomImport(ArtifactDependency bomDep) {
            this.bomImports.put(bomDep.coords, bomDep);
        }

        public void setParentPom(ArtifactDependency parentPom) {
            this.parentPom = parentPom;
        }

        void addDependency(ArtifactDependency d) {
            this.children.putIfAbsent(d.coords, d);
        }

        Iterable<ArtifactDependency> getAllDependencies() {
            ArrayList<ArtifactDependency> list = new ArrayList<ArtifactDependency>(this.children.size() + this.bomImports.size() + 1);
            if (this.parentPom != null) {
                list.add(this.parentPom);
            }
            list.addAll(this.bomImports.values());
            list.addAll(this.children.values());
            return list;
        }

        private void removeDependency(ArtifactCoords coords) {
            if (this.children.remove(coords) != null) {
                return;
            }
            if (this.bomImports.remove(coords) != null) {
                return;
            }
            if (this.parentPom != null && this.parentPom.coords.equals(coords)) {
                this.parentPom = null;
            }
        }

        private void logBomImportsAndParents() {
            this.logBomImportsAndParents(1);
        }

        private void logBomImportsAndParents(int depth) {
            if (this.parentPom == null && this.bomImports.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            String offset = sb.toString();
            if (this.parentPom != null) {
                sb.setLength(0);
                sb.append(offset).append(this.parentPom.coords.toCompactCoords()).append(" [parent pom]");
                ProjectDependencyResolver.this.logComment(sb.toString());
                this.parentPom.logBomImportsAndParents(depth + 1);
            }
            for (ArtifactDependency d : this.bomImports.values()) {
                sb.setLength(0);
                sb.append(offset).append(d.coords.toCompactCoords()).append(" [bom import]");
                ProjectDependencyResolver.this.logComment(sb.toString());
                d.logBomImportsAndParents(depth + 1);
            }
        }
    }

    public static class Builder {
        private MavenArtifactResolver resolver;
        private Function<ArtifactCoords, List<Dependency>> artifactConstraintsProvider;
        private MessageWriter log;
        private ProjectDependencyConfig depConfig;
        private Path logOutputFile;
        private boolean appendOutput;

        private Builder() {
        }

        private Builder(ProjectDependencyConfig config) {
            this.depConfig = config;
        }

        public Builder setArtifactResolver(MavenArtifactResolver artifactResolver) {
            this.resolver = artifactResolver;
            return this;
        }

        public Builder setArtifactConstraintsProvider(Function<ArtifactCoords, List<Dependency>> constraintsProvider) {
            this.artifactConstraintsProvider = constraintsProvider;
            return this;
        }

        public Builder setMessageWriter(MessageWriter msgWriter) {
            this.log = msgWriter;
            return this;
        }

        public Builder setLogOutputFile(Path file) {
            this.logOutputFile = file;
            return this;
        }

        public Builder setAppendOutput(boolean appendOutput) {
            this.appendOutput = appendOutput;
            return this;
        }

        public Builder setDependencyConfig(ProjectDependencyConfig depConfig) {
            this.depConfig = depConfig;
            return this;
        }

        public ProjectDependencyResolver build() {
            return new ProjectDependencyResolver(this);
        }

        private MavenArtifactResolver getInitializedResolver() {
            if (this.resolver == null) {
                try {
                    if (this.depConfig == null || this.depConfig.getProjectDir() == null) {
                        return ((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).build();
                    }
                    return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setCurrentProject(this.depConfig.getProjectDir().toString())).setEffectiveModelBuilder(true)).setPreferPomsFromWorkspace(true)).build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
                }
            }
            return this.resolver;
        }

        private MessageWriter getInitializedLog() {
            return this.log == null ? MessageWriter.info() : this.log;
        }
    }
}

