/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.manifest.PncArtifactBuildInfo;
import io.quarkus.domino.manifest.SbomTransformContext;
import io.quarkus.domino.manifest.SbomTransformer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.TreeMap;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.Property;
import org.jboss.logging.Logger;

public class PncSbomTransformer
implements SbomTransformer {
    private static final String PNC = "PNC";
    private static final String BUILD_SYSTEM = "build-system";
    private static final String BUILD_ID = "build-id";
    private static final String PUBLISHER = "redhat";
    private static final String MRRC_URL = "https://maven.repository.redhat.com/ga/";
    private static final Logger log = Logger.getLogger(PncSbomTransformer.class);

    @Override
    public Bom transform(SbomTransformContext ctx) {
        log.info((Object)"Adding PNC build info to a manifest");
        Bom bom = ctx.getOriginalBom();
        if (bom.getComponents() == null) {
            return bom;
        }
        for (Component c : bom.getComponents()) {
            PncArtifactBuildInfo buildInfo;
            URL url;
            PackageURL purl;
            if (!RhVersionPattern.isRhVersion(c.getVersion())) continue;
            TreeMap<String, String> qualifiers = new TreeMap<String, String>();
            qualifiers.put("type", "pom");
            try {
                purl = new PackageURL("maven", c.getGroup(), c.getName(), c.getVersion(), qualifiers, null);
            }
            catch (MalformedPackageURLException e) {
                throw new RuntimeException("Failed to generate Purl for " + c, e);
            }
            try {
                url = new URL("https", "orch.psi.redhat.com", 443, "/pnc-rest/v2/artifacts?q=purl==%22" + purl + "%22");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to parse URL", e);
            }
            try {
                URLConnection connection = url.openConnection();
                buildInfo = PncArtifactBuildInfo.deserialize(connection.getInputStream());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to connect to " + url, e);
            }
            PncArtifactBuildInfo.Content content = PncSbomTransformer.getContent(buildInfo);
            if (content == null) {
                log.warn((Object)("PNC build info not found for " + url));
            } else {
                ArrayList<Hash> hashes = new ArrayList<Hash>(3);
                if (content.getMd5() != null) {
                    hashes.add(new Hash(Hash.Algorithm.MD5, content.getMd5()));
                }
                if (content.getSha1() != null) {
                    hashes.add(new Hash(Hash.Algorithm.SHA1, content.getSha1()));
                }
                if (content.getSha256() != null) {
                    hashes.add(new Hash(Hash.Algorithm.SHA_256, content.getSha256()));
                }
                c.setHashes(hashes);
                if (content.getBuild() == null) {
                    log.warn((Object)("PNC build info not found for " + url));
                } else {
                    ArrayList<Property> props = new ArrayList<Property>(c.getProperties());
                    Property prop = new Property();
                    prop.setName(BUILD_ID);
                    prop.setValue(content.getBuild().getId());
                    props.add(prop);
                    prop = new Property();
                    prop.setName(BUILD_SYSTEM);
                    prop.setValue(PNC);
                    props.add(prop);
                    c.setProperties(props);
                }
            }
            this.addMrrc(c);
        }
        return bom;
    }

    private void addMrrc(Component c) {
        c.setPublisher(PUBLISHER);
        ArrayList<ExternalReference> externalRefs = new ArrayList<ExternalReference>(c.getExternalReferences());
        ExternalReference dist = null;
        for (ExternalReference r : externalRefs) {
            if (!r.getType().equals((Object)ExternalReference.Type.DISTRIBUTION)) continue;
            dist = r;
            break;
        }
        if (dist == null) {
            dist = new ExternalReference();
            dist.setType(ExternalReference.Type.DISTRIBUTION);
            externalRefs.add(dist);
        }
        dist.setUrl(MRRC_URL);
        c.setExternalReferences(externalRefs);
    }

    private static PncArtifactBuildInfo.Content getContent(PncArtifactBuildInfo info) {
        if (info == null) {
            return null;
        }
        if (info.getContent() == null || info.getContent().isEmpty()) {
            return null;
        }
        return info.getContent().get(0);
    }
}

