/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.manifest.ManifestGenerator;
import io.quarkus.domino.manifest.SbomTransformer;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Property;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;

public class SbomGeneratingDependencyVisitor
implements DependencyTreeVisitor {
    private final MavenArtifactResolver resolver;
    private final Path outputFile;
    private final Map<ArtifactCoords, List<VisitedComponent>> visitedComponents = new HashMap<ArtifactCoords, List<VisitedComponent>>();
    private final ArrayDeque<VisitedComponent> componentStack = new ArrayDeque();
    private final ModelBuilder modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
    private final ModelCache modelCache;
    private final Map<ArtifactCoords, Model> effectiveModels = new HashMap<ArtifactCoords, Model>();

    public SbomGeneratingDependencyVisitor(MavenArtifactResolver resolver, Path outputFile) {
        this.resolver = resolver;
        this.outputFile = outputFile;
        try {
            this.modelCache = new ManifestGenerator.BootstrapModelCache(resolver.getMavenContext().getRepositorySystemSession());
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven model resolver", e);
        }
    }

    @Override
    public void beforeAllRoots() {
    }

    @Override
    public void afterAllRoots() {
        Bom bom = new Bom();
        for (ArtifactCoords coords : SbomGeneratingDependencyVisitor.sortAlphabetically(this.visitedComponents.keySet())) {
            for (VisitedComponent c : this.visitedComponents.get(coords)) {
                this.addComponent(bom, c);
            }
        }
        bom = this.runTransformers(bom);
        BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)ManifestGenerator.schemaVersion(), (Bom)bom);
        String bomString = bomGenerator.toJsonString();
        if (this.outputFile == null) {
            System.out.println(bomString);
        } else {
            if (this.outputFile.getParent() != null) {
                try {
                    Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create " + this.outputFile.getParent(), e);
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);){
                writer.write(bomString);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write to " + this.outputFile, e);
            }
        }
    }

    private static List<ArtifactCoords> sortAlphabetically(Collection<ArtifactCoords> col) {
        ArrayList<ArtifactCoords> list = new ArrayList<ArtifactCoords>(col);
        Collections.sort(list, new Comparator<ArtifactCoords>(){

            @Override
            public int compare(ArtifactCoords o1, ArtifactCoords o2) {
                int i = o1.getGroupId().compareTo(o2.getGroupId());
                if (i != 0) {
                    return i;
                }
                i = o1.getArtifactId().compareTo(o2.getArtifactId());
                if (i != 0) {
                    return i;
                }
                i = o1.getClassifier().compareTo(o2.getClassifier());
                if (i != 0) {
                    return i;
                }
                i = o1.getType().compareTo(o2.getType());
                if (i != 0) {
                    return i;
                }
                return o1.getVersion().compareTo(o2.getVersion());
            }
        });
        return list;
    }

    private Bom runTransformers(Bom bom) {
        Iterator<SbomTransformer> i = ServiceLoader.load(SbomTransformer.class).iterator();
        if (i.hasNext()) {
            ManifestGenerator.SbomTransformContextImpl ctx = new ManifestGenerator.SbomTransformContextImpl(bom);
            while (i.hasNext()) {
                Bom transformed = i.next().transform(ctx);
                if (transformed != null) {
                    ctx.bom = transformed;
                }
                bom = ctx.bom;
            }
        }
        return bom;
    }

    private void addComponent(Bom bom, VisitedComponent visited) {
        if ("pom".equals(visited.coords.getType())) {
            return;
        }
        ArtifactCoords coords = visited.coords;
        Model model = this.resolveModel(visited);
        Component c = new Component();
        ManifestGenerator.extractMetadata(visited.releaseId, model, c);
        if (c.getPublisher() == null) {
            c.setPublisher("central");
        }
        c.setGroup(coords.getGroupId());
        c.setName(coords.getArtifactId());
        c.setVersion(coords.getVersion());
        c.setPurl(visited.getPurl());
        c.setBomRef(visited.getBomRef());
        Property pkgType = new Property();
        pkgType.setName("package:type");
        pkgType.setValue("maven");
        Property pkgLang = new Property();
        pkgLang.setName("package:language");
        pkgLang.setValue("java");
        c.setProperties(List.of(pkgType, pkgLang));
        c.setType(Component.Type.LIBRARY);
        bom.addComponent(c);
        if (!visited.directCompDeps.isEmpty()) {
            Dependency d = new Dependency(c.getBomRef());
            for (VisitedComponent dd : visited.directCompDeps) {
                d.addDependency(new Dependency(dd.getBomRef()));
            }
            bom.addDependency(d);
        }
    }

    private Model resolveModel(VisitedComponent c) {
        ArtifactCoords pom = c.coords.getType().equals("pom") ? c.coords : ArtifactCoords.pom((String)c.coords.getGroupId(), (String)c.coords.getArtifactId(), (String)c.coords.getVersion());
        return this.effectiveModels.computeIfAbsent(pom, p -> this.doResolveModel(pom, c.repos));
    }

    private Model doResolveModel(ArtifactCoords coords, List<RemoteRepository> repos) {
        ModelResolver modelResolver;
        Model rawModel;
        File pomFile;
        LocalProject project;
        LocalWorkspace ws = this.resolver.getMavenContext().getWorkspace();
        if (ws != null && (project = ws.getProject(coords.getGroupId(), coords.getArtifactId())) != null && coords.getVersion().equals(project.getVersion()) && project.getModelBuildingResult() != null) {
            return project.getModelBuildingResult().getEffectiveModel();
        }
        try {
            ArtifactResult pomResult = this.resolver.resolve((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()), repos);
            pomFile = pomResult.getArtifact().getFile();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve " + coords.toCompactCoords(), e);
        }
        try {
            rawModel = ModelUtils.readModel((Path)pomFile.toPath());
        }
        catch (IOException e1) {
            throw new RuntimeException("Failed to read " + pomFile, e1);
        }
        try {
            modelResolver = BootstrapModelResolver.newInstance((BootstrapMavenContext)this.resolver.getMavenContext(), null);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize model resolver", e);
        }
        Parent parent = rawModel.getParent();
        if (parent != null) {
            Path parentPomPath;
            ArtifactResult parentResult;
            DefaultArtifact parentPom = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "pom", parent.getVersion());
            try {
                parentResult = this.resolver.resolve((Artifact)parentPom, repos);
                parentPomPath = parentResult.getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve " + (Artifact)parentPom, e);
            }
            rawModel.getParent().setRelativePath(pomFile.toPath().getParent().relativize(parentPomPath).toString());
            String repoUrl = null;
            for (RemoteRepository remoteRepository : repos) {
                if (!remoteRepository.getId().equals(parentResult.getRepository().getId())) continue;
                repoUrl = remoteRepository.getUrl();
                break;
            }
            if (repoUrl != null) {
                Repository modelRepo = null;
                for (Repository r : rawModel.getRepositories()) {
                    if (!r.getId().equals(parentResult.getRepository().getId())) continue;
                    modelRepo = r;
                    break;
                }
                if (modelRepo == null) {
                    modelRepo = new Repository();
                    modelRepo.setId(parentResult.getRepository().getId());
                    modelRepo.setLayout("default");
                    modelRepo.setReleases(new RepositoryPolicy());
                }
                modelRepo.setUrl(repoUrl);
                try {
                    modelResolver.addRepository(modelRepo, false);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add repository " + modelRepo, exception);
                }
            }
        }
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setPomFile(pomFile);
        req.setRawModel(rawModel);
        req.setModelResolver(modelResolver);
        req.setSystemProperties(System.getProperties());
        req.setUserProperties(System.getProperties());
        req.setModelCache(this.modelCache);
        try {
            return this.modelBuilder.build((ModelBuildingRequest)req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException("Failed to resolve the effective model of " + coords.toCompactCoords(), e);
        }
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.enterComponent(visit);
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveComponent(visit);
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.enterComponent(visit);
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveComponent(visit);
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }

    private void enterComponent(DependencyTreeVisitor.DependencyVisit visit) {
        VisitedComponent current = this.componentStack.peek();
        VisitedComponent next = new VisitedComponent(visit);
        if (current != null) {
            current.directDeps.add(visit.getCoords());
        }
        this.componentStack.push(next);
    }

    private void leaveComponent(DependencyTreeVisitor.DependencyVisit visit) {
        VisitedComponent current = this.componentStack.pop();
        VisitedComponent parent = this.componentStack.peek();
        List variants = this.visitedComponents.computeIfAbsent(current.coords, k -> new ArrayList(4));
        for (VisitedComponent variant : variants) {
            if (!variant.directDeps.equals(current.directDeps)) continue;
            if (parent != null) {
                parent.directCompDeps.add(variant);
            }
            return;
        }
        if (variants.size() == 1) {
            ((VisitedComponent)variants.get(0)).generateBomRef(variants.size());
        } else if (!variants.isEmpty()) {
            current.generateBomRef(variants.size() + 1);
        }
        variants.add(current);
        if (parent != null) {
            parent.directCompDeps.add(current);
        }
    }

    private static class VisitedComponent {
        private final ReleaseId releaseId;
        private final ArtifactCoords coords;
        private final List<RemoteRepository> repos;
        private final Set<ArtifactCoords> directDeps = new HashSet<ArtifactCoords>();
        private final List<VisitedComponent> directCompDeps = new ArrayList<VisitedComponent>();
        private String bomRef;
        private PackageURL purl;

        VisitedComponent(DependencyTreeVisitor.DependencyVisit visit) {
            this.releaseId = visit.getReleaseId();
            this.coords = visit.getCoords();
            this.repos = visit.getRepositories();
        }

        void generateBomRef(int index) {
            if (this.bomRef == null) {
                StringBuilder sb = new StringBuilder();
                String[] parts = this.coords.getGroupId().split("\\.");
                sb.append(parts[0].charAt(0));
                for (int i = 1; i < parts.length; ++i) {
                    sb.append('.').append(parts[i].charAt(0));
                }
                sb.append(':').append(this.coords.getArtifactId()).append(':');
                if (!this.coords.getClassifier().isEmpty()) {
                    sb.append(this.coords.getClassifier()).append(':');
                }
                if (!this.coords.getType().equals("jar")) {
                    sb.append(this.coords.getType()).append(':');
                }
                sb.append(this.coords.getVersion()).append('#').append(index);
                this.bomRef = sb.toString();
            }
        }

        String getBomRef() {
            return this.bomRef == null ? (this.bomRef = this.getPurl().toString()) : this.bomRef;
        }

        PackageURL getPurl() {
            if (this.purl == null) {
                TreeMap<String, String> qualifiers = new TreeMap<String, String>();
                qualifiers.put("type", this.coords.getType());
                if (!this.coords.getClassifier().isEmpty()) {
                    qualifiers.put("classifier", this.coords.getClassifier());
                }
                try {
                    this.purl = new PackageURL("maven", this.coords.getGroupId(), this.coords.getArtifactId(), this.coords.getVersion(), qualifiers, null);
                }
                catch (MalformedPackageURLException e) {
                    throw new RuntimeException("Failed to generate Purl for " + this.coords.toCompactCoords(), e);
                }
            }
            return this.purl;
        }
    }
}

