/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.manifest.PncArtifactBuildInfo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.logging.Logger;

public class PncBuildInfoProvider {
    private static final String DOT_DOMINO = ".domino";
    private static final String PNC_BUILD_INFO = "pnc-build-info";
    private static final String PNC_BUILD_INFO_JSON = "pnc-build-info.json";
    private static Logger log = Logger.getLogger(PncBuildInfoProvider.class);
    private final Path cacheDir = Path.of(PropertyUtils.getUserHome(), new String[0]).resolve(".domino").resolve("pnc-build-info");

    public PncArtifactBuildInfo getBuildInfo(String groupId, String artifactId, String version) {
        PncArtifactBuildInfo buildInfo;
        URL url;
        if (!RhVersionPattern.isRhVersion(version)) {
            return null;
        }
        Path cachedJson = this.cacheDir.resolve(groupId).resolve(artifactId).resolve(version).resolve(PNC_BUILD_INFO_JSON);
        if (Files.exists(cachedJson, new LinkOption[0])) {
            return PncArtifactBuildInfo.deserialize(cachedJson);
        }
        try {
            url = new URL("https", "orch.psi.redhat.com", 443, "/pnc-rest/v2/artifacts?q=identifier==%22" + groupId + ":" + artifactId + ":pom:" + version + "%22");
            log.infof("Requesting build info %s", (Object)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to parse URL", e);
        }
        try {
            URLConnection connection = url.openConnection();
            buildInfo = PncArtifactBuildInfo.deserialize(connection.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to connect to " + url, e);
        }
        try {
            PncArtifactBuildInfo.serialize(buildInfo, cachedJson);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize " + buildInfo + " to " + cachedJson, e);
        }
        return buildInfo;
    }
}

