/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.ArtifactSet;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.maven.dependency.ArtifactCoords;

public class LoggingDependencyTreeVisitor
implements DependencyTreeVisitor {
    private static final String NOT_MANAGED = " [not managed]";
    private final MessageWriter log;
    private final boolean asComments;
    private int level;
    private boolean loggingEnabled;
    private ArtifactSet logTreesFor;

    public LoggingDependencyTreeVisitor(MessageWriter log, boolean asComments, String logTreesFor) {
        this.log = log;
        this.asComments = asComments;
        if (logTreesFor != null) {
            String[] arr;
            ArtifactSet.Builder builder = ArtifactSet.builder();
            for (String s : arr = logTreesFor.split(",")) {
                builder.include(s);
            }
            this.logTreesFor = builder.build();
        }
    }

    @Override
    public void beforeAllRoots() {
    }

    @Override
    public void afterAllRoots() {
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        ArtifactCoords coords = visit.getCoords();
        boolean bl = this.loggingEnabled = this.logTreesFor == null || this.logTreesFor.contains(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
        if (!this.loggingEnabled) {
            return;
        }
        if (visit.isManaged()) {
            this.logComment(coords.toCompactCoords());
        } else {
            this.logComment(coords.toCompactCoords() + NOT_MANAGED);
        }
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        if (this.loggingEnabled) {
            this.logComment("");
        }
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        ++this.level;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
        sb.append(visit.getCoords().toCompactCoords());
        if (!visit.isManaged()) {
            sb.append(' ').append(NOT_MANAGED);
        }
        this.logComment(sb.toString());
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        --this.level;
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        ++this.level;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
        sb.append(visit.getCoords().toCompactCoords()).append(" [parent pom]");
        this.logComment(sb.toString());
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        --this.level;
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        ++this.level;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
        sb.append(visit.getCoords().toCompactCoords()).append(" [bom import]");
        this.logComment(sb.toString());
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        if (!this.loggingEnabled) {
            return;
        }
        --this.level;
    }

    private void logComment(String msg) {
        this.log.info((String)(this.asComments ? "# " + msg : msg));
    }
}

