/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.manifest.VisitedComponent;
import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.NodeProcessor;
import io.quarkus.domino.processor.ParallelTreeProcessor;
import io.quarkus.domino.processor.TaskResult;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.eclipse.aether.repository.RemoteRepository;

public class PurgingDependencyTreeVisitor
implements DependencyTreeVisitor {
    private final AtomicLong nodesTotal = new AtomicLong();
    private final AtomicLong uniqueNodesTotal = new AtomicLong();
    private List<VisitedComponentImpl> roots;
    private ArrayDeque<VisitedComponentImpl> branch;
    private Map<ArtifactCoords, List<VisitedComponentImpl>> nodeVariations;

    @Override
    public void beforeAllRoots() {
        this.nodesTotal.set(0L);
        this.uniqueNodesTotal.set(0L);
        this.roots = new ArrayList<VisitedComponentImpl>();
        this.branch = new ArrayDeque();
        this.nodeVariations = new HashMap<ArtifactCoords, List<VisitedComponentImpl>>();
    }

    @Override
    public void afterAllRoots() {
        this.purge();
    }

    public List<VisitedComponent> getRoots() {
        return new ArrayList<VisitedComponent>(this.roots);
    }

    private void purge() {
        for (VisitedComponentImpl root : this.roots) {
            ParallelTreeProcessor<Long, VisitedComponentImpl, VisitedComponentImpl> treeProcessor = this.newTreeProcessor();
            treeProcessor.addRoot(root);
            treeProcessor.schedule().join();
        }
        this.nodeVariations = null;
        this.branch = null;
        if (this.roots.size() > 1) {
            HashMap<String, VisitedComponentImpl> ids = new HashMap<String, VisitedComponentImpl>(this.roots.size());
            Iterator<VisitedComponentImpl> i = this.roots.iterator();
            while (i.hasNext()) {
                VisitedComponentImpl current = i.next();
                VisitedComponent previous = ids.put(current.getBomRef(), current);
                if (previous == null) continue;
                i.remove();
            }
        }
    }

    private ParallelTreeProcessor<Long, VisitedComponentImpl, VisitedComponentImpl> newTreeProcessor() {
        return ParallelTreeProcessor.with(new NodeProcessor<Long, VisitedComponentImpl, VisitedComponentImpl>(){

            @Override
            public Long getNodeId(VisitedComponentImpl node) {
                return node.getIndex();
            }

            @Override
            public Iterable<VisitedComponentImpl> getChildren(VisitedComponentImpl node) {
                return node.children.values();
            }

            @Override
            public Function<ExecutionContext<Long, VisitedComponentImpl, VisitedComponentImpl>, TaskResult<Long, VisitedComponentImpl, VisitedComponentImpl>> createFunction() {
                return ctx -> {
                    VisitedComponentImpl currentNode = (VisitedComponentImpl)ctx.getNode();
                    List<VisitedComponentImpl> variations = PurgingDependencyTreeVisitor.this.nodeVariations.get(currentNode.getArtifactCoords());
                    long processedVariations = 0L;
                    if (variations.size() > 1) {
                        for (VisitedComponentImpl variation : variations) {
                            if (variation.getBomRef() == null) continue;
                            ++processedVariations;
                            if (!variation.hasMatchingDirectDeps(currentNode)) continue;
                            if (currentNode.getParent() == null) {
                                currentNode.setBomRef(variation.getBomRef());
                                break;
                            }
                            currentNode.getParent().addChild(variation);
                            currentNode = variation;
                            break;
                        }
                    }
                    if (currentNode.getBomRef() == null) {
                        PurgingDependencyTreeVisitor.this.uniqueNodesTotal.incrementAndGet();
                        currentNode.initializeBomRef(processedVariations);
                    }
                    return ctx.success(currentNode);
                };
            }
        });
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.roots.add(this.enterNode(visit));
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveNode();
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.enterNode(visit);
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.leaveNode();
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
    }

    private VisitedComponentImpl enterNode(DependencyTreeVisitor.DependencyVisit visit) {
        VisitedComponentImpl parent = this.branch.peek();
        VisitedComponentImpl current = new VisitedComponentImpl(this.nodesTotal.getAndIncrement(), parent, visit);
        this.nodeVariations.computeIfAbsent(visit.getCoords(), k -> new ArrayList()).add(current);
        if (parent != null) {
            parent.addChild(current);
        }
        this.branch.push(current);
        return current;
    }

    private void leaveNode() {
        this.branch.pop();
    }

    private static class VisitedComponentImpl
    implements VisitedComponent {
        private final long index;
        private final VisitedComponentImpl parent;
        private final ReleaseId releaseId;
        private final ArtifactCoords coords;
        private final List<RemoteRepository> repos;
        private final Map<ArtifactCoords, VisitedComponentImpl> children = new HashMap<ArtifactCoords, VisitedComponentImpl>();
        private String bomRef;
        private PackageURL purl;

        private VisitedComponentImpl(long index, VisitedComponentImpl parent, DependencyTreeVisitor.DependencyVisit visit) {
            this.index = index;
            this.parent = parent;
            this.releaseId = visit.getReleaseId();
            this.coords = visit.getCoords();
            this.repos = visit.getRepositories();
        }

        private long getIndex() {
            return this.index;
        }

        private VisitedComponentImpl getParent() {
            return this.parent;
        }

        private void addChild(VisitedComponentImpl c) {
            this.children.put(c.coords, c);
        }

        private boolean hasMatchingDirectDeps(VisitedComponentImpl other) {
            if (!this.coords.equals(other.coords)) {
                throw new IllegalArgumentException(this.coords.toCompactCoords() + " does not match " + other.coords.toCompactCoords());
            }
            if (this.children.size() != other.children.size()) {
                return false;
            }
            for (Map.Entry<ArtifactCoords, VisitedComponentImpl> c : this.children.entrySet()) {
                VisitedComponentImpl child = c.getValue();
                if (child.bomRef == null) {
                    throw new IllegalStateException(this.coords + " node has not yet processed dependency on " + child.getArtifactCoords());
                }
                VisitedComponentImpl otherChild = other.children.get(c.getKey());
                if (otherChild == null) {
                    return false;
                }
                if (otherChild.bomRef == null) {
                    throw new IllegalStateException(other.coords + " node has not yet processed dependency on " + otherChild.getArtifactCoords());
                }
                if (child.bomRef.equals(otherChild.bomRef)) continue;
                return false;
            }
            return true;
        }

        @Override
        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        @Override
        public ArtifactCoords getArtifactCoords() {
            return this.coords;
        }

        @Override
        public List<RemoteRepository> getRepositories() {
            return this.repos;
        }

        @Override
        public List<VisitedComponent> getDependencies() {
            return new ArrayList<VisitedComponent>(this.children.values());
        }

        @Override
        public PackageURL getPurl() {
            if (this.purl == null) {
                TreeMap<String, String> qualifiers = new TreeMap<String, String>();
                qualifiers.put("type", this.coords.getType());
                if (!this.coords.getClassifier().isEmpty()) {
                    qualifiers.put("classifier", this.coords.getClassifier());
                }
                try {
                    this.purl = new PackageURL("maven", this.coords.getGroupId(), this.coords.getArtifactId(), this.coords.getVersion(), qualifiers, null);
                }
                catch (MalformedPackageURLException e) {
                    throw new RuntimeException("Failed to generate Purl for " + this.coords.toCompactCoords(), e);
                }
            }
            return this.purl;
        }

        @Override
        public String getBomRef() {
            return this.bomRef;
        }

        private void setBomRef(String bomRef) {
            this.bomRef = bomRef;
        }

        private void initializeBomRef(long processedVariations) {
            if (processedVariations == 0L) {
                this.bomRef = this.getPurl().toString();
                return;
            }
            StringBuilder sb = new StringBuilder();
            String[] parts = this.coords.getGroupId().split("\\.");
            sb.append(parts[0].charAt(0));
            for (int i = 1; i < parts.length; ++i) {
                sb.append('.').append(parts[i].charAt(0));
            }
            sb.append(':').append(this.coords.getArtifactId()).append(':');
            if (!this.coords.getClassifier().isEmpty()) {
                sb.append(this.coords.getClassifier()).append(':');
            }
            if (!this.coords.getType().equals("jar")) {
                sb.append(this.coords.getType()).append(':');
            }
            sb.append(this.coords.getVersion()).append('#').append(processedVariations);
            this.bomRef = sb.toString();
        }
    }
}

