/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.manifest.TreeNode;
import io.quarkus.domino.manifest.TreeRecorder;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

class SbomDependencyTreeReader {
    SbomDependencyTreeReader() {
    }

    static List<TreeNode> readTrees(Bom bom, List<String> rootBomRefs) {
        BomData bomData = new BomData(bom);
        TreeRecorder treeRecorder = new TreeRecorder();
        treeRecorder.beforeAllRoots();
        for (Component c : bom.getComponents()) {
            if (!rootBomRefs.contains(c.getBomRef())) continue;
            SbomDependencyTreeReader.readTree(c, bomData, treeRecorder);
        }
        treeRecorder.afterAllRoots();
        return treeRecorder.getRoots();
    }

    private static void readTree(Component root, BomData bomData, TreeRecorder treeRecorder) {
        DepVisit rootVisit = DepVisit.of(root);
        treeRecorder.enterRootArtifact(rootVisit);
        SbomDependencyTreeReader.readDeps(rootVisit, bomData, treeRecorder);
        treeRecorder.leaveRootArtifact(rootVisit);
    }

    private static void readDeps(DepVisit visit, BomData bomData, TreeRecorder treeRecorder) {
        Dependency dep = bomData.getDependency(visit.c.getBomRef());
        if (dep != null) {
            for (Dependency d : dep.getDependencies()) {
                DepVisit depVisit = DepVisit.of(bomData.getComponent(d.getRef()));
                treeRecorder.enterDependency(depVisit);
                SbomDependencyTreeReader.readDeps(depVisit, bomData, treeRecorder);
                treeRecorder.leaveDependency(depVisit);
            }
        }
    }

    private static class DepVisit
    implements DependencyTreeVisitor.DependencyVisit {
        private final Component c;
        private final ArtifactCoords coords;

        static DepVisit of(Component c) {
            return new DepVisit(c);
        }

        private DepVisit(Component c) {
            ArtifactCoords coords;
            PackageURL purl;
            this.c = c;
            try {
                purl = new PackageURL(c.getPurl());
            }
            catch (MalformedPackageURLException e) {
                throw new RuntimeException("Bad PURL " + c.getPurl(), e);
            }
            purl.getQualifiers().getOrDefault("type", "jar");
            purl.getQualifiers().getOrDefault("classifier", "");
            this.coords = coords = ArtifactCoords.of((String)c.getGroup(), (String)c.getName(), (String)purl.getQualifiers().getOrDefault("classifier", ""), (String)purl.getQualifiers().getOrDefault("type", "jar"), (String)c.getVersion());
        }

        @Override
        public ReleaseId getReleaseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArtifactCoords getCoords() {
            return this.coords;
        }

        @Override
        public List<RemoteRepository> getRepositories() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isManaged() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BomData {
        final Map<String, Component> components;
        final Map<String, Dependency> dependencies;

        private BomData(Bom bom) {
            this.components = new HashMap<String, Component>(bom.getComponents().size());
            bom.getComponents().forEach(c -> this.components.put(c.getBomRef(), (Component)c));
            this.dependencies = new HashMap<String, Dependency>(bom.getDependencies().size());
            bom.getDependencies().forEach(d -> this.dependencies.put(d.getRef(), (Dependency)d));
        }

        Dependency getDependency(String ref) {
            return this.dependencies.get(ref);
        }

        Component getComponent(String ref) {
            Component c = this.components.get(ref);
            if (c == null) {
                throw new IllegalArgumentException("No component found for bom-ref " + ref);
            }
            return c;
        }
    }
}

