/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.manifest.ProductInfo;
import io.quarkus.domino.manifest.PurgingDependencyTreeVisitor;
import io.quarkus.domino.manifest.SbomDependencyTreeReader;
import io.quarkus.domino.manifest.SbomGenerator;
import io.quarkus.domino.manifest.TreeNode;
import io.quarkus.domino.manifest.TreeRecorder;
import io.quarkus.domino.manifest.VisitedComponent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cyclonedx.model.Bom;

public class SbomGeneratingDependencyVisitor
implements DependencyTreeVisitor {
    private static final String DOMINO_VALIDATE_SBOM_TREES = "domino.validate.sbom.trees";
    private final SbomGenerator.Builder sbomGenerator;
    private final PurgingDependencyTreeVisitor treeBuilder;
    private final boolean validateSbomTrees;
    private final TreeRecorder validatingTreeRecorder;

    public SbomGeneratingDependencyVisitor(MavenArtifactResolver resolver, Path outputFile, ProductInfo productInfo, boolean enableSbomTransformers) {
        this.sbomGenerator = SbomGenerator.builder().setArtifactResolver(resolver).setOutputFile(outputFile).setProductInfo(productInfo);
        this.treeBuilder = new PurgingDependencyTreeVisitor();
        this.validateSbomTrees = Boolean.parseBoolean(System.getProperty(DOMINO_VALIDATE_SBOM_TREES));
        this.validatingTreeRecorder = this.validateSbomTrees ? new TreeRecorder() : null;
    }

    @Override
    public void beforeAllRoots() {
        this.treeBuilder.beforeAllRoots();
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.beforeAllRoots();
        }
    }

    @Override
    public void afterAllRoots() {
        this.treeBuilder.afterAllRoots();
        this.sbomGenerator.setTopComponents(this.treeBuilder.getRoots());
        Bom bom = this.sbomGenerator.build().generate();
        if (this.validatingTreeRecorder != null) {
            System.out.println("Validating recorded trees");
            this.validatingTreeRecorder.afterAllRoots();
            ArrayList<String> rootBomRefs = new ArrayList<String>(this.treeBuilder.getRoots().size());
            for (VisitedComponent root : this.treeBuilder.getRoots()) {
                if (root.getBomRef() == null) {
                    throw new IllegalStateException("bom-ref is missing for " + root.getArtifactCoords().toCompactCoords());
                }
                rootBomRefs.add(root.getBomRef());
            }
            List<TreeNode> originalRoots = this.validatingTreeRecorder.getRoots();
            HashMap bomRoots = new HashMap(originalRoots.size());
            SbomDependencyTreeReader.readTrees(bom, rootBomRefs).forEach(n -> bomRoots.put(n.name, n));
            for (TreeNode originalRoot : originalRoots) {
                System.out.println("Validating dependencies of " + originalRoot.name);
                TreeNode bomRoot = (TreeNode)bomRoots.get(originalRoot.name);
                if (bomRoot == null) {
                    throw new IllegalStateException("Failed to locate " + originalRoot.name + " among the SBOM components: " + bomRoots.keySet());
                }
                originalRoot.isIdentical(bomRoot);
            }
        }
    }

    @Override
    public void enterRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterRootArtifact(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterRootArtifact(visit);
        }
    }

    @Override
    public void leaveRootArtifact(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveRootArtifact(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveRootArtifact(visit);
        }
    }

    @Override
    public void enterDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterDependency(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterDependency(visit);
        }
    }

    @Override
    public void leaveDependency(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveDependency(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveDependency(visit);
        }
    }

    @Override
    public void enterParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterParentPom(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterParentPom(visit);
        }
    }

    @Override
    public void leaveParentPom(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveParentPom(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveParentPom(visit);
        }
    }

    @Override
    public void enterBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.enterBomImport(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.enterBomImport(visit);
        }
    }

    @Override
    public void leaveBomImport(DependencyTreeVisitor.DependencyVisit visit) {
        this.treeBuilder.leaveBomImport(visit);
        if (this.validatingTreeRecorder != null) {
            this.validatingTreeRecorder.leaveBomImport(visit);
        }
    }
}

