/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ArtifactCoordsPattern {
    private static final char DELIMITER = ':';
    private static final String DELIMITER_STRING;
    private static final ArtifactCoordsPattern MATCH_ALL;
    private static final ArtifactCoordsPattern MATCH_SNAPSHOTS;
    static final String MULTI_WILDCARD;
    static final String MULTI_WILDCARD_CHAR = "*";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    final ArtifactCoordsSegmentPattern groupIdPattern;
    final ArtifactCoordsSegmentPattern artifactIdPattern;
    final ArtifactCoordsSegmentPattern classifierPattern;
    final ArtifactCoordsSegmentPattern typePattern;
    final ArtifactCoordsSegmentPattern versionPattern;
    private final String source;

    public static ArtifactCoordsPattern of(ArtifactCoords c) {
        Builder pattern = ArtifactCoordsPattern.builder();
        pattern.groupIdPattern(c.getGroupId());
        pattern.artifactIdPattern(c.getArtifactId());
        if (c.getClassifier() != null && !c.getClassifier().isEmpty()) {
            pattern.classifierPattern(c.getClassifier());
        }
        if (c.getType() != null && !c.getType().isEmpty()) {
            pattern.typePattern(c.getType());
        }
        return pattern.versionPattern(c.getVersion()).build();
    }

    public static List<ArtifactCoordsPattern> toPatterns(Collection<ArtifactCoords> coords) {
        if (coords.isEmpty()) {
            return List.of();
        }
        ArrayList<ArtifactCoordsPattern> result = new ArrayList<ArtifactCoordsPattern>(coords.size());
        for (ArtifactCoords c : coords) {
            result.add(ArtifactCoordsPattern.of(c));
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ArtifactCoordsPattern matchAll() {
        return MATCH_ALL;
    }

    public static ArtifactCoordsPattern matchSnapshots() {
        return MATCH_SNAPSHOTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArtifactCoordsPattern of(String wildcardPattern) {
        ArtifactCoordsSegmentPattern versionPattern;
        ArtifactCoordsSegmentPattern typePattern;
        ArtifactCoordsSegmentPattern classifierPattern;
        StringTokenizer st = new StringTokenizer(wildcardPattern, DELIMITER_STRING);
        ArtifactCoordsSegmentPattern groupIdPattern = st.hasMoreTokens() ? new ArtifactCoordsSegmentPattern(st.nextToken()) : ArtifactCoordsSegmentPattern.MATCH_ALL;
        ArtifactCoordsSegmentPattern artifactIdPattern = st.hasMoreTokens() ? new ArtifactCoordsSegmentPattern(st.nextToken()) : ArtifactCoordsSegmentPattern.MATCH_ALL;
        if (st.hasMoreTokens()) {
            String third = st.nextToken();
            if (st.hasMoreTokens()) {
                String fourth = st.nextToken();
                if (!st.hasMoreTokens()) throw new IllegalStateException(ArtifactCoordsSegmentPattern.class.getName() + ".of() expects groupId:artifactId:version or groupId:artifactId:classifier:type:version; found: " + wildcardPattern);
                String fifth = st.nextToken();
                classifierPattern = new ArtifactCoordsSegmentPattern(third);
                typePattern = new ArtifactCoordsSegmentPattern(fourth);
                versionPattern = new ArtifactCoordsSegmentPattern(fifth);
                return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
            } else {
                classifierPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
                typePattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
                versionPattern = new ArtifactCoordsSegmentPattern(third);
            }
            return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
        } else {
            classifierPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
            typePattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
            versionPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        }
        return new ArtifactCoordsPattern(groupIdPattern, artifactIdPattern, classifierPattern, typePattern, versionPattern);
    }

    ArtifactCoordsPattern(ArtifactCoordsSegmentPattern groupIdPattern, ArtifactCoordsSegmentPattern artifactIdPattern, ArtifactCoordsSegmentPattern classifierPattern, ArtifactCoordsSegmentPattern typePattern, ArtifactCoordsSegmentPattern versionPattern) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.classifierPattern = classifierPattern;
        this.typePattern = typePattern;
        this.versionPattern = versionPattern;
        StringBuilder source = new StringBuilder(groupIdPattern.getSource().length() + artifactIdPattern.getSource().length() + classifierPattern.getSource().length() + typePattern.getSource().length() + versionPattern.getSource().length() + 3);
        source.append(groupIdPattern.getSource());
        boolean artifactMatchesAll = artifactIdPattern.matchesAll();
        boolean classifierMatchesAll = classifierPattern.matchesAll();
        boolean typeMatchesAll = typePattern.matchesAll();
        boolean versionMatchesAll = versionPattern.matchesAll();
        if (!versionMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
            if (!typeMatchesAll || !classifierMatchesAll) {
                source.append(':').append(classifierPattern.getSource());
                source.append(':').append(typePattern.getSource());
            }
            source.append(':').append(versionPattern.getSource());
        } else if (!typeMatchesAll || !classifierMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
            source.append(':').append(classifierPattern.getSource());
            source.append(':').append(typePattern.getSource());
        } else if (!artifactMatchesAll) {
            source.append(':').append(artifactIdPattern.getSource());
        }
        this.source = source.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactCoordsPattern other = (ArtifactCoordsPattern)obj;
        return this.source.equals(other.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean matches(String groupId, String artifactId, String classifier, String type, String version) {
        return this.groupIdPattern.matches(groupId) && this.artifactIdPattern.matches(artifactId) && this.classifierPattern.matches(classifier) && this.typePattern.matches(type) && this.versionPattern.matches(version);
    }

    public String toString() {
        return this.source;
    }

    static {
        MULTI_WILDCARD = String.valueOf(MULTI_WILDCARD_CHAR);
        DELIMITER_STRING = String.valueOf(':');
        MATCH_ALL = new ArtifactCoordsPattern(ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL);
        MATCH_SNAPSHOTS = new ArtifactCoordsPattern(ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, ArtifactCoordsSegmentPattern.MATCH_ALL, new ArtifactCoordsSegmentPattern(MULTI_WILDCARD + SNAPSHOT_SUFFIX));
    }

    static class ArtifactCoordsSegmentPattern {
        private static final ArtifactCoordsSegmentPattern MATCH_ALL = new ArtifactCoordsSegmentPattern(MULTI_WILDCARD);
        private static final String MATCH_ALL_PATTERN_SOURCE = ".*";
        private final Pattern pattern;
        private final String source;

        ArtifactCoordsSegmentPattern(String wildcardSource) {
            StringBuilder sb = new StringBuilder(wildcardSource.length() + 2);
            StringTokenizer st = new StringTokenizer(wildcardSource, MULTI_WILDCARD, true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (MULTI_WILDCARD.equals(token)) {
                    sb.append(MATCH_ALL_PATTERN_SOURCE);
                    continue;
                }
                sb.append(Pattern.quote(token));
            }
            this.pattern = Pattern.compile(sb.toString());
            this.source = wildcardSource;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArtifactCoordsSegmentPattern other = (ArtifactCoordsSegmentPattern)obj;
            return this.source.equals(other.source);
        }

        public String getSource() {
            return this.source;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean matches(String input) {
            if (input == null) {
                return MATCH_ALL.equals(this);
            }
            return this.pattern.matcher(input).matches();
        }

        public boolean matchesAll() {
            return MATCH_ALL.equals(this);
        }

        public String toString() {
            return this.source;
        }
    }

    public static class Builder {
        private ArtifactCoordsSegmentPattern groupIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern artifactIdPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern typePattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern classifierPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;
        private ArtifactCoordsSegmentPattern versionPattern = ArtifactCoordsSegmentPattern.MATCH_ALL;

        private Builder() {
        }

        public ArtifactCoordsPattern build() {
            return new ArtifactCoordsPattern(this.groupIdPattern, this.artifactIdPattern, this.classifierPattern, this.typePattern, this.versionPattern);
        }

        public Builder groupIdPattern(String wildcardPattern) {
            this.groupIdPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder artifactIdPattern(String wildcardPattern) {
            this.artifactIdPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder classifierPattern(String wildcardPattern) {
            this.classifierPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder typePattern(String wildcardPattern) {
            this.typePattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }

        public Builder versionPattern(String wildcardPattern) {
            this.versionPattern = new ArtifactCoordsSegmentPattern(wildcardPattern);
            return this;
        }
    }
}

