/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.resolver.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.domino.manifest.SbomTransformContext;
import io.quarkus.domino.manifest.SbomTransformer;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Property;
import org.cyclonedx.util.LicenseResolver;
import org.eclipse.aether.repository.RemoteRepository;

public class ManifestGenerator {
    private final BootstrapMavenContext mavenCtx;
    private final MavenArtifactResolver artifactResolver;
    private final EffectiveModelResolver effectiveModelResolver;
    private final Path outputFile;
    private final List<SbomTransformer> transformers;

    public static Builder builder() {
        return new Builder();
    }

    private ManifestGenerator(Builder builder) {
        this.artifactResolver = builder.getInitializedResolver();
        this.mavenCtx = this.artifactResolver.getMavenContext();
        this.effectiveModelResolver = new EffectiveModelResolver(this.artifactResolver);
        this.outputFile = builder.outputFile;
        this.transformers = builder.transformers;
    }

    public Consumer<Collection<ReleaseRepo>> toConsumer() {
        return releases -> {
            Bom bom = new Bom();
            for (ReleaseRepo r : releases) {
                for (Map.Entry<ArtifactCoords, List<RemoteRepository>> entry : r.getArtifacts().entrySet()) {
                    this.addComponent(bom, r, entry.getKey(), entry.getValue());
                }
            }
            bom = this.runTransformers(bom);
            BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)ManifestGenerator.schemaVersion(), (Bom)bom);
            String bomString = bomGenerator.toJsonString();
            if (this.outputFile == null) {
                System.out.println(bomString);
            } else {
                if (this.outputFile.getParent() != null) {
                    try {
                        Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create " + this.outputFile.getParent(), e);
                    }
                }
                try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);){
                    writer.write(bomString);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write to " + this.outputFile, e);
                }
            }
        };
    }

    private void addComponent(Bom bom, ReleaseRepo release, ArtifactCoords coords, List<RemoteRepository> repos) {
        Model model = this.effectiveModelResolver.resolveEffectiveModel(coords, repos);
        Component c = new Component();
        ManifestGenerator.extractMetadata(release.id(), model, c);
        if (c.getPublisher() == null) {
            c.setPublisher("central");
        }
        c.setGroup(coords.getGroupId());
        c.setName(coords.getArtifactId());
        c.setVersion(coords.getVersion());
        TreeMap<String, String> qualifiers = new TreeMap<String, String>();
        qualifiers.put("type", coords.getType());
        if (!coords.getClassifier().isEmpty()) {
            qualifiers.put("classifier", coords.getClassifier());
        }
        try {
            c.setPurl(new PackageURL("maven", coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), qualifiers, null));
        }
        catch (MalformedPackageURLException e) {
            throw new RuntimeException("Failed to generate Purl for " + coords.toCompactCoords(), e);
        }
        ArrayList<Property> props = new ArrayList<Property>(2);
        ManifestGenerator.addProperty(props, "package:type", "maven");
        if (!"pom".equals(coords.getType())) {
            ManifestGenerator.addProperty(props, "package:language", "java");
        }
        c.setProperties(props);
        c.setType(Component.Type.LIBRARY);
        bom.addComponent(c);
    }

    static void addProperty(List<Property> props, String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        props.add(prop);
    }

    private Bom runTransformers(Bom bom) {
        List<SbomTransformer> transformers = this.transformers;
        Iterator<SbomTransformer> i = ServiceLoader.load(SbomTransformer.class).iterator();
        if (i.hasNext()) {
            transformers = new ArrayList<SbomTransformer>(this.transformers.size() + 2);
            while (i.hasNext()) {
                transformers.add(i.next());
            }
        }
        if (!transformers.isEmpty()) {
            SbomTransformContextImpl ctx = new SbomTransformContextImpl(bom);
            for (SbomTransformer t : transformers) {
                Bom transformed = t.transform(ctx);
                if (transformed != null) {
                    ctx.bom = transformed;
                }
                bom = ctx.bom;
            }
        }
        return bom;
    }

    static void extractMetadata(ReleaseId releaseId, Model project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(ManifestGenerator.resolveMavenLicenses(project.getLicenses(), false));
        }
        if (CycloneDxSchema.Version.VERSION_10 != ManifestGenerator.schemaVersion()) {
            if (project.getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.WEBSITE, project.getUrl(), component);
            }
            if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
            }
            if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    if (list.getArchive() != null) {
                        if (ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                        ManifestGenerator.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                        continue;
                    }
                    if (list.getSubscribe() == null || ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    ManifestGenerator.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
                }
            }
            if (!ManifestGenerator.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
                ManifestGenerator.addExternalReference(ExternalReference.Type.VCS, releaseId.origin().toString(), component);
            }
        }
    }

    static LicenseChoice resolveMavenLicenses(List<License> projectLicenses, boolean includeLicenseText) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)includeLicenseText);
                resolved = ManifestGenerator.resolveLicenseInfo(licenseChoice, resolvedByName);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)includeLicenseText);
                resolved = ManifestGenerator.resolveLicenseInfo(licenseChoice, resolvedByUrl);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (artifactLicense.getUrl() != null && !artifactLicense.getUrl().isBlank()) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    static boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != ManifestGenerator.schemaVersion()) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    static CycloneDxSchema.Version schemaVersion() {
        return CycloneDxSchema.Version.VERSION_14;
    }

    private static boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private static void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    static class SbomTransformContextImpl
    implements SbomTransformContext {
        Bom bom;

        SbomTransformContextImpl(Bom bom) {
            this.bom = bom;
        }

        @Override
        public Bom getOriginalBom() {
            return this.bom;
        }
    }

    public static class Builder {
        private MavenArtifactResolver resolver;
        private Path outputFile;
        private List<SbomTransformer> transformers = List.of();

        private Builder() {
        }

        public Builder setArtifactResolver(MavenArtifactResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder setOutputFile(Path outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public Builder addTransformer(SbomTransformer transformer) {
            if (this.transformers.isEmpty()) {
                this.transformers = new ArrayList<SbomTransformer>(1);
            }
            this.transformers.add(transformer);
            return this;
        }

        public ManifestGenerator build() {
            return new ManifestGenerator(this);
        }

        private MavenArtifactResolver getInitializedResolver() {
            if (this.resolver == null) {
                try {
                    return MavenArtifactResolver.builder().build();
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
                }
            }
            return this.resolver;
        }
    }
}

