/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PncArtifactBuildInfo {
    private static volatile ObjectMapper mapper;
    private List<Content> content;
    private Map<String, Object> any;

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            ObjectMapper om = new ObjectMapper();
            om.enable(SerializationFeature.INDENT_OUTPUT);
            om.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            om.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
            om.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper = om;
        }
        return mapper;
    }

    public static PncArtifactBuildInfo deserialize(Path p) {
        PncArtifactBuildInfo pncArtifactBuildInfo;
        block8: {
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                pncArtifactBuildInfo = (PncArtifactBuildInfo)PncArtifactBuildInfo.getMapper().readValue((Reader)reader, PncArtifactBuildInfo.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to deserialize " + p, e);
                }
            }
            reader.close();
        }
        return pncArtifactBuildInfo;
    }

    public static PncArtifactBuildInfo deserialize(InputStream is) {
        PncArtifactBuildInfo pncArtifactBuildInfo;
        block8: {
            InputStream stream = is;
            try {
                pncArtifactBuildInfo = (PncArtifactBuildInfo)PncArtifactBuildInfo.getMapper().readValue(stream, PncArtifactBuildInfo.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to deserialize PNC build info", e);
                }
            }
            stream.close();
        }
        return pncArtifactBuildInfo;
    }

    public static void serialize(Object catalog, Path p) throws IOException {
        PncArtifactBuildInfo.serialize(PncArtifactBuildInfo.getMapper(), catalog, p);
    }

    public static void serialize(ObjectMapper mapper, Object catalog, Path p) throws IOException {
        Path parent = p.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
            PncArtifactBuildInfo.serialize(mapper, catalog, writer);
        }
    }

    public static void serialize(ObjectMapper mapper, Object catalog, Writer writer) throws IOException {
        mapper.writeValue(writer, catalog);
    }

    public List<Content> getContent() {
        return this.content;
    }

    public void setContent(List<Content> content) {
        this.content = content;
    }

    public Map<String, Object> getAny() {
        return this.any;
    }

    @JsonAnySetter
    public void setAny(Map<String, Object> any) {
        this.any = any;
    }

    public static Content getContent(PncArtifactBuildInfo info) {
        if (info == null) {
            return null;
        }
        if (info.getContent() == null || info.getContent().isEmpty()) {
            return null;
        }
        return info.getContent().get(0);
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Build {
        private String id;
        private String scmUrl;
        private String scmRevision;
        private String scmTag;
        private Map<String, Object> any;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getScmUrl() {
            return this.scmUrl;
        }

        @JsonSetter(value="scmUrl")
        public void setScmUrl(String scmUrl) {
            this.scmUrl = scmUrl;
        }

        public String getScmRevision() {
            return this.scmRevision;
        }

        @JsonSetter(value="scmRevision")
        public void setScmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
        }

        public String getScmTag() {
            return this.scmTag;
        }

        @JsonSetter(value="scmTag")
        public void setScmTag(String scmTag) {
            this.scmTag = scmTag;
        }

        public Map<String, Object> getAny() {
            return this.any;
        }

        @JsonAnySetter
        public void setAny(Map<String, Object> any) {
            this.any = any;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Content {
        private String id;
        private String identifier;
        private String purl;
        private String artifactQuality;
        private String buildCategory;
        private String md5;
        private String sha1;
        private String sha256;
        private String modificationTime;
        private Build build;
        private Map<String, Object> any;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getPurl() {
            return this.purl;
        }

        public void setPurl(String purl) {
            this.purl = purl;
        }

        public String getArtifactQuality() {
            return this.artifactQuality;
        }

        public void setArtifactQuality(String artifactQuality) {
            this.artifactQuality = artifactQuality;
        }

        public String getBuildCategory() {
            return this.buildCategory;
        }

        public void setBuildCategory(String buildCategory) {
            this.buildCategory = buildCategory;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getSha1() {
            return this.sha1;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        public String getModificationTime() {
            return this.modificationTime;
        }

        public void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        public Build getBuild() {
            return this.build;
        }

        public void setBuild(Build build) {
            this.build = build;
        }

        public Map<String, Object> getAny() {
            return this.any;
        }

        @JsonAnySetter
        public void setAny(Map<String, Object> any) {
            this.any = any;
        }
    }
}

