/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.processor;

import io.quarkus.domino.processor.TaskResult;

class TaskResultImpl<I, N, O>
implements TaskResult<I, N, O> {
    static final int CANCELED = 1;
    static final int FAILURE = 16;
    static final int SUCCESS = 256;
    static final int SKIPPED = 4096;
    private final I id;
    private final N node;
    private final O o;
    private final int status;
    private final Exception e;

    public TaskResultImpl(I id, N node, O o, int status, Exception e) {
        this.id = id;
        this.node = node;
        this.o = o;
        this.status = status;
        this.e = e;
    }

    private boolean isFlagSet(int flag) {
        return (this.status & flag) > 0;
    }

    @Override
    public boolean isCanceled() {
        return this.isFlagSet(1);
    }

    @Override
    public boolean isFailure() {
        return this.isFlagSet(16);
    }

    @Override
    public boolean isSuccess() {
        return this.isFlagSet(256);
    }

    @Override
    public boolean isSkipped() {
        return this.isFlagSet(4096);
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public N getNode() {
        return this.node;
    }

    @Override
    public O getOutcome() {
        return this.o;
    }

    @Override
    public Exception getException() {
        return this.e;
    }
}

