/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bom.decomposer.ReleaseId;
import java.util.List;
import java.util.Objects;

public class CircularReleaseDependency {
    private final List<ReleaseId> chain;

    public static CircularReleaseDependency of(List<ReleaseId> chain) {
        return new CircularReleaseDependency(chain);
    }

    private CircularReleaseDependency(List<ReleaseId> chain) {
        if (chain == null || chain.size() < 2) {
            throw new IllegalArgumentException("Invalid circular release dependency chain " + chain);
        }
        this.chain = List.copyOf(chain);
    }

    public List<ReleaseId> getReleaseDependencyChain() {
        return this.chain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.chain.get(0));
        for (int i = 1; i < this.chain.size(); ++i) {
            sb.append(",").append(this.chain.get(i));
        }
        return sb.append(')').toString();
    }

    public int hashCode() {
        return Objects.hash(this.chain);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CircularReleaseDependency other = (CircularReleaseDependency)obj;
        return Objects.equals(this.chain, other.chain);
    }
}

