/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.repository.RemoteRepository;

public class ReleaseRepo {
    final ReleaseId id;
    final Map<ArtifactCoords, List<RemoteRepository>> artifacts = new HashMap<ArtifactCoords, List<RemoteRepository>>();
    final Map<ReleaseId, ReleaseRepo> dependants = new HashMap<ReleaseId, ReleaseRepo>();
    final Map<ReleaseId, ReleaseRepo> dependencies = new LinkedHashMap<ReleaseId, ReleaseRepo>();

    ReleaseRepo(ReleaseId release) {
        this.id = release;
    }

    public ReleaseId id() {
        return this.id;
    }

    public Map<ArtifactCoords, List<RemoteRepository>> getArtifacts() {
        return this.artifacts;
    }

    public Collection<ReleaseRepo> getDependencies() {
        return this.dependencies.values();
    }

    void addRepoDependency(ReleaseRepo repo) {
        if (repo != this) {
            this.dependencies.putIfAbsent(repo.id(), repo);
            repo.dependants.putIfAbsent(this.id(), this);
        }
    }

    public boolean isRoot() {
        return this.dependants.isEmpty();
    }
}

