/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.processor;

import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.TaskResult;
import io.quarkus.domino.processor.TaskResultImpl;
import java.util.Map;

class ExecutionContextImpl<I, N, O>
implements ExecutionContext<I, N, O> {
    private final I id;
    private final N node;
    private final Map<I, TaskResult<I, N, O>> dependencyResults;

    ExecutionContextImpl(I id, N node) {
        this(id, node, Map.of());
    }

    ExecutionContextImpl(I id, N node, Map<I, TaskResult<I, N, O>> dependencyResults) {
        this.id = id;
        this.node = node;
        this.dependencyResults = dependencyResults;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public N getNode() {
        return this.node;
    }

    @Override
    public TaskResult<I, N, O> canceled(O o) {
        return new TaskResultImpl<I, N, O>(this.id, this.node, o, 1, null);
    }

    @Override
    public TaskResult<I, N, O> failure(O o, Exception e) {
        return new TaskResultImpl<I, N, O>(this.id, this.node, o, 16, e);
    }

    @Override
    public TaskResult<I, N, O> success(O o) {
        return new TaskResultImpl<I, N, O>(this.id, this.node, o, 256, null);
    }

    @Override
    public TaskResult<I, N, O> skipped(O o) {
        return new TaskResultImpl<I, N, O>(this.id, this.node, o, 4096, null);
    }

    @Override
    public Iterable<I> getDependencies() {
        return this.dependencyResults.keySet();
    }

    @Override
    public TaskResult<I, N, O> getDependencyResult(I id) {
        return this.dependencyResults.get(id);
    }
}

