/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.processor;

import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.ExecutionContextImpl;
import io.quarkus.domino.processor.TaskResult;
import io.quarkus.domino.processor.TaskResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;

public class NodeTask<I, N, O> {
    private final I id;
    private final N node;
    private final Function<ExecutionContext<I, N, O>, TaskResult<I, N, O>> func;
    private final Map<I, NodeTask<I, N, O>> dependencies = new LinkedHashMap<I, NodeTask<I, N, O>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Queue<TaskResult<I, N, O>> resultQueue;
    private CompletableFuture<TaskResult<I, N, O>> cf;

    static <I, N, O> NodeTask<I, N, O> of(I id, N node, Function<ExecutionContext<I, N, O>, TaskResult<I, N, O>> func, Queue<TaskResult<I, N, O>> resultQueue) {
        return new NodeTask<I, N, O>(id, node, func, resultQueue);
    }

    private NodeTask(I id, N node, Function<ExecutionContext<I, N, O>, TaskResult<I, N, O>> func, Queue<TaskResult<I, N, O>> resultQueue) {
        this.id = id;
        this.node = node;
        this.func = func;
        this.resultQueue = resultQueue;
    }

    public I getId() {
        return this.id;
    }

    public Collection<NodeTask<I, N, O>> getDependencies() {
        this.lock.readLock().lock();
        try {
            ArrayList<NodeTask<I, N, O>> arrayList = new ArrayList<NodeTask<I, N, O>>(this.dependencies.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void dependsOn(NodeTask<I, N, O> dep) {
        this.lock.writeLock().lock();
        try {
            this.dependencies.computeIfAbsent(dep.id, i -> dep);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<TaskResult<I, N, O>> schedule() {
        this.lock.readLock().lock();
        try {
            if (this.cf != null) {
                CompletableFuture<TaskResult<I, N, O>> completableFuture = this.cf;
                return completableFuture;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.cf != null) {
                CompletableFuture<TaskResult<I, N, O>> completableFuture = this.cf;
                return completableFuture;
            }
            if (this.dependencies.isEmpty()) {
                this.cf = CompletableFuture.supplyAsync(() -> {
                    TaskResult result = NodeTask.getResult(new ExecutionContextImpl(this.id, this.node), this.func);
                    this.resultQueue.add(result);
                    return result;
                });
                CompletableFuture<TaskResult<I, N, O>> completableFuture = this.cf;
                return completableFuture;
            }
            CompletableFuture[] deps = new CompletableFuture[this.dependencies.size()];
            int ti = 0;
            for (NodeTask<I, N, O> t : this.dependencies.values()) {
                deps[ti++] = t.schedule();
            }
            this.cf = CompletableFuture.allOf(deps).thenApplyAsync(v -> {
                HashMap dependencyResults = new HashMap(deps.length);
                for (int i = 0; i < deps.length; ++i) {
                    TaskResult depResult = deps[i].getNow(null);
                    if (depResult == null) {
                        TaskResultImpl<I, N, Object> result = new TaskResultImpl<I, N, Object>(this.id, this.node, null, 16, null);
                        this.resultQueue.add(result);
                        return result;
                    }
                    if (depResult.isCanceled() || depResult.isFailure()) {
                        TaskResultImpl<I, N, Object> result = new TaskResultImpl<I, N, Object>(this.id, this.node, null, 1, null);
                        this.resultQueue.add(result);
                        return result;
                    }
                    dependencyResults.put(depResult.getId(), depResult);
                }
                TaskResult result = NodeTask.getResult(new ExecutionContextImpl(this.id, this.node, dependencyResults), this.func);
                this.resultQueue.add(result);
                return result;
            });
            CompletableFuture<TaskResult<I, N, O>> completableFuture = this.cf;
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static <I, N, O> TaskResult<I, N, O> getResult(ExecutionContext<I, N, O> ctx, Function<ExecutionContext<I, N, O>, TaskResult<I, N, O>> func) {
        try {
            return func.apply(ctx);
        }
        catch (Exception e) {
            return new TaskResultImpl<I, N, Object>(ctx.getId(), ctx.getNode(), null, 16, e);
        }
    }
}

