/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.processor;

import io.quarkus.domino.processor.ExecutionContext;
import io.quarkus.domino.processor.NodeProcessor;
import io.quarkus.domino.processor.NodeTask;
import io.quarkus.domino.processor.TaskResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;

public class ParallelTreeProcessor<I, N, O> {
    private final NodeProcessor<I, N, O> nodeProcessor;
    private final Function<ExecutionContext<I, N, O>, TaskResult<I, N, O>> nodeFunc;
    private final List<NodeTask<I, N, O>> rootTasks = new ArrayList<NodeTask<I, N, O>>();
    private final Map<I, NodeTask<I, N, O>> allTasks = new ConcurrentHashMap<I, NodeTask<I, N, O>>();
    private final Queue<TaskResult<I, N, O>> resultQueue = new ConcurrentLinkedQueue<TaskResult<I, N, O>>();

    public static <I, N, O> ParallelTreeProcessor<I, N, O> with(NodeProcessor<I, N, O> nodeProcessor) {
        return new ParallelTreeProcessor<I, N, O>(nodeProcessor);
    }

    private ParallelTreeProcessor(NodeProcessor<I, N, O> nodeProcessor) {
        this.nodeProcessor = nodeProcessor;
        this.nodeFunc = nodeProcessor.createFunction();
    }

    public CompletableFuture<List<TaskResult<I, N, O>>> schedule() {
        ArrayList<CompletableFuture<TaskResult<I, N, O>>> rootResults = new ArrayList<CompletableFuture<TaskResult<I, N, O>>>();
        for (NodeTask<I, N, O> t : this.rootTasks) {
            rootResults.add(t.schedule());
        }
        return CompletableFuture.allOf(rootResults.toArray(new CompletableFuture[0])).thenApplyAsync(n -> new ArrayList<TaskResult<I, N, O>>(this.resultQueue));
    }

    public void addRoot(N root) {
        this.rootTasks.add(this.visit(root));
    }

    private NodeTask<I, N, O> visit(N node) {
        NodeTask nodeTask = this.allTasks.computeIfAbsent(this.nodeProcessor.getNodeId(node), id -> NodeTask.of(id, node, this.nodeFunc, this.resultQueue));
        for (N c : this.nodeProcessor.getChildren(node)) {
            nodeTask.dependsOn(this.visit(c));
        }
        return nodeTask;
    }
}

