/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import io.quarkus.domino.ProductInfo;
import io.quarkus.domino.ProjectDependencyConfigImpl;
import io.quarkus.domino.ProjectDependencyConfigMapper;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public interface ProjectDependencyConfig {
    public ProductInfo getProductInfo();

    public Path getProjectDir();

    public ArtifactCoords getProjectBom();

    public List<ArtifactCoords> getNonProjectBoms();

    public Collection<ArtifactCoords> getProjectArtifacts();

    public Collection<ArtifactCoords> getIncludeArtifacts();

    public Collection<ArtifactCoords> getIncludePatterns();

    public Collection<ArtifactCoords> getExcludePatterns();

    public Collection<String> getExcludeScopes();

    public boolean isIncludeNonManaged();

    public boolean isExcludeParentPoms();

    public boolean isExcludeBomImports();

    public int getLevel();

    public boolean isVerboseGraphs();

    public boolean isLogArtifactsToBuild();

    public boolean isLogModulesToBuild();

    public boolean isLogTrees();

    public String getLogTreesFor();

    public boolean isLogRemaining();

    public boolean isLogSummary();

    public boolean isLogNonManagedVisitied();

    public boolean isLogCodeRepos();

    public boolean isLogCodeRepoTree();

    public List<String> getRecipeRepos();

    public boolean isValidateCodeRepoTags();

    @Deprecated(since="0.0.78")
    public boolean isLegacyScmLocator();

    public boolean isWarnOnResolutionErrors();

    public boolean isWarnOnMissingScm();

    public boolean isIncludeAlreadyBuilt();

    public boolean isIncludeOptionalDeps();

    public boolean isGradleJava8();

    public String getGradleJavaHome();

    default public Mutable mutable() {
        return new ProjectDependencyConfigImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        ProjectDependencyConfigMapper.serialize((Object)this, p);
    }

    public static Mutable builder() {
        return new ProjectDependencyConfigImpl.Builder();
    }

    public static ProjectDependencyConfig fromFile(Path path) throws IOException {
        return ProjectDependencyConfig.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        Mutable mutable = ProjectDependencyConfigMapper.deserialize(path, ProjectDependencyConfigImpl.Builder.class);
        return mutable == null ? ProjectDependencyConfig.builder() : mutable;
    }

    public static ProjectDependencyConfig fromStream(InputStream inputStream) throws IOException {
        Mutable mutable = ProjectDependencyConfigMapper.deserialize(inputStream, ProjectDependencyConfigImpl.Builder.class);
        return mutable == null ? ProjectDependencyConfig.builder().build() : mutable.build();
    }

    public static interface Mutable
    extends ProjectDependencyConfig {
        public Mutable setProductInfo(ProductInfo var1);

        public Mutable setProjectDir(Path var1);

        public Mutable setProjectBom(ArtifactCoords var1);

        public Mutable setNonProjectBoms(List<ArtifactCoords> var1);

        public Mutable setProjectArtifacts(Collection<ArtifactCoords> var1);

        public Mutable addProjectArtifacts(ArtifactCoords var1);

        public Mutable setIncludeArtifacts(Collection<ArtifactCoords> var1);

        default public Mutable setIncludeGroupIds(Collection<String> groupIds) {
            groupIds.forEach(g -> this.addIncludePattern(ArtifactCoords.of((String)g, (String)"*", (String)"*", (String)"*", (String)"*")));
            return this;
        }

        default public Mutable setIncludeKeys(Collection<ArtifactKey> artifactKeys) {
            artifactKeys.forEach(k -> this.addIncludePattern(ArtifactCoords.of((String)k.getGroupId(), (String)k.getArtifactId(), (String)k.getClassifier(), (String)k.getType(), (String)"*")));
            return this;
        }

        public Mutable setIncludePatterns(Collection<ArtifactCoords> var1);

        public Mutable addIncludePattern(ArtifactCoords var1);

        default public Mutable setExcludeGroupIds(Collection<String> groupIds) {
            groupIds.forEach(g -> this.addExcludePattern(ArtifactCoords.of((String)g, (String)"*", (String)"*", (String)"*", (String)"*")));
            return this;
        }

        default public Mutable setExcludeKeys(Collection<ArtifactKey> artifactKeys) {
            artifactKeys.forEach(k -> this.addExcludePattern(ArtifactCoords.of((String)k.getGroupId(), (String)k.getArtifactId(), (String)k.getClassifier(), (String)k.getType(), (String)"*")));
            return this;
        }

        public Mutable setExcludePatterns(Collection<ArtifactCoords> var1);

        public Mutable addExcludePattern(ArtifactCoords var1);

        public Mutable setExcludeScopes(Collection<String> var1);

        public Mutable setIncludeNonManaged(boolean var1);

        public Mutable setExcludeParentPoms(boolean var1);

        public Mutable setExcludeBomImports(boolean var1);

        public Mutable setLevel(int var1);

        public Mutable setVerboseGraphs(boolean var1);

        public Mutable setLogArtifactsToBuild(boolean var1);

        public Mutable setLogModulesToBuild(boolean var1);

        public Mutable setLogTrees(boolean var1);

        public Mutable setLogTreesFor(String var1);

        public Mutable setLogRemaining(boolean var1);

        public Mutable setLogSummary(boolean var1);

        public Mutable setLogNonManagedVisited(boolean var1);

        public Mutable setLogCodeRepos(boolean var1);

        public Mutable setLogCodeRepoTree(boolean var1);

        public Mutable setRecipeRepos(List<String> var1);

        @Deprecated(since="0.0.78")
        public Mutable setValidateCodeRepoTags(boolean var1);

        public Mutable setLegacyScmLocator(boolean var1);

        public Mutable setWarnOnResolutionErrors(boolean var1);

        public Mutable setWarnOnMissingScm(boolean var1);

        public Mutable setIncludeAlreadyBuilt(boolean var1);

        public Mutable setIncludeOptionalDeps(boolean var1);

        public Mutable setGradleJava8(boolean var1);

        public Mutable setGradleJavaHome(String var1);

        public ProjectDependencyConfig build();

        @Override
        default public void persist(Path p) throws IOException {
            ProjectDependencyConfigMapper.serialize((Object)this.build(), p);
        }
    }
}

