/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino;

import com.redhat.hacbs.recipies.scm.GitScmLocator;
import com.redhat.hacbs.recipies.scm.RepositoryInfo;
import com.redhat.hacbs.recipies.scm.ScmLocator;
import com.redhat.hacbs.recipies.scm.TagInfo;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ScmRevisionResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.ArtifactCoordsComparator;
import io.quarkus.domino.ArtifactCoordsPattern;
import io.quarkus.domino.BuildTool;
import io.quarkus.domino.CircularReleaseDependency;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.GradleProjectReader;
import io.quarkus.domino.LoggingDependencyTreeVisitor;
import io.quarkus.domino.MavenProjectReader;
import io.quarkus.domino.PncBuildInfoProvider;
import io.quarkus.domino.PncReleaseIdDetector;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.PropertyResolver;
import io.quarkus.domino.ReleaseCollection;
import io.quarkus.domino.ReleaseRepo;
import io.quarkus.domino.ResolvedDependency;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.pnc.PncArtifactLatestVersion;
import io.quarkus.domino.pnc.PncVersionProvider;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GAV;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class ProjectDependencyResolver {
    private static final String SCM_LOCATOR_STATS_PROP = "scm-locator-stats";
    private final MavenArtifactResolver resolver;
    private final ProjectDependencyConfig config;
    private MessageWriter log;
    private final List<ArtifactCoordsPattern> excludeSet;
    private final List<ArtifactCoordsPattern> includeSet;
    private final List<DependencyTreeVisitor> treeVisitors;
    private PrintStream fileOutput;
    private MessageWriter outputWriter;
    private final Path logOutputFile;
    private final boolean appendOutput;
    private boolean includeTestJars;
    private Function<ArtifactCoords, List<Dependency>> artifactConstraintsProvider;
    private Set<ArtifactCoords> projectBomConstraints;
    private final Map<ArtifactCoords, ResolvedDependency> allDepsToBuild = new HashMap<ArtifactCoords, ResolvedDependency>();
    private final Set<ArtifactCoords> nonManagedVisited = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> skippedDeps = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> remainingDeps = new HashSet<ArtifactCoords>();
    private final Set<String> excludeScopes;
    private final Map<ArtifactCoords, ArtifactDependency> artifactDeps = new HashMap<ArtifactCoords, ArtifactDependency>();
    private final Map<ScmRevision, ReleaseRepo> releaseRepos = new HashMap<ScmRevision, ReleaseRepo>();
    private final Map<ArtifactCoords, Map<String, String>> effectivePomProps = new HashMap<ArtifactCoords, Map<String, String>>();
    private final ScmRevisionResolver revisionResolver;
    private Map<ArtifactCoords, DependencyNode> preResolvedRootArtifacts = Map.of();
    private ScmRevision projectRevision;
    private Set<com.redhat.hacbs.recipies.GAV> projectGavs;

    private static boolean isScmLocatorStats() {
        if (!System.getProperties().containsKey(SCM_LOCATOR_STATS_PROP)) {
            return false;
        }
        String s = System.getProperty(SCM_LOCATOR_STATS_PROP);
        return s == null || Boolean.parseBoolean(s);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ProjectDependencyResolver(Builder builder) {
        this.resolver = builder.getInitializedResolver();
        this.log = builder.getInitializedLog();
        this.artifactConstraintsProvider = builder.artifactConstraintsProvider;
        this.logOutputFile = builder.logOutputFile;
        this.appendOutput = builder.appendOutput;
        this.config = Objects.requireNonNull(builder.depConfig);
        this.excludeScopes = Set.copyOf(this.config.getExcludeScopes());
        this.excludeSet = ArtifactCoordsPattern.toPatterns(this.config.getExcludePatterns());
        this.includeSet = new ArrayList<ArtifactCoordsPattern>(this.config.getIncludeArtifacts().size() + this.config.getIncludePatterns().size());
        this.config.getIncludePatterns().forEach(p -> this.includeSet.add(ArtifactCoordsPattern.of(p)));
        this.config.getIncludeArtifacts().forEach(c -> this.includeSet.add(ArtifactCoordsPattern.of(c)));
        if (this.config.isLogTrees() || this.config.getLogTreesFor() != null) {
            this.treeVisitors = new ArrayList<DependencyTreeVisitor>(builder.visitors.size() + 1);
            this.treeVisitors.addAll(builder.visitors);
            this.treeVisitors.add(new LoggingDependencyTreeVisitor(this.getOutput(), true, this.config.getLogTreesFor()));
        } else {
            this.treeVisitors = builder.visitors;
        }
        this.revisionResolver = ProjectDependencyResolver.newRevisionResolver(this.resolver, this.log, this.config);
    }

    public Path getOutputFile() {
        return this.logOutputFile;
    }

    public ProjectDependencyConfig getConfig() {
        return this.config;
    }

    public ReleaseCollection getReleaseCollection() {
        this.resolveDependencies();
        this.configureReleaseRepoDeps();
        return ReleaseCollection.of(new ArrayList<ReleaseRepo>(this.releaseRepos.values()));
    }

    @Deprecated(since="0.0.79")
    public Collection<ReleaseRepo> getReleaseRepos() {
        return this.getReleaseCollection().getReleases();
    }

    @Deprecated(since="0.0.79")
    public Collection<ReleaseRepo> getSortedReleaseRepos() {
        return ReleaseCollection.sort(this.getReleaseRepos());
    }

    @Deprecated(since="0.0.79")
    public void consumeSorted(Consumer<Collection<ReleaseRepo>> consumer) {
        consumer.accept(this.getSortedReleaseRepos());
    }

    @Deprecated(since="0.0.79")
    public <T> T applyToSorted(Function<Collection<ReleaseRepo>, T> func) {
        return func.apply(this.getSortedReleaseRepos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        boolean logCodeRepos = this.config.isLogCodeRepos() || this.config.isLogCodeRepoTree();
        try {
            int i;
            List<ReleaseRepo> sorted;
            this.resolveDependencies();
            int codeReposTotal = 0;
            if (this.config.isLogArtifactsToBuild() && !this.allDepsToBuild.isEmpty()) {
                this.logComment("Artifacts to be built from source from " + (this.config.getProjectBom() == null ? "" : this.config.getProjectBom().toCompactCoords()) + ":");
                if (logCodeRepos) {
                    this.configureReleaseRepoDeps();
                    codeReposTotal = this.releaseRepos.size();
                    sorted = ReleaseCollection.sort(this.releaseRepos.values());
                    boolean logLatestPncBuilds = Boolean.getBoolean("logLatestPncBuilds");
                    AtomicInteger counter = new AtomicInteger();
                    for (ReleaseRepo e : sorted) {
                        this.logComment("repo-url " + e.getRevision().getRepository());
                        this.logComment("tag " + e.getRevision().getValue());
                        if (logLatestPncBuilds) {
                            this.logLatestPncBuilds(e);
                            continue;
                        }
                        for (String s : ProjectDependencyResolver.toSortedStrings(e.artifacts.keySet(), this.config.isLogModulesToBuild())) {
                            this.log(s);
                        }
                    }
                    Collection<CircularReleaseDependency> circularDeps = ReleaseCollection.detectCircularDependencies(this.releaseRepos.values());
                    if (!circularDeps.isEmpty()) {
                        this.logComment("ERROR: The following circular dependency chains were detected among releases:");
                        Iterator<CircularReleaseDependency> chains = circularDeps.iterator();
                        int i2 = 0;
                        while (chains.hasNext()) {
                            this.logComment("  Chain #" + ++i2 + ":");
                            chains.next().getDependencyChain().forEach(id -> this.logComment("    " + id));
                            this.logComment("");
                        }
                    }
                    if (this.config.isLogCodeRepoTree()) {
                        this.logComment("");
                        this.logComment("Code repository dependency graph");
                        for (ReleaseRepo r : this.releaseRepos.values()) {
                            if (!r.isRoot()) continue;
                            this.logReleaseRepoDep(r, 0);
                        }
                        this.logComment("");
                    }
                } else {
                    for (String s : ProjectDependencyResolver.toSortedStrings(this.allDepsToBuild.keySet(), this.config.isLogModulesToBuild())) {
                        this.log(s);
                    }
                }
            }
            if (this.config.isLogNonManagedVisitied() && !this.nonManagedVisited.isEmpty()) {
                this.logComment("Non-managed dependencies visited walking dependency trees:");
                sorted = ProjectDependencyResolver.toSortedStrings(this.nonManagedVisited, this.config.isLogModulesToBuild());
                for (i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)((Object)sorted.get(i)));
                }
            }
            if (this.config.isLogRemaining()) {
                this.logComment("Remaining artifacts include:");
                sorted = ProjectDependencyResolver.toSortedStrings(this.remainingDeps, this.config.isLogModulesToBuild());
                for (i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)((Object)sorted.get(i)));
                }
            }
            if (this.config.isLogSummary()) {
                StringBuilder sb = new StringBuilder().append("Selecting ");
                if (this.config.getLevel() < 0) {
                    sb.append("all the");
                } else {
                    sb.append(this.config.getLevel()).append(" level(s) of");
                }
                if (this.config.isIncludeNonManaged()) {
                    sb.append(" managed and non-managed");
                } else {
                    sb.append(" managed (stopping at the first non-managed one)");
                }
                sb.append(" dependencies of supported extensions");
                if (this.config.getProjectBom() != null) {
                    sb.append(" from ").append(this.config.getProjectBom().toCompactCoords());
                }
                sb.append(" will result in:");
                this.logComment(sb.toString());
                sb.setLength(0);
                sb.append(this.allDepsToBuild.size()).append(" artifacts");
                if (codeReposTotal > 0) {
                    sb.append(" from ").append(codeReposTotal).append(" code repositories");
                }
                sb.append(" to build from source");
                this.logComment(sb.toString());
                if (this.config.isIncludeNonManaged() && !this.nonManagedVisited.isEmpty()) {
                    this.logComment("  * " + this.nonManagedVisited.size() + " of which is/are not managed by the BOM");
                }
                if (!this.skippedDeps.isEmpty()) {
                    this.logComment(this.skippedDeps.size() + " dependency nodes skipped");
                }
                this.logComment(this.allDepsToBuild.size() + this.skippedDeps.size() + " dependencies visited in total");
            }
        }
        finally {
            if (this.fileOutput != null) {
                this.log.info("Saving the report in " + this.logOutputFile.toAbsolutePath());
                this.fileOutput.close();
            }
        }
    }

    private void logLatestPncBuilds(ReleaseRepo e) {
        this.log.info("Checking the latest PNC builds of " + e.getRevision());
        HashSet<GAV> gavSet = new HashSet<GAV>(e.artifacts.size());
        Set<ArtifactCoords> artifactSet = e.artifacts.keySet();
        for (ArtifactCoords c : artifactSet) {
            gavSet.add(new GAV(c.getGroupId(), c.getArtifactId(), c.getVersion()));
        }
        Collection<PncArtifactLatestVersion> latestVersions = PncVersionProvider.getLastRedHatBuildVersions(gavSet);
        HashMap<GAV, String> pncRebuilds = new HashMap<GAV, String>(latestVersions.size());
        for (PncArtifactLatestVersion latest : latestVersions) {
            if (latest.getLatestVersion() == null || latest.getLatestVersion().equals(latest.getVersion())) continue;
            pncRebuilds.put(new GAV(latest.getGroupId(), latest.getArtifactId(), latest.getVersion()), latest.getLatestVersion());
        }
        ArrayList<String> lines = new ArrayList<String>(latestVersions.size());
        for (ArtifactCoords c : artifactSet) {
            GAV gav = new GAV(c.getGroupId(), c.getArtifactId(), c.getVersion());
            StringBuilder sb = null;
            if (!this.config.isLogModulesToBuild()) {
                sb = new StringBuilder();
                sb.append(c.toGACTVString());
            } else if (gavSet.remove(gav)) {
                sb = new StringBuilder();
                sb.append(gav);
            }
            if (sb == null) continue;
            String latestVersion = (String)pncRebuilds.get(gav);
            if (latestVersion != null) {
                sb.append(" # was rebuilt as ").append(latestVersion);
            }
            lines.add(sb.toString());
        }
        Collections.sort(lines);
        for (String line : lines) {
            this.log(line);
        }
    }

    public void resolveDependencies() {
        List<Dependency> enforcedConstraints = this.getBomConstraints(this.config.getProjectBom());
        for (ArtifactCoords bomCoords : this.config.getNonProjectBoms()) {
            enforcedConstraints.addAll(this.getBomConstraints(bomCoords));
        }
        if (this.artifactConstraintsProvider == null) {
            this.artifactConstraintsProvider = t -> enforcedConstraints;
        }
        this.projectBomConstraints = new HashSet<ArtifactCoords>(enforcedConstraints.size());
        for (Dependency d : enforcedConstraints) {
            this.projectBomConstraints.add(ProjectDependencyResolver.toCoords(d.getArtifact()));
        }
        for (DependencyTreeVisitor v : this.treeVisitors) {
            v.beforeAllRoots();
        }
        for (ArtifactCoords coords : this.getProjectArtifacts()) {
            if (!this.isIncluded(coords) && this.isExcluded(coords)) continue;
            this.processRootArtifact(coords);
        }
        for (ArtifactCoords coords : ProjectDependencyResolver.toSortedCoords(this.config.getIncludeArtifacts())) {
            if (!this.isIncluded(coords) && this.isExcluded(coords)) continue;
            this.processRootArtifact(coords);
        }
        if (!this.config.isIncludeAlreadyBuilt()) {
            this.removeProductizedDeps();
        }
        for (DependencyTreeVisitor v : this.treeVisitors) {
            v.afterAllRoots();
        }
    }

    private static List<ArtifactCoords> toSortedCoords(Collection<ArtifactCoords> col) {
        if (col.isEmpty()) {
            return List.of();
        }
        ArrayList<ArtifactCoords> list = new ArrayList<ArtifactCoords>(col);
        list.sort(ArtifactCoordsComparator.getInstance());
        return list;
    }

    private void removeProductizedDeps() {
        Iterator<ArtifactCoords> i = this.allDepsToBuild.keySet().iterator();
        while (i.hasNext()) {
            ArtifactCoords coords = i.next();
            if (!RhVersionPattern.isRhVersion(coords.getVersion())) continue;
            i.remove();
            this.artifactDeps.remove(coords);
            this.artifactDeps.values().forEach(d -> d.removeDependency(coords));
        }
        Iterator<Map.Entry<ScmRevision, ReleaseRepo>> ri = this.releaseRepos.entrySet().iterator();
        while (ri.hasNext()) {
            Map.Entry<ScmRevision, ReleaseRepo> releaseEntry = ri.next();
            Iterator<Map.Entry<ArtifactCoords, List<RemoteRepository>>> artifactI = releaseEntry.getValue().artifacts.entrySet().iterator();
            while (artifactI.hasNext()) {
                if (!RhVersionPattern.isRhVersion(artifactI.next().getKey().getVersion())) continue;
                artifactI.remove();
            }
            if (!releaseEntry.getValue().getArtifacts().isEmpty()) continue;
            ri.remove();
            for (ReleaseRepo r : this.releaseRepos.values()) {
                r.dependencies.remove(releaseEntry.getKey());
                r.dependants.remove(releaseEntry.getKey());
            }
        }
    }

    protected Iterable<ArtifactCoords> getProjectArtifacts() {
        ArtifactCoords bom;
        List<Object> result = null;
        if (!this.config.getProjectArtifacts().isEmpty()) {
            result = new ArrayList<ArtifactCoords>(this.config.getProjectArtifacts());
            bom = this.config.getProjectBom();
            if (bom != null) {
                if (!"pom".equals(bom.getType())) {
                    bom = ArtifactCoords.pom((String)bom.getGroupId(), (String)bom.getArtifactId(), (String)bom.getVersion());
                }
                if (!result.contains(bom)) {
                    result.add(bom);
                }
            }
            this.projectGavs = this.config.getProjectBom() == null ? Set.of() : Set.of(new com.redhat.hacbs.recipies.GAV(this.config.getProjectBom().getGroupId(), this.config.getProjectBom().getArtifactId(), this.config.getProjectBom().getVersion()));
        } else if (this.config.getProjectBom() != null) {
            result = new ArrayList();
            bom = this.config.getProjectBom();
            if (!"pom".equals(bom.getType())) {
                bom = ArtifactCoords.pom((String)bom.getGroupId(), (String)bom.getArtifactId(), (String)bom.getVersion());
            }
            result.add(bom);
            for (ArtifactCoords artifactCoords : this.projectBomConstraints) {
                boolean collect;
                if (this.includeSet.isEmpty()) {
                    collect = artifactCoords.getGroupId().startsWith(this.config.getProjectBom().getGroupId()) && !this.isExcluded(artifactCoords);
                } else {
                    boolean bl = collect = !this.isExcluded(artifactCoords) && this.isIncluded(artifactCoords);
                }
                if (!collect) continue;
                result.add(artifactCoords);
                this.log.debug(artifactCoords.toCompactCoords() + " selected as a top level artifact to build");
            }
            this.projectGavs = Set.of(new com.redhat.hacbs.recipies.GAV(this.config.getProjectBom().getGroupId(), this.config.getProjectBom().getArtifactId(), this.config.getProjectBom().getVersion()));
        } else if (this.config.getProjectDir() != null) {
            BuildTool buildTool = BuildTool.forProjectDir(this.config.getProjectDir());
            if (BuildTool.MAVEN.equals((Object)buildTool)) {
                LocalWorkspace localWorkspace = this.resolver.getMavenContext().getWorkspace();
                result = MavenProjectReader.resolveModuleDependencies(localWorkspace);
                if (!result.isEmpty()) {
                    final ArrayList<Path> arrayList = new ArrayList<Path>(localWorkspace.getProjects().size());
                    for (LocalProject project : this.resolver.getMavenContext().getWorkspace().getProjects().values()) {
                        Path classesDir;
                        if (project.getRawModel().getPackaging().equals("pom") || Files.exists(classesDir = project.getClassesDir(), new LinkOption[0])) continue;
                        Path topDirToCreate = classesDir;
                        while (!Files.exists(topDirToCreate.getParent(), new LinkOption[0])) {
                            topDirToCreate = topDirToCreate.getParent();
                        }
                        try {
                            Files.createDirectories(classesDir, new FileAttribute[0]);
                            arrayList.add(topDirToCreate);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to create " + classesDir, e);
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (Path p : arrayList) {
                                    IoUtils.recursiveDelete((Path)p);
                                }
                            }
                        }));
                    }
                }
            } else if (BuildTool.GRADLE.equals((Object)buildTool)) {
                this.preResolvedRootArtifacts = GradleProjectReader.resolveModuleDependencies(this.config.getProjectDir(), this.config.isGradleJava8(), this.config.getGradleJavaHome(), this.resolver, this.log);
                result = new ArrayList<ArtifactCoords>(this.preResolvedRootArtifacts.keySet());
                try (Git git = Git.open((File)this.config.getProjectDir().toFile());){
                    Repository repository = git.getRepository();
                    String repoUrl = repository.getConfig().getString("remote", "origin", "url");
                    this.projectRevision = ReleaseIdFactory.forScmAndTag((String)repoUrl, (String)repository.getBranch());
                }
                catch (IOException iOException) {
                    this.log.warn("Failed to determine the Git repository URL: ", new Object[]{iOException.getLocalizedMessage()});
                    ArtifactCoords artifactCoords = (ArtifactCoords)result.iterator().next();
                    this.projectRevision = ReleaseIdFactory.forGav((String)artifactCoords.getGroupId(), (String)artifactCoords.getArtifactId(), (String)artifactCoords.getVersion());
                }
            } else {
                throw new IllegalStateException("Unrecognized build tool " + buildTool);
            }
            this.projectGavs = new HashSet<com.redhat.hacbs.recipies.GAV>(result.size());
            for (ArtifactCoords artifactCoords : result) {
                this.projectGavs.add(ProjectDependencyResolver.toGav(artifactCoords));
            }
        } else {
            throw new IllegalArgumentException("Failed to determine project artifacts for the analysis: expected at least one of projectArtifacts, projectBom or projectDir to be configured");
        }
        result.sort(ArtifactCoordsComparator.getInstance());
        if (this.log.isDebugEnabled()) {
            this.log.debug("The following project artifacts will be processed:");
            for (ArtifactCoords artifactCoords : result) {
                this.log.debug(artifactCoords.toCompactCoords());
            }
        }
        return result;
    }

    private void processRootArtifact(ArtifactCoords rootArtifact) {
        block9: {
            DependencyNode root;
            block8: {
                ResolvedDependency resolved;
                List<Dependency> managedDeps = this.artifactConstraintsProvider.apply(rootArtifact);
                root = this.collectDependencies(rootArtifact, managedDeps);
                if (root == null) {
                    return;
                }
                try {
                    resolved = this.addArtifactToBuild(rootArtifact, root.getRepositories());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to process " + rootArtifact, e);
                }
                if (resolved == null) break block8;
                for (DependencyTreeVisitor dependencyTreeVisitor : this.treeVisitors) {
                    dependencyTreeVisitor.enterRootArtifact(resolved);
                }
                ArtifactDependency extDep = this.getOrCreateArtifactDep(resolved);
                if (!this.config.isExcludeParentPoms() && this.config.isLogTrees()) {
                    extDep.logBomImportsAndParents();
                }
                for (DependencyNode d : root.getChildren()) {
                    if (d.getDependency().isOptional() && !this.config.isIncludeOptionalDeps() && !this.isIncluded(ProjectDependencyResolver.toCoords(d.getArtifact()))) continue;
                    this.processNodes(d, 1, false);
                }
                for (DependencyTreeVisitor v : this.treeVisitors) {
                    v.leaveRootArtifact(resolved);
                }
                break block9;
            }
            if (!this.config.isLogRemaining()) break block9;
            for (DependencyNode dependencyNode : root.getChildren()) {
                this.processNodes(dependencyNode, 1, true);
            }
        }
    }

    private DependencyNode collectDependencies(ArtifactCoords coords, List<Dependency> managedDeps) {
        DependencyNode root = this.preResolvedRootArtifacts.get(coords);
        if (root != null) {
            return root;
        }
        try {
            List<Dependency> constraints;
            DefaultArtifact a = ProjectDependencyResolver.toAetherArtifact(coords);
            ArtifactDescriptorResult descr = this.resolver.resolveDescriptor((Artifact)a);
            if (descr.getManagedDependencies().isEmpty()) {
                constraints = managedDeps;
            } else {
                Artifact art;
                LinkedHashMap<ArtifactKey, Dependency> map = new LinkedHashMap<ArtifactKey, Dependency>();
                constraints = new ArrayList<Dependency>(managedDeps.size());
                for (Dependency d : managedDeps) {
                    art = d.getArtifact();
                    map.put(ArtifactKey.of((String)art.getGroupId(), (String)art.getArtifactId(), (String)art.getClassifier(), (String)art.getExtension()), d);
                    constraints.add(d);
                }
                for (Dependency d : descr.getManagedDependencies()) {
                    art = d.getArtifact();
                    if (map.containsKey(ArtifactKey.of((String)art.getGroupId(), (String)art.getArtifactId(), (String)art.getClassifier(), (String)art.getExtension()))) continue;
                    constraints.add(d);
                }
            }
            ArrayList<Dependency> directDeps = new ArrayList<Dependency>(descr.getDependencies().size());
            for (Dependency d : descr.getDependencies()) {
                if (this.excludeScopes.contains(d.getScope()) || d.isOptional() && !this.config.isIncludeOptionalDeps()) continue;
                directDeps.add(d);
            }
            List aggregatedRepos = this.resolver.aggregateRepositories(this.resolver.getRepositories(), this.resolver.newResolutionRepositories(descr.getRepositories()));
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), MavenArtifactResolver.newCollectRequest((Artifact)a, directDeps, managedDeps, List.of(), (List)aggregatedRepos)).getRoot();
            if (root.getChildren().isEmpty()) {
                this.resolver.resolve((Artifact)a);
            }
        }
        catch (Exception e) {
            if (this.config.isWarnOnResolutionErrors()) {
                this.log.warn(e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage());
                this.allDepsToBuild.remove(coords);
                return null;
            }
            throw new RuntimeException("Failed to collect dependencies of " + coords.toCompactCoords(), e);
        }
        return root;
    }

    private boolean isCollectNonManagedVisited() {
        return this.config.isLogSummary() && this.config.isIncludeNonManaged() || this.config.isLogNonManagedVisitied();
    }

    private static DefaultArtifact toAetherArtifact(ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private void configureReleaseRepoDeps() {
        Iterator<Map.Entry<ScmRevision, ReleaseRepo>> i = this.releaseRepos.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getValue().artifacts.isEmpty()) continue;
            i.remove();
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ArtifactDescriptorResult descriptor;
            ArtifactCoords c = d.resolved.getCoords();
            DefaultArtifact pomArtifact = new DefaultArtifact(c.getGroupId(), c.getArtifactId(), "pom", c.getVersion());
            try {
                descriptor = this.resolver.resolveDescriptor((Artifact)pomArtifact);
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve artifact descriptor for " + c, e);
            }
            for (Dependency directDep : descriptor.getDependencies()) {
                Artifact a = directDep.getArtifact();
                ArtifactDependency dirArt = this.artifactDeps.get(ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion()));
                if (dirArt == null) continue;
                d.addDependency(dirArt);
            }
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ReleaseRepo repo = this.getRepo(d.resolved.getRevision());
            for (ArtifactDependency c : d.getAllDependencies()) {
                repo.addRepoDependency(this.getRepo(c.resolved.getRevision()));
            }
        }
    }

    private ScmRevision getRevision(ArtifactCoords coords, List<RemoteRepository> repos) {
        ScmRevision revision;
        if (this.preResolvedRootArtifacts.containsKey(coords)) {
            revision = this.projectRevision;
        } else {
            try {
                revision = this.revisionResolver.resolveRevision((Artifact)ProjectDependencyResolver.toAetherArtifact(coords), repos);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve release id for " + coords, e);
            }
        }
        this.getOrCreateRepo((ScmRevision)revision).artifacts.put(coords, repos);
        return revision;
    }

    private static ScmRevisionResolver newRevisionResolver(MavenArtifactResolver artifactResolver, final MessageWriter log, ProjectDependencyConfig config) {
        Path cloneBaseDir;
        if (config.isLegacyScmLocator()) {
            return ProjectDependencyResolver.getLegacyReleaseIdResolver(artifactResolver, log, config.isValidateCodeRepoTags());
        }
        List releaseDetectors = ServiceLoader.load(ReleaseIdDetector.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        try {
            cloneBaseDir = Files.createTempDirectory("domino", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    log.debug("Removing %s", new Object[]{cloneBaseDir});
                    TreeMap map = new TreeMap(Comparator.naturalOrder().reversed());
                    try (Stream<Path> files = Files.walk(cloneBaseDir, new FileVisitOption[0]);){
                        Iterator i = files.iterator();
                        while (i.hasNext()) {
                            Path p = (Path)i.next();
                            if (Files.isDirectory(p, new LinkOption[0])) {
                                map.computeIfAbsent(p.getNameCount(), k -> new ArrayList()).add(p);
                                continue;
                            }
                            Files.delete(p);
                        }
                        for (List paths : map.values()) {
                            for (Path p : paths) {
                                Files.delete(p);
                            }
                        }
                    }
                    catch (IOException e) {
                        log.warn("Failed to delete " + cloneBaseDir + ": " + e.getLocalizedMessage());
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AtomicReference<ScmRevisionResolver> ref = new AtomicReference<ScmRevisionResolver>();
        GitScmLocator scmLocator = GitScmLocator.builder().setRecipeRepos(config.getRecipeRepos()).setGitCloneBaseDir(cloneBaseDir).setCacheRepoTags(true).setCloneLocalRecipeRepos(false).setFallback(gav -> {
            DefaultArtifact pomArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "pom", gav.getVersion());
            ScmRevision releaseId = null;
            for (ReleaseIdDetector rd : releaseDetectors) {
                try {
                    ScmRevision rid = rd.detectReleaseId((ScmRevisionResolver)ref.get(), (Artifact)pomArtifact);
                    if (rid == null || !rid.getRepository().hasUrl() || !rid.getRepository().getUrl().contains("git")) continue;
                    releaseId = rid;
                    break;
                }
                catch (BomDecomposerException e) {
                    log.warn("Failed to determine SCM for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + ": " + e.getLocalizedMessage());
                }
            }
            if (releaseId == null) {
                try {
                    releaseId = ((ScmRevisionResolver)ref.get()).readRevisionFromPom((Artifact)pomArtifact);
                }
                catch (BomDecomposerException e) {
                    log.warn("Failed to determine SCM for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + " from POM metadata: " + e.getLocalizedMessage());
                }
            }
            if (releaseId != null && releaseId.getRepository().toString().contains(".git")) {
                throw new IllegalStateException(releaseId.toString());
            }
            if (releaseId != null && releaseId.getRepository().hasUrl() && releaseId.getRepository().getUrl().contains("git")) {
                log.warn("The SCM recipe database is missing an entry for " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion() + ", " + releaseId + " will be used as a fallback");
                return new TagInfo(new RepositoryInfo("git", releaseId.getRepository().getUrl()), releaseId.getValue(), null);
            }
            return null;
        }).build();
        boolean scmLocatorStats = ProjectDependencyResolver.isScmLocatorStats();
        ReleaseIdDetector hacbsScmLocator = new ReleaseIdDetector((ScmLocator)scmLocator, scmLocatorStats, config, log){
            int total;
            int succeeded;
            final /* synthetic */ ScmLocator val$scmLocator;
            final /* synthetic */ boolean val$scmLocatorStats;
            final /* synthetic */ ProjectDependencyConfig val$config;
            final /* synthetic */ MessageWriter val$log;
            {
                this.val$scmLocator = scmLocator;
                this.val$scmLocatorStats = bl;
                this.val$config = projectDependencyConfig;
                this.val$log = messageWriter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
                String version = RhVersionPattern.ensureNoRhQualifier(artifact.getVersion());
                com.redhat.hacbs.recipies.GAV gav = new com.redhat.hacbs.recipies.GAV(artifact.getGroupId(), artifact.getArtifactId(), version);
                ++this.total;
                Exception error = null;
                try {
                    TagInfo tag = this.val$scmLocator.resolveTagInfo(gav);
                    if (tag != null) {
                        ++this.succeeded;
                        String uri = tag.getRepoInfo().getUri();
                        if (uri.endsWith(".git")) {
                            uri = uri.substring(0, uri.length() - 4);
                        }
                        ScmRevision scmRevision = ScmRevision.tag((ScmRepository)ScmRepository.ofUrl((String)uri), (String)tag.getTag());
                        return scmRevision;
                    }
                }
                catch (Exception e) {
                    error = e;
                }
                finally {
                    if (this.val$scmLocatorStats) {
                        System.out.println("ScmLocator resolved " + this.succeeded + " out of " + this.total);
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to determine the SCM for ").append(artifact);
                if (!version.equals(artifact.getVersion())) {
                    sb.append(" using its upstream version ").append(version);
                }
                if (this.val$config.isWarnOnMissingScm()) {
                    if (error != null) {
                        sb.append(": ").append(error.getLocalizedMessage());
                    }
                } else {
                    throw new RuntimeException(sb.toString(), error);
                }
                this.val$log.warn(sb.toString());
                return null;
            }
        };
        ScmRevisionResolver releaseResolver = new ScmRevisionResolver(artifactResolver, List.of(new PncReleaseIdDetector(new PncBuildInfoProvider()), hacbsScmLocator), log, config.isValidateCodeRepoTags());
        ref.set(releaseResolver);
        return releaseResolver;
    }

    private static ScmRevisionResolver getLegacyReleaseIdResolver(MavenArtifactResolver artifactResolver, MessageWriter log, boolean validateCodeRepoTags) {
        ArrayList<Object> releaseDetectors = new ArrayList<Object>();
        releaseDetectors.add(new PncReleaseIdDetector(new PncBuildInfoProvider()));
        releaseDetectors.add(new ReleaseIdDetector(){
            final Set<String> artifactIdRepos = Set.of("vertx-service-proxy", "vertx-amqp-client", "vertx-health-check", "vertx-camel-bridge", "vertx-redis-client", "vertx-json-schema", "vertx-lang-groovy", "vertx-mail-client", "vertx-http-service-factory", "vertx-tcp-eventbus-bridge", "vertx-dropwizard-metrics", "vertx-consul-client", "vertx-maven-service-factory", "vertx-cassandra-client", "vertx-circuit-breaker", "vertx-jdbc-client", "vertx-reactive-streams", "vertx-rabbitmq-client", "vertx-mongo-client", "vertx-sockjs-service-proxy", "vertx-kafka-client", "vertx-micrometer-metrics", "vertx-service-factory");

            public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
                if (!"io.vertx".equals(artifact.getGroupId())) {
                    return null;
                }
                String s = artifact.getArtifactId();
                if (!s.startsWith("vertx-")) {
                    return releaseResolver.readRevisionFromPom(artifact);
                }
                if (s.equals("vertx-uri-template") || s.equals("vertx-codegen") || s.equals("vertx-http-proxy")) {
                    return ReleaseIdFactory.forScmAndTag((String)("https://github.com/eclipse-vertx/" + s), (String)artifact.getVersion());
                }
                if (s.equals("vertx-core")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vert.x", (String)artifact.getVersion());
                }
                if (s.startsWith("vertx-tracing") || s.equals("vertx-opentelemetry") || s.equals("vertx-opentracing") || s.equals("vertx-zipkin")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vertx-tracing", (String)artifact.getVersion());
                }
                ScmRevision defaultReleaseId = releaseResolver.readRevisionFromPom(artifact);
                if (defaultReleaseId.getRepository().getId().endsWith("vertx-sql-client")) {
                    return defaultReleaseId;
                }
                if (s.startsWith("vertx-ext")) {
                    s = "vertx-ext-parent";
                } else if (!this.artifactIdRepos.contains(s)) {
                    int i;
                    if (s.startsWith("vertx-lang-kotlin")) {
                        s = "vertx-lang-kotlin";
                    } else if (s.startsWith("vertx-service-discovery")) {
                        s = "vertx-service-discovery";
                    } else if (s.equals("vertx-template-engines")) {
                        s = "vertx-web";
                    } else if (s.equals("vertx-web-sstore-infinispan")) {
                        s = "vertx-infinispan";
                    } else if (s.startsWith("vertx-junit5-rx")) {
                        s = "vertx-rx";
                    } else if (!s.equals("vertx-bridge-common") && (i = s.indexOf(45, "vertx-".length())) > 0) {
                        s = s.substring(0, i);
                    }
                }
                return ReleaseIdFactory.forScmAndTag((String)("https://github.com/vert-x3/" + s), (String)artifact.getVersion());
            }
        });
        releaseDetectors.addAll(ServiceLoader.load(ReleaseIdDetector.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList()));
        return new ScmRevisionResolver(artifactResolver, releaseDetectors, log, validateCodeRepoTags);
    }

    private void logReleaseRepoDep(ReleaseRepo repo, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(repo.getRevision().origin()).append(' ').append(repo.getRevision().version());
        this.logComment(sb.toString());
        for (ReleaseRepo child : repo.dependencies.values()) {
            this.logReleaseRepoDep(child, depth + 1);
        }
    }

    private static List<String> toSortedStrings(Collection<ArtifactCoords> coords, boolean asModules) {
        ArrayList<String> list;
        if (asModules) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (ArtifactCoords c : coords) {
                set.add((CallSite)((Object)(c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion())));
            }
            list = new ArrayList(set);
        } else {
            list = new ArrayList<String>(coords.size());
            for (ArtifactCoords c : coords) {
                list.add(c.toGACTVString());
            }
        }
        Collections.sort(list);
        return list;
    }

    private MessageWriter getOutput() {
        if (this.logOutputFile == null) {
            return this.log;
        }
        if (this.outputWriter == null) {
            try {
                OpenOption[] openOptionArray;
                if (this.logOutputFile.getParent() != null) {
                    Files.createDirectories(this.logOutputFile.getParent(), new FileAttribute[0]);
                }
                if (this.appendOutput) {
                    OpenOption[] openOptionArray2 = new OpenOption[2];
                    openOptionArray2[0] = StandardOpenOption.CREATE;
                    openOptionArray = openOptionArray2;
                    openOptionArray2[1] = StandardOpenOption.APPEND;
                } else {
                    openOptionArray = new OpenOption[]{};
                }
                OpenOption[] oo = openOptionArray;
                this.fileOutput = new PrintStream(Files.newOutputStream(this.logOutputFile, oo), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open " + this.logOutputFile + " for writing", e);
            }
            this.outputWriter = MessageWriter.info((PrintStream)this.fileOutput);
        }
        return this.outputWriter;
    }

    private void logComment(String msg) {
        this.log("# " + msg);
    }

    private void log(String msg) {
        this.getOutput().info(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNodes(DependencyNode node, int level, boolean remaining) {
        DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
        if (winner != null) {
            ArtifactCoords coords = ProjectDependencyResolver.toCoords(winner.getArtifact());
            for (DependencyTreeVisitor v : this.treeVisitors) {
                v.linkDependency(coords);
            }
            return;
        }
        ArtifactCoords coords = ProjectDependencyResolver.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        ResolvedDependency visit = null;
        if (remaining) {
            this.addToRemaining(coords);
        } else if (this.config.getLevel() < 0 || level <= this.config.getLevel()) {
            visit = this.addArtifactToBuild(coords, node.getRepositories());
            if (visit != null) {
                for (DependencyTreeVisitor v : this.treeVisitors) {
                    v.enterDependency(visit);
                }
                ArtifactDependency artDep = this.getOrCreateArtifactDep(visit);
                if (this.config.isLogTrees()) {
                    artDep.logBomImportsAndParents();
                }
            } else {
                if (!this.config.isLogRemaining()) return;
                remaining = true;
            }
        } else {
            this.addToSkipped(coords);
            if (!this.config.isLogRemaining()) return;
            remaining = true;
            this.addToRemaining(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(child, level + 1, remaining);
        }
        if (visit == null) return;
        for (DependencyTreeVisitor v : this.treeVisitors) {
            v.leaveDependency(visit);
        }
    }

    private ResolvedDependency addArtifactToBuild(ArtifactCoords coords, List<RemoteRepository> repos) {
        boolean managed = this.projectBomConstraints.contains(coords);
        if (!managed && this.isCollectNonManagedVisited()) {
            this.nonManagedVisited.add(coords);
        }
        if (managed || this.config.isIncludeNonManaged() || this.isIncluded(coords) || coords.getType().equals("pom") && (!this.config.isExcludeParentPoms() || this.projectGavs.contains(ProjectDependencyResolver.toGav(coords)))) {
            ResolvedDependency resolved = new ResolvedDependency(this.getRevision(coords, repos), coords, repos, managed);
            if (!this.config.isExcludeParentPoms()) {
                this.addImportedBomsAndParentPomToBuild(resolved);
            }
            this.allDepsToBuild.put(coords, resolved);
            this.skippedDeps.remove(coords);
            this.remainingDeps.remove(coords);
            return resolved;
        }
        this.addToSkipped(coords);
        if (this.config.isLogRemaining()) {
            this.addToRemaining(coords);
        }
        return null;
    }

    private Map<String, String> addImportedBomsAndParentPomToBuild(ResolvedDependency dependency) {
        Model model;
        Path pomXml;
        ArtifactCoords pomCoords;
        ArtifactCoords artifactCoords = pomCoords = dependency.getCoords().getType().equals("pom") ? dependency.getCoords() : ArtifactCoords.pom((String)dependency.getCoords().getGroupId(), (String)dependency.getCoords().getArtifactId(), (String)dependency.getCoords().getVersion());
        if (this.allDepsToBuild.containsKey(pomCoords)) {
            return this.effectivePomProps.getOrDefault(pomCoords, Map.of());
        }
        try {
            pomXml = this.resolver.resolve((Artifact)ProjectDependencyResolver.toAetherArtifact(pomCoords), dependency.getRepositories()).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            if (this.config.isWarnOnResolutionErrors()) {
                this.log.warn(e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage());
                this.allDepsToBuild.remove(pomCoords);
                return Map.of();
            }
            throw new IllegalStateException("Failed to resolve " + pomCoords, e);
        }
        try {
            model = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + pomXml, e);
        }
        ArtifactDependency artDep = this.getOrCreateArtifactDep(dependency);
        Map<String, String> parentPomProps = null;
        Parent parent = model.getParent();
        if (parent != null) {
            ArtifactCoords parentPomCoords;
            String parentVersion = parent.getVersion();
            if (ModelUtils.isUnresolvedVersion((String)parentVersion)) {
                if (model.getVersion() == null || model.getVersion().equals(parentVersion)) {
                    parentVersion = pomCoords.getVersion();
                } else {
                    this.log.warn("Failed to resolve the version of" + parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " as a parent of " + pomCoords);
                    parentVersion = null;
                }
            }
            if (parentVersion != null && !this.isExcluded(parentPomCoords = ArtifactCoords.pom((String)parent.getGroupId(), (String)parent.getArtifactId(), (String)parentVersion))) {
                ResolvedDependency resolvedParent = this.addArtifactToBuild(parentPomCoords, dependency.getRepositories());
                artDep.setParentPom(this.getOrCreateArtifactDep(resolvedParent));
                parentPomProps = this.addImportedBomsAndParentPomToBuild(resolvedParent);
            }
        }
        if (this.config.isExcludeBomImports()) {
            return Map.of();
        }
        Map<String, String> pomProps = this.getModelProperties(pomCoords, model);
        if (parentPomProps != null) {
            HashMap<String, String> tmp = new HashMap<String, String>(parentPomProps.size() + pomProps.size());
            tmp.putAll(parentPomProps);
            tmp.putAll(pomProps);
            pomProps = tmp;
        }
        this.effectivePomProps.put(pomCoords, pomProps);
        this.addImportedBomsToBuild(artDep, model, pomProps);
        return pomProps;
    }

    private Map<String, String> getModelProperties(ArtifactCoords pomCoords, Model model) {
        Map<String, String> pomProps = ProjectDependencyResolver.toMap(model.getProperties());
        for (Profile profile : model.getProfiles()) {
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault() || profile.getProperties().isEmpty()) continue;
            ProjectDependencyResolver.addAll(pomProps, profile.getProperties());
        }
        pomProps.put("project.version", pomCoords.getVersion());
        pomProps.put("project.groupId", pomCoords.getGroupId());
        return pomProps;
    }

    private void addImportedBomsToBuild(ArtifactDependency pomArtDep, Model model, Map<String, String> effectiveProps) {
        DependencyManagement dm = model.getDependencyManagement();
        if (dm == null) {
            return;
        }
        for (org.apache.maven.model.Dependency d : dm.getDependencies()) {
            ResolvedDependency resolvedImport;
            if (!"import".equals(d.getScope()) || !"pom".equals(d.getType())) continue;
            String groupId = this.resolveProperty(d.getGroupId(), d, effectiveProps);
            String artifactId = this.resolveProperty(d.getArtifactId(), d, effectiveProps);
            String version = this.resolveProperty(d.getVersion(), d, effectiveProps);
            if (groupId == null || version == null || artifactId == null) {
                this.log.warn("Failed to resolve coordindates of " + d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getClassifier() + ":" + d.getType() + ":" + d.getVersion());
                continue;
            }
            ArtifactCoords bomCoords = ArtifactCoords.pom((String)groupId, (String)artifactId, (String)version);
            if (this.isExcluded(bomCoords) || (resolvedImport = this.addArtifactToBuild(bomCoords, pomArtDep.resolved.getRepositories())) == null) continue;
            pomArtDep.addBomImport(this.getOrCreateArtifactDep(resolvedImport));
            this.addImportedBomsAndParentPomToBuild(resolvedImport);
        }
    }

    private String resolveProperty(String expr, org.apache.maven.model.Dependency dep, Map<String, String> props) {
        String value = PropertyResolver.resolvePropertyOrNull(expr, props);
        if (value == null) {
            this.log.warn("Failed to resolve property " + expr + " from " + dep);
        }
        return value;
    }

    private void addToSkipped(ArtifactCoords coords) {
        if (!this.allDepsToBuild.containsKey(coords)) {
            this.skippedDeps.add(coords);
        }
    }

    private void addToRemaining(ArtifactCoords coords) {
        if (!this.allDepsToBuild.containsKey(coords)) {
            this.remainingDeps.add(coords);
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        for (ArtifactCoordsPattern pattern : this.excludeSet) {
            boolean matches = pattern.matches(coords);
            if (!matches) continue;
            return true;
        }
        return !this.includeTestJars && coords.getClassifier().equals("tests");
    }

    private boolean isIncluded(ArtifactCoords coords) {
        for (ArtifactCoordsPattern pattern : this.includeSet) {
            if (!pattern.matches(coords)) continue;
            return true;
        }
        return false;
    }

    private List<Dependency> getBomConstraints(ArtifactCoords bomCoords) {
        List managedDeps;
        if (bomCoords == null) {
            return List.of();
        }
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve the descriptor of " + bomCoords, e);
        }
        if (managedDeps.isEmpty()) {
            throw new RuntimeException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ArtifactDependency getOrCreateArtifactDep(ResolvedDependency resolved) {
        return this.artifactDeps.computeIfAbsent(resolved.getCoords(), k -> new ArtifactDependency(resolved));
    }

    private ReleaseRepo getOrCreateRepo(ScmRevision id) {
        return this.releaseRepos.computeIfAbsent(id, ReleaseRepo::new);
    }

    private ReleaseRepo getRepo(ScmRevision id) {
        return Objects.requireNonNull(this.releaseRepos.get(id));
    }

    private static Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(ProjectDependencyResolver.toString(e.getKey()), ProjectDependencyResolver.toString(e.getValue()));
        }
        return map;
    }

    private static void addAll(Map<String, String> map, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(ProjectDependencyResolver.toString(e.getKey()), ProjectDependencyResolver.toString(e.getValue()));
        }
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static com.redhat.hacbs.recipies.GAV toGav(ArtifactCoords coords) {
        return new com.redhat.hacbs.recipies.GAV(coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private class ArtifactDependency {
        final ResolvedDependency resolved;
        final Map<ArtifactCoords, ArtifactDependency> children = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        final Map<ArtifactCoords, ArtifactDependency> bomImports = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        ArtifactDependency parentPom;

        ArtifactDependency(ResolvedDependency resolved) {
            this.resolved = resolved;
        }

        public void addBomImport(ArtifactDependency bomDep) {
            this.bomImports.put(bomDep.resolved.getCoords(), bomDep);
        }

        public void setParentPom(ArtifactDependency parentPom) {
            this.parentPom = parentPom;
        }

        void addDependency(ArtifactDependency d) {
            this.children.putIfAbsent(d.resolved.getCoords(), d);
        }

        Iterable<ArtifactDependency> getAllDependencies() {
            ArrayList<ArtifactDependency> list = new ArrayList<ArtifactDependency>(this.children.size() + this.bomImports.size() + 1);
            if (this.parentPom != null) {
                list.add(this.parentPom);
            }
            list.addAll(this.bomImports.values());
            list.addAll(this.children.values());
            return list;
        }

        private void removeDependency(ArtifactCoords coords) {
            if (this.children.remove(coords) != null) {
                return;
            }
            if (this.bomImports.remove(coords) != null) {
                return;
            }
            if (this.parentPom != null && this.parentPom.resolved.getCoords().equals(coords)) {
                this.parentPom = null;
            }
        }

        private void logBomImportsAndParents() {
            if (this.parentPom == null && this.bomImports.isEmpty()) {
                return;
            }
            if (this.parentPom != null) {
                for (DependencyTreeVisitor v : ProjectDependencyResolver.this.treeVisitors) {
                    v.enterParentPom(this.parentPom.resolved);
                }
                this.parentPom.logBomImportsAndParents();
                for (DependencyTreeVisitor v : ProjectDependencyResolver.this.treeVisitors) {
                    v.leaveParentPom(this.parentPom.resolved);
                }
            }
            for (ArtifactDependency d : this.bomImports.values()) {
                for (DependencyTreeVisitor v : ProjectDependencyResolver.this.treeVisitors) {
                    v.enterBomImport(d.resolved);
                }
                d.logBomImportsAndParents();
                for (DependencyTreeVisitor v : ProjectDependencyResolver.this.treeVisitors) {
                    v.leaveBomImport(d.resolved);
                }
            }
        }
    }

    public static class Builder {
        private MavenArtifactResolver resolver;
        private Function<ArtifactCoords, List<Dependency>> artifactConstraintsProvider;
        private MessageWriter log;
        private ProjectDependencyConfig depConfig;
        private Path logOutputFile;
        private boolean appendOutput;
        private List<DependencyTreeVisitor> visitors = List.of();

        private Builder() {
        }

        private Builder(ProjectDependencyConfig config) {
            this.depConfig = config;
        }

        public Builder addDependencyTreeVisitor(DependencyTreeVisitor visitor) {
            switch (this.visitors.size()) {
                case 0: {
                    this.visitors = List.of(visitor);
                    break;
                }
                case 1: {
                    this.visitors = List.of(this.visitors.get(0), visitor);
                    break;
                }
                case 2: {
                    this.visitors = new ArrayList<DependencyTreeVisitor>(this.visitors);
                }
                default: {
                    this.visitors.add(visitor);
                }
            }
            return this;
        }

        public Builder setArtifactResolver(MavenArtifactResolver artifactResolver) {
            this.resolver = artifactResolver;
            return this;
        }

        public Builder setArtifactConstraintsProvider(Function<ArtifactCoords, List<Dependency>> constraintsProvider) {
            this.artifactConstraintsProvider = constraintsProvider;
            return this;
        }

        public Builder setMessageWriter(MessageWriter msgWriter) {
            this.log = msgWriter;
            return this;
        }

        public Builder setLogOutputFile(Path file) {
            this.logOutputFile = file;
            return this;
        }

        public Path getLogOutputFile() {
            return this.logOutputFile;
        }

        public Builder setAppendOutput(boolean appendOutput) {
            this.appendOutput = appendOutput;
            return this;
        }

        public Builder setDependencyConfig(ProjectDependencyConfig depConfig) {
            this.depConfig = depConfig;
            return this;
        }

        public ProjectDependencyConfig getDependencyConfig() {
            return this.depConfig;
        }

        public ProjectDependencyResolver build() {
            return new ProjectDependencyResolver(this);
        }

        private MavenArtifactResolver getInitializedResolver() {
            if (this.resolver == null) {
                try {
                    BootstrapMavenContextConfig mvnConfig = BootstrapMavenContext.config();
                    if (this.depConfig == null || this.depConfig.getProjectDir() == null) {
                        mvnConfig.setWorkspaceDiscovery(false);
                    } else {
                        mvnConfig.setCurrentProject(this.depConfig.getProjectDir().toString()).setEffectiveModelBuilder(true).setPreferPomsFromWorkspace(true);
                    }
                    BootstrapMavenContext mvnCtx = new BootstrapMavenContext(mvnConfig);
                    if (this.depConfig.isVerboseGraphs()) {
                        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(mvnCtx.getRepositorySystemSession());
                        session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                        session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                        mvnConfig.setRepositorySystemSession((RepositorySystemSession)session).setRepositorySystem(mvnCtx.getRepositorySystem()).setRemoteRepositoryManager(mvnCtx.getRemoteRepositoryManager()).setRemoteRepositories(mvnCtx.getRemoteRepositories()).setCurrentProject(mvnCtx.getCurrentProject());
                        mvnCtx = new BootstrapMavenContext(mvnConfig);
                    }
                    return new MavenArtifactResolver(mvnCtx);
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
                }
            }
            if (this.depConfig != null && this.depConfig.isVerboseGraphs() && (Boolean.FALSE.equals(this.resolver.getSession().getConfigProperties().getOrDefault("aether.conflictResolver.verbose", false)) || Boolean.FALSE.equals(this.resolver.getSession().getConfigProperties().getOrDefault("aether.dependencyManager.verbose", false)))) {
                BootstrapMavenContext mvnCtx = this.resolver.getMavenContext();
                try {
                    DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(mvnCtx.getRepositorySystemSession());
                    session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                    session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                    mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystemSession((RepositorySystemSession)session).setRepositorySystem(mvnCtx.getRepositorySystem()).setRemoteRepositoryManager(mvnCtx.getRemoteRepositoryManager()).setRemoteRepositories(mvnCtx.getRemoteRepositories()).setCurrentProject(mvnCtx.getCurrentProject()));
                    return new MavenArtifactResolver(mvnCtx);
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
                }
            }
            return this.resolver;
        }

        private MessageWriter getInitializedLog() {
            return this.log == null ? MessageWriter.info() : this.log;
        }
    }
}

