/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.manifest;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class TreeNode {
    final String id;
    final String name;
    final Map<String, TreeNode> children = new HashMap<String, TreeNode>();

    static TreeNode of(String id) {
        return new TreeNode(id, id);
    }

    static TreeNode of(String id, String name) {
        return new TreeNode(id, name);
    }

    private TreeNode(String id, String name) {
        this.id = id;
        this.name = name;
    }

    void addChild(TreeNode child) {
        if (this.children.put(child.name, child) != null) {
            throw new IllegalStateException("Tree node " + child.name + " has already");
        }
    }

    void isIdentical(TreeNode other) {
        this.isIdentical(new ArrayDeque<TreeNode>(), other);
    }

    private void isIdentical(ArrayDeque<TreeNode> branch, TreeNode other) {
        if (!this.name.equals(other.name)) {
            throw new RuntimeException("Name mismatch: " + this.name + " vs " + other.name);
        }
        if (!this.children.keySet().equals(other.children.keySet())) {
            int j;
            StringBuilder sb = new StringBuilder();
            Iterator<TreeNode> i = branch.descendingIterator();
            int level = 0;
            while (i.hasNext()) {
                for (j = 0; j < level; ++j) {
                    sb.append("  ");
                }
                sb.append(i.next().name).append(System.lineSeparator());
                ++level;
            }
            for (j = 0; j < level; ++j) {
                sb.append("  ");
            }
            sb.append(this.name).append(System.lineSeparator());
            sb.append("expected direct dependencies");
            ArrayList<String> childNames = new ArrayList<String>(this.children.keySet());
            Collections.sort(childNames);
            sb.append(System.lineSeparator());
            childNames.forEach(name -> sb.append("- ").append((String)name).append(System.lineSeparator()));
            childNames = new ArrayList<String>(other.children.keySet());
            Collections.sort(childNames);
            sb.append("but got").append(System.lineSeparator());
            childNames.forEach(name -> sb.append("- ").append((String)name).append(System.lineSeparator()));
            throw new RuntimeException(sb.toString());
        }
        if (!this.children.isEmpty()) {
            branch.push(this);
            for (TreeNode child : this.children.values()) {
                child.isIdentical(branch, other.children.get(child.name));
            }
            branch.pop();
        }
    }
}

