/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.common.deployment;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ConfigRoot(name="elasticsearch", phase=ConfigPhase.BUILD_TIME)
public class ElasticsearchCommonBuildTimeConfig {
    @ConfigItem
    @ConfigDocSection(generated=true)
    public ElasticsearchDevServicesBuildTimeConfig devservices;

    @ConfigGroup
    public static class ElasticsearchDevServicesBuildTimeConfig {
        @ConfigItem
        public Optional<Boolean> enabled = Optional.empty();
        @ConfigItem
        public Optional<Integer> port;
        @ConfigItem
        public Optional<Distribution> distribution;
        @ConfigItem
        public Optional<String> imageName;
        @ConfigItem(defaultValue="-Xms512m -Xmx1g")
        public String javaOpts;
        @ConfigItem(defaultValue="true")
        public boolean shared;
        @ConfigItem(defaultValue="elasticsearch")
        public String serviceName;
        @ConfigItem
        @ConfigDocMapKey(value="environment-variable-name")
        public Map<String, String> containerEnv;
        @ConfigItem(defaultValue="true")
        public boolean reuse;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElasticsearchDevServicesBuildTimeConfig that = (ElasticsearchDevServicesBuildTimeConfig)o;
            return Objects.equals(this.shared, that.shared) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.port, that.port) && Objects.equals(this.distribution, that.distribution) && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.javaOpts, that.javaOpts) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.containerEnv, that.containerEnv) && Objects.equals(this.reuse, that.reuse);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.port, this.distribution, this.imageName, this.javaOpts, this.shared, this.serviceName, this.containerEnv, this.reuse);
        }

        public static enum Distribution {
            ELASTIC,
            OPENSEARCH;

        }
    }
}

