/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.common.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.elasticsearch.restclient.common.deployment.ElasticsearchDevServicesBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesElasticsearchProcessor {
    private static final Logger log = Logger.getLogger(DevServicesElasticsearchProcessor.class);
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-elasticsearch";
    static final int ELASTICSEARCH_PORT = 9200;
    private static final ContainerLocator elasticsearchContainerLocator = new ContainerLocator("quarkus-dev-service-elasticsearch", 9200);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile ElasticsearchDevServicesBuildTimeConfig cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startElasticsearchDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, ElasticsearchDevServicesBuildTimeConfig configuration, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, List<DevservicesElasticsearchBuildItem> devservicesElasticsearchBuildItems) throws BuildException {
        if (devservicesElasticsearchBuildItems.isEmpty()) {
            return null;
        }
        DevservicesElasticsearchBuildItemsConfiguration buildItemsConfig = new DevservicesElasticsearchBuildItemsConfiguration(devservicesElasticsearchBuildItems);
        if (devService != null) {
            boolean shouldShutdownTheServer;
            boolean bl = shouldShutdownTheServer = !configuration.equals(cfg);
            if (!shouldShutdownTheServer) {
                return devService.toBuildItem();
            }
            this.shutdownElasticsearch();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Dev Services for Elasticsearch starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startElasticsearch(dockerStatusBuildItem, configuration, buildItemsConfig, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownElasticsearch();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.infof("Dev Services for Elasticsearch started. Other Quarkus applications in dev mode will find the server automatically. For Quarkus applications in production mode, you can connect to this by configuring your application to use %s", (Object)DevServicesElasticsearchProcessor.getElasticsearchHosts(buildItemsConfig));
        }
        return devService.toBuildItem();
    }

    public static String getElasticsearchHosts(DevservicesElasticsearchBuildItemsConfiguration buildItemsConfiguration) {
        String hostsConfigProperty = (String)buildItemsConfiguration.hostsConfigProperties.stream().findAny().get();
        return (String)devService.getConfig().get(hostsConfigProperty);
    }

    private void shutdownElasticsearch() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Elasticsearch server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startElasticsearch(DockerStatusBuildItem dockerStatusBuildItem, ElasticsearchDevServicesBuildTimeConfig config, DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) throws BuildException {
        String containerTag;
        if (!config.enabled.orElse(true).booleanValue()) {
            log.debug((Object)"Not starting Dev Services for Elasticsearch, as it has been disabled in the config.");
            return null;
        }
        for (String hostsConfigProperty : buildItemConfig.hostsConfigProperties) {
            if (!ConfigUtils.isPropertyPresent((String)hostsConfigProperty)) continue;
            log.debugf("Not starting Dev Services for Elasticsearch, the %s property is configured.", (Object)hostsConfigProperty);
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warnf("Docker isn't working, please configure the Elasticsearch hosts property (%s).", (Object)this.displayProperties(buildItemConfig.hostsConfigProperties));
            return null;
        }
        if (buildItemConfig.distribution == DevservicesElasticsearchBuildItem.Distribution.OPENSEARCH) {
            throw new BuildException("Dev Services for Elasticsearch doesn't support OpenSearch", Collections.emptyList());
        }
        if (buildItemConfig.version != null && !(containerTag = config.imageName.substring(config.imageName.indexOf(58) + 1)).startsWith(buildItemConfig.version)) {
            throw new BuildException("Dev Services for Elasticsearch detected a version mismatch, container image is " + config.imageName + " but the configured version is " + buildItemConfig.version + ". Either configure a different image or disable Dev Services for Elasticsearch.", Collections.emptyList());
        }
        Optional maybeContainerAddress = elasticsearchContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultElasticsearchSupplier = () -> {
            ElasticsearchContainer container = new ElasticsearchContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch"));
            ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)"elasticsearch");
            if (config.serviceName != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
            }
            if (config.port.isPresent()) {
                container.setPortBindings(List.of(config.port.get() + ":" + config.port.get()));
            }
            timeout.ifPresent(arg_0 -> ((ElasticsearchContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.addEnv("ES_JAVA_OPTS", config.javaOpts);
            container.addEnv("xpack.security.enabled", "false");
            container.start();
            return new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), container.getContainerId(), () -> ((ElasticsearchContainer)container).close(), this.buildPropertiesMap(buildItemConfig, container.getHttpHostAddress()));
        };
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), containerAddress.getId(), null, this.buildPropertiesMap(buildItemConfig, containerAddress.getUrl()))).orElseGet(defaultElasticsearchSupplier);
    }

    private Map<String, String> buildPropertiesMap(DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, String httpHosts) {
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        for (String property : buildItemConfig.hostsConfigProperties) {
            propertiesToSet.put(property, httpHosts);
        }
        return propertiesToSet;
    }

    private String displayProperties(Set<String> hostsConfigProperties) {
        return String.join((CharSequence)" and ", hostsConfigProperties);
    }

    static {
        first = true;
    }

    private static class DevservicesElasticsearchBuildItemsConfiguration {
        private Set<String> hostsConfigProperties;
        private String version;
        private DevservicesElasticsearchBuildItem.Distribution distribution;

        private DevservicesElasticsearchBuildItemsConfiguration(List<DevservicesElasticsearchBuildItem> buildItems) throws BuildException {
            this.hostsConfigProperties = new HashSet<String>(buildItems.size());
            for (DevservicesElasticsearchBuildItem buildItem : buildItems) {
                if (this.version == null) {
                    this.version = buildItem.getVersion();
                } else if (!this.version.equals(buildItem.getVersion())) {
                    throw new BuildException("Multiple extensions request different versions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                if (this.distribution == null) {
                    this.distribution = buildItem.getDistribution();
                } else if (!this.distribution.equals((Object)buildItem.getDistribution())) {
                    throw new BuildException("Multiple extensions request different distributions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                this.hostsConfigProperties.add(buildItem.getHostsConfigProperty());
            }
        }
    }
}

