/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.lowlevel.runtime;

import io.quarkus.elasticsearch.restclient.lowlevel.runtime.ElasticsearchConfig;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.jboss.logging.Logger;

public final class RestClientBuilderHelper {
    private static final Logger LOG = Logger.getLogger(RestClientBuilderHelper.class);

    private RestClientBuilderHelper() {
    }

    static RestClientBuilder createRestClientBuilder(final ElasticsearchConfig config) {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(config.hosts.size());
        for (InetSocketAddress host : config.hosts) {
            hosts.add(new HttpHost(host.getHostString(), host.getPort(), config.protocol));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout((int)config.connectionTimeout.toMillis()).setSocketTimeout((int)config.socketTimeout.toMillis()).setConnectionRequestTimeout(0);
            }
        });
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                if (config.username.isPresent()) {
                    if (!"https".equalsIgnoreCase(config.protocol)) {
                        LOG.warn((Object)"Using Basic authentication in HTTP implies sending plain text passwords over the wire, use the HTTPS protocol instead.");
                    }
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.username.get(), (String)config.password.orElse(null)));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                if (config.ioThreadCounts.isPresent()) {
                    IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.ioThreadCounts.get().intValue()).build();
                    httpClientBuilder.setDefaultIOReactorConfig(ioReactorConfig);
                }
                httpClientBuilder.setMaxConnTotal(config.maxConnections);
                httpClientBuilder.setMaxConnPerRoute(config.maxConnectionsPerRoute);
                if ("http".equalsIgnoreCase(config.protocol)) {
                    httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
                }
                return httpClientBuilder;
            }
        });
        return builder;
    }

    static Sniffer createSniffer(RestClient client, ElasticsearchConfig config) {
        SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis((int)config.discovery.refreshInterval.toMillis());
        if ("https".equalsIgnoreCase(config.protocol)) {
            ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchNodesSniffer.Scheme.HTTPS);
            builder.setNodesSniffer((NodesSniffer)hostsSniffer);
        }
        return builder.build();
    }
}

