/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.lowlevel.runtime;

import io.quarkus.elasticsearch.restclient.lowlevel.runtime.ElasticsearchConfig;
import io.quarkus.elasticsearch.restclient.lowlevel.runtime.RestClientBuilderHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;

@ApplicationScoped
public class ElasticsearchRestClientProducer {
    @Inject
    ElasticsearchConfig config;
    private RestClient client;
    private Sniffer sniffer;

    @Produces
    @Singleton
    public RestClient restClient() {
        RestClientBuilder builder = RestClientBuilderHelper.createRestClientBuilder(this.config);
        this.client = builder.build();
        if (this.config.discovery.enabled) {
            this.sniffer = RestClientBuilderHelper.createSniffer(this.client, this.config);
        }
        return this.client;
    }

    @PreDestroy
    void destroy() {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

