/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.lowlevel.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.elasticsearch.restclient.lowlevel.ElasticsearchClientConfig;
import io.quarkus.elasticsearch.restclient.lowlevel.runtime.ElasticsearchConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.jboss.logging.Logger;

public final class RestClientBuilderHelper {
    private static final Logger LOG = Logger.getLogger(RestClientBuilderHelper.class);

    private RestClientBuilderHelper() {
    }

    public static RestClientBuilder createRestClientBuilder(final ElasticsearchConfig config) {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(config.hosts().size());
        for (InetSocketAddress host : config.hosts()) {
            hosts.add(new HttpHost(host.getHostString(), host.getPort(), config.protocol()));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout((int)config.connectionTimeout().toMillis()).setSocketTimeout((int)config.socketTimeout().toMillis()).setConnectionRequestTimeout(0);
            }
        });
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                RestClientBuilderHelper.applyAuthentication(httpClientBuilder, config);
                if (config.ioThreadCounts().isPresent()) {
                    IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.ioThreadCounts().get().intValue()).build();
                    httpClientBuilder.setDefaultIOReactorConfig(ioReactorConfig);
                }
                httpClientBuilder.setMaxConnTotal(config.maxConnections());
                httpClientBuilder.setMaxConnPerRoute(config.maxConnectionsPerRoute());
                if ("http".equalsIgnoreCase(config.protocol())) {
                    httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
                }
                HttpAsyncClientBuilder result = httpClientBuilder;
                Iterable handles = Arc.container().select(RestClientBuilder.HttpClientConfigCallback.class, new Annotation[]{new ElasticsearchClientConfig.Literal()}).handles();
                for (InstanceHandle handle : handles) {
                    result = ((RestClientBuilder.HttpClientConfigCallback)handle.get()).customizeHttpClient(result);
                    handle.close();
                }
                return result;
            }
        });
        return builder;
    }

    public static Sniffer createSniffer(RestClient client, ElasticsearchConfig config) {
        SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis((int)config.discovery().refreshInterval().toMillis());
        if ("https".equalsIgnoreCase(config.protocol())) {
            ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchNodesSniffer.Scheme.HTTPS);
            builder.setNodesSniffer((NodesSniffer)hostsSniffer);
        }
        return builder.build();
    }

    private static void applyAuthentication(HttpAsyncClientBuilder httpClientBuilder, ElasticsearchConfig config) {
        boolean hasBasic = config.username().isPresent();
        boolean hasApiKey = config.apiKey().isPresent();
        if (hasBasic && hasApiKey) {
            throw new ConfigurationException("You must provide either a valid username/password pair for Basic authentication OR only a valid API key for ApiKey authentication. Both methods are currently enabled.");
        }
        if (!"https".equalsIgnoreCase(config.protocol()) && (hasBasic || hasApiKey)) {
            LOG.warn((Object)"Transmitting authentication information over HTTP is unsafe as it implies sending sensitive information as plain text over an unencrypted channel. Use the HTTPS protocol instead.");
        }
        if (hasBasic) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.username().get(), (String)config.password().orElse(null)));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        } else if (hasApiKey) {
            String apiKey = config.apiKey().get();
            BasicHeader apiKeyHeader = new BasicHeader("Authorization", "ApiKey " + apiKey);
            httpClientBuilder.setDefaultHeaders(Collections.singleton(apiKeyHeader));
        }
    }
}

