/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.jdbc.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.elytron.security.deployment.ElytronPasswordMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.jdbc.JdbcRecorder;
import io.quarkus.elytron.security.jdbc.JdbcSecurityRealmBuildTimeConfig;
import io.quarkus.elytron.security.jdbc.JdbcSecurityRealmRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import java.util.List;

class ElytronSecurityJdbcProcessor {
    ElytronSecurityJdbcProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.SECURITY_ELYTRON_JDBC);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_JDBC);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureJdbcRealmAuthConfig(JdbcRecorder recorder, JdbcSecurityRealmBuildTimeConfig jdbcSecurityRealmBuildTimeConfig, JdbcSecurityRealmRuntimeConfig jdbcSecurityRealmRuntimeConfig, BuildProducer<SecurityRealmBuildItem> securityRealm, BeanContainerBuildItem beanContainerBuildItem, List<JdbcDataSourceBuildItem> dataSourcesConfigured) throws Exception {
        if (!jdbcSecurityRealmBuildTimeConfig.enabled) {
            return;
        }
        RuntimeValue realm = recorder.createRealm(jdbcSecurityRealmRuntimeConfig);
        securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, jdbcSecurityRealmBuildTimeConfig.realmName, null));
    }

    @BuildStep
    ElytronPasswordMarkerBuildItem marker(JdbcSecurityRealmBuildTimeConfig jdbcSecurityRealmBuildTimeConfig) {
        if (!jdbcSecurityRealmBuildTimeConfig.enabled) {
            return null;
        }
        return new ElytronPasswordMarkerBuildItem();
    }
}

