/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.ldap;

import io.quarkus.elytron.security.ldap.QuarkusDirContextFactory;
import io.quarkus.elytron.security.ldap.config.AttributeMappingConfig;
import io.quarkus.elytron.security.ldap.config.DirContextConfig;
import io.quarkus.elytron.security.ldap.config.IdentityMappingConfig;
import io.quarkus.elytron.security.ldap.config.LdapSecurityRealmRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.CachingSecurityRealm;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;

@Recorder
public class LdapRecorder {
    private static final Logger log = LoggerFactory.getLogger(LdapRecorder.class);

    public RuntimeValue<SecurityRealm> createRealm(LdapSecurityRealmRuntimeConfig runtimeConfig) {
        LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapRecorder.createDirContextSupplier(runtimeConfig.dirContext())).identityMapping();
        if (runtimeConfig.identityMapping().searchRecursive()) {
            identityMappingBuilder.searchRecursive();
        }
        LdapSecurityRealmBuilder ldapSecurityRealmBuilder = identityMappingBuilder.map(LdapRecorder.createAttributeMappings(runtimeConfig.identityMapping())).setRdnIdentifier(runtimeConfig.identityMapping().rdnIdentifier()).setSearchDn(runtimeConfig.identityMapping().searchBaseDn()).build();
        if (runtimeConfig.directVerification()) {
            ldapSecurityRealmBuilder.addDirectEvidenceVerification(false);
        }
        ModifiableSecurityRealm ldapRealm = ldapSecurityRealmBuilder.build();
        if (runtimeConfig.cache().enabled()) {
            if (ldapRealm instanceof CacheableSecurityRealm) {
                ldapRealm = new CachingSecurityRealm((SecurityRealm)ldapRealm, (RealmIdentityCache)new LRURealmIdentityCache(runtimeConfig.cache().size(), runtimeConfig.cache().maxAge().toMillis()));
            } else {
                log.warn("Created LDAP realm is not cacheable. Caching of the 'SecurityRealm' won't be available. Please, report this issue.");
            }
        }
        return new RuntimeValue((Object)ldapRealm);
    }

    private static ExceptionSupplier<DirContext, NamingException> createDirContextSupplier(DirContextConfig dirContext) {
        QuarkusDirContextFactory dirContextFactory = new QuarkusDirContextFactory(dirContext.url(), dirContext.principal().orElse(null), dirContext.password().orElse(null), dirContext.connectTimeout(), dirContext.readTimeout());
        return () -> dirContextFactory.obtainDirContext(dirContext.referralMode());
    }

    private static AttributeMapping[] createAttributeMappings(IdentityMappingConfig identityMappingConfig) {
        ArrayList<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
        for (AttributeMappingConfig attributeMappingConfig : identityMappingConfig.attributeMappings().values()) {
            attributeMappings.add(AttributeMapping.fromFilter((String)attributeMappingConfig.filter()).from(attributeMappingConfig.from()).to(attributeMappingConfig.to()).searchDn(attributeMappingConfig.filterBaseDn()).build());
        }
        AttributeMapping[] attributeMappingsArray = new AttributeMapping[attributeMappings.size()];
        return attributeMappings.toArray(attributeMappingsArray);
    }
}

