/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.oauth2.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.elytron.security.deployment.ElytronTokenMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.oauth2.runtime.OAuth2BuildTimeConfig;
import io.quarkus.elytron.security.oauth2.runtime.OAuth2Recorder;
import io.quarkus.elytron.security.oauth2.runtime.OAuth2RuntimeConfig;
import io.quarkus.elytron.security.oauth2.runtime.auth.OAuth2AuthMechanism;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import jakarta.enterprise.context.ApplicationScoped;

class OAuth2DeploymentProcessor {
    private static final String REALM_NAME = "OAuth2";

    OAuth2DeploymentProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_OAUTH2);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.SECURITY_OAUTH2);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    AdditionalBeanBuildItem configureOauth2RealmAuthConfig(OAuth2Recorder recorder, OAuth2BuildTimeConfig oauth2BuildTimeConfig, OAuth2RuntimeConfig oauth2RuntimeConfig, BuildProducer<SecurityRealmBuildItem> securityRealm) throws Exception {
        if (!oauth2BuildTimeConfig.enabled()) {
            return null;
        }
        RuntimeValue realm = recorder.createRealm(oauth2RuntimeConfig);
        securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, REALM_NAME, null));
        return AdditionalBeanBuildItem.unremovableOf(OAuth2AuthMechanism.class);
    }

    @BuildStep
    ElytronTokenMarkerBuildItem marker(OAuth2BuildTimeConfig oauth2BuildTimeConfig) {
        if (!oauth2BuildTimeConfig.enabled()) {
            return null;
        }
        return new ElytronTokenMarkerBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem augmentor(OAuth2Recorder recorder, OAuth2BuildTimeConfig oauth2BuildTimeConfig) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SecurityIdentityAugmentor.class).scope(ApplicationScoped.class)).runtimeValue(recorder.augmentor(oauth2BuildTimeConfig)).unremovable()).done();
    }
}

