/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.properties.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.elytron.security.deployment.ElytronPasswordMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.runtime.ElytronPropertiesFileRecorder;
import io.quarkus.elytron.security.runtime.MPRealmConfig;
import io.quarkus.elytron.security.runtime.PropertiesRealmConfig;
import io.quarkus.elytron.security.runtime.SecurityUsersConfig;
import io.quarkus.runtime.RuntimeValue;
import java.util.Set;
import org.jboss.logging.Logger;

class ElytronPropertiesProcessor {
    private static final Logger log = Logger.getLogger((String)ElytronPropertiesProcessor.class.getName());
    private static final String USERS_PREFIX = "quarkus.security.embedded.users";
    private static final String ROLES_PREFIX = "quarkus.security.embedded.roles";
    SecurityUsersConfig propertiesConfig;

    ElytronPropertiesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("security-properties-file");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureFileRealmAuthConfig(ElytronPropertiesFileRecorder recorder, BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<SecurityRealmBuildItem> securityRealm) throws Exception {
        if (this.propertiesConfig.file.enabled) {
            PropertiesRealmConfig realmConfig = this.propertiesConfig.file;
            log.debugf("Configuring from PropertiesRealmConfig, users=%s, roles=%s", (Object)realmConfig.users, (Object)realmConfig.roles);
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{realmConfig.users, realmConfig.roles}));
            RuntimeValue realm = recorder.createRealm(realmConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, realmConfig.realmName, recorder.loadRealm(realm, realmConfig)));
        }
    }

    @BuildStep
    ElytronPasswordMarkerBuildItem marker() {
        if (this.propertiesConfig.file.enabled || this.propertiesConfig.embedded.enabled) {
            return new ElytronPasswordMarkerBuildItem();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureMPRealmConfig(ElytronPropertiesFileRecorder recorder, BuildProducer<SecurityRealmBuildItem> securityRealm) throws Exception {
        if (this.propertiesConfig.embedded.enabled) {
            MPRealmConfig realmConfig = this.propertiesConfig.embedded;
            log.info((Object)"Configuring from MPRealmConfig");
            log.debugf("MPRealmConfig.users: %s", (Object)realmConfig.users);
            log.debugf("MPRealmConfig.roles: %s", (Object)realmConfig.roles);
            Set userKeys = QuarkusConfig.getNames((String)USERS_PREFIX);
            log.debugf("userKeys: %s", (Object)userKeys);
            for (Object key : userKeys) {
                String pass = QuarkusConfig.getString((String)("quarkus.security.embedded.users." + (String)key), null, (boolean)false);
                log.debugf("%s.pass = %s", key, (Object)pass);
                realmConfig.users.put(key, pass);
            }
            Set roleKeys = QuarkusConfig.getNames((String)ROLES_PREFIX);
            log.debugf("roleKeys: %s", (Object)roleKeys);
            for (String key : roleKeys) {
                String roles = QuarkusConfig.getString((String)("quarkus.security.embedded.roles." + key), null, (boolean)false);
                log.debugf("%s.roles = %s", (Object)key, (Object)roles);
                realmConfig.roles.put(key, roles);
            }
            RuntimeValue realm = recorder.createRealm(realmConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, realmConfig.realmName, recorder.loadRealm(realm, realmConfig)));
        }
    }
}

