/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.properties.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.elytron.security.deployment.ElytronPasswordMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.properties.runtime.ElytronPropertiesFileRecorder;
import io.quarkus.elytron.security.properties.runtime.MPRealmRuntimeConfig;
import io.quarkus.elytron.security.properties.runtime.PropertiesRealmConfig;
import io.quarkus.elytron.security.properties.runtime.SecurityUsersConfig;
import io.quarkus.runtime.RuntimeValue;
import org.jboss.logging.Logger;

class ElytronPropertiesProcessor {
    private static final Logger log = Logger.getLogger((String)ElytronPropertiesProcessor.class.getName());
    SecurityUsersConfig propertiesConfig;

    ElytronPropertiesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_PROPERTIES_FILE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureFileRealmAuthConfig(ElytronPropertiesFileRecorder recorder, BuildProducer<SecurityRealmBuildItem> securityRealm) throws Exception {
        if (this.propertiesConfig.file().enabled()) {
            PropertiesRealmConfig realmConfig = this.propertiesConfig.file();
            log.debugf("Configuring from PropertiesRealmConfig, users=%s, roles=%s", (Object)realmConfig.users(), (Object)realmConfig.roles());
            RuntimeValue realm = recorder.createRealm(this.propertiesConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, realmConfig.realmName(), recorder.loadRealm(realm, this.propertiesConfig)));
        }
    }

    @BuildStep
    void nativeResource(BuildProducer<NativeImageResourceBuildItem> resources) throws Exception {
        if (this.propertiesConfig.file().enabled()) {
            PropertiesRealmConfig realmConfig = this.propertiesConfig.file();
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{realmConfig.users(), realmConfig.roles()}));
        }
    }

    @BuildStep
    ElytronPasswordMarkerBuildItem marker() {
        if (this.propertiesConfig.file().enabled() || this.propertiesConfig.embedded().enabled()) {
            return new ElytronPasswordMarkerBuildItem();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureMPRealmConfig(ElytronPropertiesFileRecorder recorder, BuildProducer<SecurityRealmBuildItem> securityRealm, MPRealmRuntimeConfig runtimeConfig) throws Exception {
        if (this.propertiesConfig.embedded().enabled()) {
            log.info((Object)"Configuring from MPRealmConfig");
            RuntimeValue realm = recorder.createEmbeddedRealm(this.propertiesConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, this.propertiesConfig.embedded().realmName(), recorder.loadEmbeddedRealm(realm, this.propertiesConfig, runtimeConfig)));
        }
    }
}

