/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.elytron.security.runtime.MPRealmConfig;
import io.quarkus.elytron.security.runtime.PropertiesRealmConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.DigestPasswordSpec;

@Recorder
public class ElytronPropertiesFileRecorder {
    static final Logger log = Logger.getLogger(ElytronPropertiesFileRecorder.class);

    public Runnable loadRealm(final RuntimeValue<SecurityRealm> realm, final PropertiesRealmConfig config) throws Exception {
        return new Runnable(){

            @Override
            public void run() {
                log.debugf("loadRealm, config=%s", (Object)config);
                SecurityRealm secRealm = (SecurityRealm)realm.getValue();
                if (!(secRealm instanceof LegacyPropertiesSecurityRealm)) {
                    return;
                }
                log.debugf("Trying to loader users: /%s", (Object)config.users);
                URL users = Thread.currentThread().getContextClassLoader().getResource(config.users);
                log.debugf("users: %s", (Object)users);
                log.debugf("Trying to loader roles: %s", (Object)config.roles);
                URL roles = Thread.currentThread().getContextClassLoader().getResource(config.roles);
                log.debugf("roles: %s", (Object)roles);
                if (users == null && roles == null) {
                    String msg = String.format("No PropertiesRealmConfig users/roles settings found. Configure the quarkus.security.file.%s properties", config.help());
                    throw new IllegalStateException(msg);
                }
                LegacyPropertiesSecurityRealm propsRealm = (LegacyPropertiesSecurityRealm)secRealm;
                try {
                    propsRealm.load(users.openStream(), roles.openStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Runnable loadRealm(final RuntimeValue<SecurityRealm> realm, final MPRealmConfig config) throws Exception {
        return new Runnable(){

            @Override
            public void run() {
                log.debugf("loadRealm, config=%s", (Object)config);
                SecurityRealm secRealm = (SecurityRealm)realm.getValue();
                if (!(secRealm instanceof SimpleMapBackedSecurityRealm)) {
                    return;
                }
                SimpleMapBackedSecurityRealm memRealm = (SimpleMapBackedSecurityRealm)secRealm;
                HashMap<String, SimpleRealmEntry> identityMap = new HashMap<String, SimpleRealmEntry>();
                Map<String, String> userInfo = config.getUsers();
                log.debugf("UserInfoMap: %s%n", userInfo);
                Map<String, String> roleInfo = config.getRoles();
                log.debugf("RoleInfoMap: %s%n", roleInfo);
                for (Map.Entry<String, String> userPasswordEntry : userInfo.entrySet()) {
                    ClearPassword password;
                    String user = userPasswordEntry.getKey();
                    if (config.plainText) {
                        password = ClearPassword.createRaw((String)"clear", (char[])userPasswordEntry.getValue().toCharArray());
                    } else {
                        try {
                            byte[] hashed = ByteIterator.ofBytes((byte[])userPasswordEntry.getValue().getBytes(StandardCharsets.UTF_8)).asUtf8String().hexDecode().drain();
                            password = PasswordFactory.getInstance((String)"digest-md5", (Provider)new WildFlyElytronPasswordProvider()).generatePassword((KeySpec)new DigestPasswordSpec(user, config.realmName, hashed));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to register password for user:" + user + " make sure it is a valid hex encoded MD5 hash", e);
                        }
                    }
                    PasswordCredential passwordCred = new PasswordCredential((Password)password);
                    ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
                    credentials.add(passwordCred);
                    String rawRoles = roleInfo.get(user);
                    String[] roles = rawRoles.split(",");
                    MapAttributes attributes = new MapAttributes();
                    for (String role : roles) {
                        attributes.addLast("groups", role);
                    }
                    SimpleRealmEntry entry = new SimpleRealmEntry(credentials, (Attributes)attributes);
                    identityMap.put(user, entry);
                    log.debugf("Added user(%s), roles=%s%n", (Object)user, (Object)attributes.get("groups"));
                }
                memRealm.setIdentityMap(identityMap);
            }
        };
    }

    public RuntimeValue<SecurityRealm> createRealm(PropertiesRealmConfig config) throws Exception {
        log.debugf("createRealm, config=%s", (Object)config);
        LegacyPropertiesSecurityRealm realm = LegacyPropertiesSecurityRealm.builder().setDefaultRealm(config.realmName).setProviders((Supplier)new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return new Provider[]{new WildFlyElytronProvider()};
            }
        }).setPlainText(config.plainText).build();
        return new RuntimeValue((Object)realm);
    }

    public RuntimeValue<SecurityRealm> createRealm(MPRealmConfig config) {
        log.debugf("createRealm, config=%s", (Object)config);
        Supplier<Provider[]> providers = new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return new Provider[]{new WildFlyElytronProvider()};
            }
        };
        SimpleMapBackedSecurityRealm realm = new SimpleMapBackedSecurityRealm(NameRewriter.IDENTITY_REWRITER, (Supplier)providers);
        return new RuntimeValue((Object)realm);
    }
}

