/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.elytron.security.runtime.AuthConfig;
import io.quarkus.elytron.security.runtime.ElytronIdentityManager;
import io.quarkus.elytron.security.runtime.MPRealmConfig;
import io.quarkus.elytron.security.runtime.PropertiesRealmConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Template;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import java.net.URL;
import java.security.Permission;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.permission.PermissionVerifier;

@Template
public class SecurityTemplate {
    static final Logger log = Logger.getLogger(SecurityTemplate.class);

    public void loadRealm(RuntimeValue<SecurityRealm> realm, PropertiesRealmConfig config) throws Exception {
        log.debugf("loadRealm, config=%s", (Object)config);
        SecurityRealm secRealm = (SecurityRealm)realm.getValue();
        if (!(secRealm instanceof LegacyPropertiesSecurityRealm)) {
            return;
        }
        log.debugf("Trying to loader users: /%s", (Object)config.users);
        URL users = Thread.currentThread().getContextClassLoader().getResource(config.users);
        log.debugf("users: %s", (Object)users);
        log.debugf("Trying to loader roles: %s", (Object)config.roles);
        URL roles = Thread.currentThread().getContextClassLoader().getResource(config.roles);
        log.debugf("roles: %s", (Object)roles);
        if (users == null && roles == null) {
            String msg = String.format("No PropertiesRealmConfig users/roles settings found. Configure the quarkus.security.file.%s properties", config.help());
            throw new IllegalStateException(msg);
        }
        LegacyPropertiesSecurityRealm propsRealm = (LegacyPropertiesSecurityRealm)secRealm;
        propsRealm.load(users.openStream(), roles.openStream());
    }

    public void loadRealm(RuntimeValue<SecurityRealm> realm, MPRealmConfig config) throws Exception {
        log.debugf("loadRealm, config=%s", (Object)config);
        SecurityRealm secRealm = (SecurityRealm)realm.getValue();
        if (!(secRealm instanceof SimpleMapBackedSecurityRealm)) {
            return;
        }
        SimpleMapBackedSecurityRealm memRealm = (SimpleMapBackedSecurityRealm)secRealm;
        HashMap<String, SimpleRealmEntry> identityMap = new HashMap<String, SimpleRealmEntry>();
        Map<String, String> userInfo = config.getUsers();
        log.debugf("UserInfoMap: %s\n", userInfo);
        Map<String, String> roleInfo = config.getRoles();
        log.debugf("RoleInfoMap: %s\n", roleInfo);
        for (String user : userInfo.keySet()) {
            String password = userInfo.get(user);
            ClearPassword clear = ClearPassword.createRaw((String)"clear", (char[])password.toCharArray());
            PasswordCredential passwordCred = new PasswordCredential((Password)clear);
            ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
            credentials.add(passwordCred);
            String rawRoles = roleInfo.get(user);
            String[] roles = rawRoles.split(",");
            MapAttributes attributes = new MapAttributes();
            for (String role : roles) {
                attributes.addLast("groups", role);
            }
            SimpleRealmEntry entry = new SimpleRealmEntry(credentials, (Attributes)attributes);
            identityMap.put(user, entry);
            log.debugf("Added user(%s), roles=%s\n", (Object)user, (Object)attributes.get("groups"));
        }
        memRealm.setIdentityMap(identityMap);
    }

    public RuntimeValue<SecurityRealm> createRealm(PropertiesRealmConfig config) throws Exception {
        log.debugf("createRealm, config=%s", (Object)config);
        LegacyPropertiesSecurityRealm realm = LegacyPropertiesSecurityRealm.builder().setDefaultRealm("default").setProviders((Supplier)new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return new Provider[]{new WildFlyElytronProvider()};
            }
        }).setPlainText(true).build();
        return new RuntimeValue((Object)realm);
    }

    public RuntimeValue<SecurityRealm> createRealm(MPRealmConfig config) {
        log.debugf("createRealm, config=%s", (Object)config);
        Supplier<Provider[]> providers = new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return new Provider[]{new WildFlyElytronProvider()};
            }
        };
        SimpleMapBackedSecurityRealm realm = new SimpleMapBackedSecurityRealm(NameRewriter.IDENTITY_REWRITER, (Supplier)providers);
        return new RuntimeValue((Object)realm);
    }

    public RuntimeValue<SecurityDomain.Builder> configureDomainBuilder(String realmName, RuntimeValue<SecurityRealm> realm) throws Exception {
        log.debugf("buildDomain, realm=%s", realm.getValue());
        SecurityDomain.Builder domain = SecurityDomain.builder().addRealm(realmName, (SecurityRealm)realm.getValue()).setRoleDecoder(new RoleDecoder(){

            public Roles decodeRoles(AuthorizationIdentity authorizationIdentity) {
                Attributes.Entry groups = authorizationIdentity.getAttributes().get("groups");
                final HashSet roles = new HashSet(groups);
                return new Roles(){

                    public boolean contains(String roleName) {
                        return roles.contains(roleName);
                    }

                    public Iterator<String> iterator() {
                        return roles.iterator();
                    }
                };
            }
        }).build().setDefaultRealmName(realmName).setPermissionMapper(new PermissionMapper(){

            public PermissionVerifier mapPermissions(PermissionMappable permissionMappable, Roles roles) {
                return new PermissionVerifier(){

                    public boolean implies(Permission permission) {
                        return true;
                    }
                };
            }
        });
        return new RuntimeValue((Object)domain);
    }

    public void addRealm(RuntimeValue<SecurityDomain.Builder> builder, String realmName, RuntimeValue<SecurityRealm> realm) {
        ((SecurityDomain.Builder)builder.getValue()).addRealm(realmName, (SecurityRealm)realm.getValue());
    }

    public RuntimeValue<SecurityDomain> buildDomain(RuntimeValue<SecurityDomain.Builder> builder) {
        return new RuntimeValue((Object)((SecurityDomain.Builder)builder.getValue()).build());
    }

    public IdentityManager createIdentityManager(RuntimeValue<SecurityDomain> domain) {
        return new ElytronIdentityManager((SecurityDomain)domain.getValue());
    }

    public ServletExtension configureUndertowIdentityManager(RuntimeValue<SecurityDomain> domain, final IdentityManager identityManager, final List<AuthConfig> authConfigs) {
        return new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                if (authConfigs.size() > 0) {
                    AuthConfig first = (AuthConfig)authConfigs.get(0);
                    log.debugf("configureUndertowIdentityManager, %s", (Object)authConfigs);
                    LoginConfig loginConfig = new LoginConfig(first.authMechanism, first.realmName);
                    for (int n = 1; n < authConfigs.size(); ++n) {
                        AuthConfig ac = (AuthConfig)authConfigs.get(n);
                        loginConfig.addLastAuthMethod(ac.getAuthMechanism());
                    }
                    deploymentInfo.setLoginConfig(loginConfig);
                }
                deploymentInfo.setIdentityManager(identityManager);
            }
        };
    }
}

