/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.deployment;

import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.elytron.security.deployment.AuthConfigBuildItem;
import io.quarkus.elytron.security.deployment.IdentityManagerBuildItem;
import io.quarkus.elytron.security.deployment.PasswordRealmBuildItem;
import io.quarkus.elytron.security.deployment.SecurityDomainBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.runtime.AuthConfig;
import io.quarkus.elytron.security.runtime.MPRealmConfig;
import io.quarkus.elytron.security.runtime.PropertiesRealmConfig;
import io.quarkus.elytron.security.runtime.SecurityConfig;
import io.quarkus.elytron.security.runtime.SecurityTemplate;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.undertow.deployment.ServletExtensionBuildItem;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.ServletExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.builder.item.BuildItem;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

class SecurityDeploymentProcessor {
    private static final Logger log = Logger.getLogger((String)SecurityDeploymentProcessor.class.getName());
    private static final String USERS_PREFIX = "quarkus.security.embedded.users";
    private static final String ROLES_PREFIX = "quarkus.security.embedded.roles";
    SecurityConfig security;

    SecurityDeploymentProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("security");
    }

    @BuildStep
    void services(BuildProducer<ReflectiveClassBuildItem> classes) {
        classes.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.wildfly.security.password.impl.PasswordFactorySpiImpl"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    AuthConfigBuildItem configureFileRealmAuthConfig(SecurityTemplate template, BuildProducer<SubstrateResourceBuildItem> resources, BuildProducer<SecurityRealmBuildItem> securityRealm, BuildProducer<PasswordRealmBuildItem> passwordRealm) throws Exception {
        if (this.security.file.enabled) {
            PropertiesRealmConfig realmConfig = this.security.file;
            log.debugf("Configuring from PropertiesRealmConfig, users=%s, roles=%s", (Object)realmConfig.getUsers(), (Object)realmConfig.getRoles());
            resources.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{realmConfig.users, realmConfig.roles}));
            RuntimeValue realm = template.createRealm(realmConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem((RuntimeValue<SecurityRealm>)realm, realmConfig.getAuthConfig()));
            passwordRealm.produce((BuildItem)new PasswordRealmBuildItem());
            return new AuthConfigBuildItem(realmConfig.getAuthConfig());
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    AuthConfigBuildItem configureMPRealmConfig(SecurityTemplate template, BuildProducer<SecurityRealmBuildItem> securityRealm, BuildProducer<PasswordRealmBuildItem> passwordRealm) throws Exception {
        if (this.security.embedded.enabled) {
            MPRealmConfig realmConfig = this.security.embedded;
            log.info((Object)"Configuring from MPRealmConfig");
            log.debugf("MPRealmConfig.users: %s", (Object)realmConfig.users);
            log.debugf("MPRealmConfig.roles: %s", (Object)realmConfig.roles);
            Set userKeys = QuarkusConfig.getNames((String)USERS_PREFIX);
            log.debugf("userKeys: %s", (Object)userKeys);
            for (Object key : userKeys) {
                String pass = QuarkusConfig.getString((String)("quarkus.security.embedded.users." + (String)key), null, (boolean)false);
                log.debugf("%s.pass = %s", key, (Object)pass);
                realmConfig.users.put(key, pass);
            }
            Set roleKeys = QuarkusConfig.getNames((String)ROLES_PREFIX);
            log.debugf("roleKeys: %s", (Object)roleKeys);
            for (String key : roleKeys) {
                String roles = QuarkusConfig.getString((String)("quarkus.security.embedded.roles." + key), null, (boolean)false);
                log.debugf("%s.roles = %s", (Object)key, (Object)roles);
                realmConfig.roles.put(key, roles);
            }
            RuntimeValue realm = template.createRealm(realmConfig);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem((RuntimeValue<SecurityRealm>)realm, realmConfig.getAuthConfig()));
            passwordRealm.produce((BuildItem)new PasswordRealmBuildItem());
            return new AuthConfigBuildItem(realmConfig.getAuthConfig());
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SecurityDomainBuildItem build(SecurityTemplate template, BuildProducer<ServletExtensionBuildItem> extension, List<SecurityRealmBuildItem> realms) throws Exception {
        log.debugf("build, hasFile=%s, hasMP=%s", (Object)this.security.file.enabled, (Object)this.security.embedded.enabled);
        if (realms.size() > 0) {
            SecurityRealmBuildItem realmBuildItem = realms.get(0);
            AuthConfig authConfig = realmBuildItem.getAuthConfig();
            RuntimeValue securityDomainBuilder = template.configureDomainBuilder(authConfig.getRealmName(), realmBuildItem.getRealm());
            for (int n = 1; n < realms.size(); ++n) {
                realmBuildItem = realms.get(n);
                RuntimeValue<SecurityRealm> realm = realmBuildItem.getRealm();
                authConfig = realmBuildItem.getAuthConfig();
                template.addRealm(securityDomainBuilder, authConfig.getRealmName(), realm);
            }
            RuntimeValue securityDomain = template.buildDomain(securityDomainBuilder);
            return new SecurityDomainBuildItem((RuntimeValue<SecurityDomain>)securityDomain);
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureIdentityManager(SecurityTemplate template, SecurityDomainBuildItem securityDomain, BuildProducer<IdentityManagerBuildItem> identityManagerProducer, List<PasswordRealmBuildItem> passwordRealm) {
        if (passwordRealm.size() > 0) {
            IdentityManager identityManager = template.createIdentityManager(securityDomain.getSecurityDomain());
            identityManagerProducer.produce((BuildItem)new IdentityManagerBuildItem(identityManager));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void addIdentityManager(SecurityTemplate template, BuildProducer<ServletExtensionBuildItem> extension, SecurityDomainBuildItem securityDomain, List<IdentityManagerBuildItem> identityManagers, List<AuthConfigBuildItem> authConfigs) {
        if (identityManagers.size() == 0) {
            return;
        }
        if (identityManagers.size() > 1) {
            throw new IllegalStateException("Multiple IdentityManagerBuildItem seen: " + identityManagers);
        }
        IdentityManagerBuildItem identityManager = identityManagers.get(0);
        ArrayList<AuthConfig> allAuthConfigs = new ArrayList<AuthConfig>();
        for (AuthConfigBuildItem authConfigExt : authConfigs) {
            AuthConfig ac = authConfigExt.getAuthConfig();
            allAuthConfigs.add(ac);
        }
        ServletExtension idmExt = template.configureUndertowIdentityManager(securityDomain.getSecurityDomain(), identityManager.getIdentityManager(), allAuthConfigs);
        extension.produce((BuildItem)new ServletExtensionBuildItem(idmExt));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadRealm(SecurityTemplate template, List<SecurityRealmBuildItem> realms) throws Exception {
        for (SecurityRealmBuildItem realm : realms) {
            AuthConfig authConfig = realm.getAuthConfig();
            if (authConfig.getType() == null) continue;
            Class authType = authConfig.getType();
            if (authType.isAssignableFrom(PropertiesRealmConfig.class)) {
                template.loadRealm(realm.getRealm(), this.security.file);
                continue;
            }
            if (!authType.isAssignableFrom(MPRealmConfig.class)) continue;
            template.loadRealm(realm.getRealm(), this.security.embedded);
        }
    }
}

