/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;

@ApplicationScoped
public class ElytronTokenIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger log = Logger.getLogger(ElytronTokenIdentityProvider.class);
    @Inject
    SecurityDomain domain;

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public CompletionStage<io.quarkus.security.identity.SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<io.quarkus.security.identity.SecurityIdentity>(){

            @Override
            public io.quarkus.security.identity.SecurityIdentity get() {
                try {
                    SecurityIdentity result = ElytronTokenIdentityProvider.this.domain.authenticate((Evidence)new BearerTokenEvidence(request.getToken().getToken()));
                    if (result == null) {
                        throw new AuthenticationFailedException();
                    }
                    QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                    builder.setPrincipal(result.getPrincipal());
                    for (String i : result.getRoles()) {
                        builder.addRole(i);
                    }
                    builder.addCredential((Credential)request.getToken());
                    return builder.build();
                }
                catch (RealmUnavailableException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException((Throwable)e);
                }
            }
        });
    }
}

