/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.enforcer;

import io.quarkus.enforcer.DeploymentDependencyRuleSupport;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class BansRuntimeDependency
extends DeploymentDependencyRuleSupport {
    @Override
    protected void execute(MavenProject project, Map<String, Artifact> nonDeploymentArtifactsByGAV, Map<String, Dependency> directDepsByGAV) throws EnforcerRuleException {
        String runtimeArtifactId = project.getArtifactId().replace("-deployment", "");
        List illegalRuntimeGAVs = nonDeploymentArtifactsByGAV.entrySet().parallelStream().filter(entry -> directDepsByGAV.containsKey(entry.getKey())).filter(entry -> !((Artifact)entry.getValue()).getArtifactId().equals(runtimeArtifactId)).filter(entry -> this.parseDeploymentGAV((String)entry.getKey(), (Artifact)entry.getValue()).isPresent()).map(entry -> ((Artifact)entry.getValue()).getArtifactId()).sorted().collect(Collectors.toList());
        if (!illegalRuntimeGAVs.isEmpty()) {
            throw new EnforcerRuleException(illegalRuntimeGAVs.size() + " illegal runtime dependencies found that have to be replaced with their -deployment counterparts:\n\t" + illegalRuntimeGAVs.stream().collect(Collectors.joining("\n\t")));
        }
    }

    @Override
    protected boolean isCheckRequired(MavenProject project) {
        return project.getArtifactId().endsWith("-deployment");
    }
}

