/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigItem;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DescriptiveDocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.JavaDocParser;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class GenerateExtensionConfigurationDoc {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String NAMED_MAP_CONFIG_ITEM_FORMAT = ".\"<%s>\"";
    private final JavaDocParser javaDocParser = new JavaDocParser();
    private final Set<ConfigRootInfo> configRoots = new HashSet<ConfigRootInfo>();
    private final Set<String> processorClassMembers = new HashSet<String>();
    private final Map<String, TypeElement> configGroups = new HashMap<String, TypeElement>();
    private final DocFormatter descriptiveDocFormatter = new DescriptiveDocFormatter();
    private final DocFormatter summaryTableDocFormatter = new SummaryTableDocFormatter();

    public void addProcessorClassMember(String member) {
        this.processorClassMembers.add(member);
    }

    public void addConfigGroups(TypeElement configGroup) {
        this.configGroups.put(configGroup.getQualifiedName().toString(), configGroup);
    }

    public void addConfigRoot(PackageElement pkg, TypeElement clazz) {
        Matcher pkgMatcher = Constants.PKG_PATTERN.matcher(pkg.toString());
        if (!pkgMatcher.find()) {
            return;
        }
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            Matcher nameMatcher;
            String annotationName = annotationMirror.getAnnotationType().toString();
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            String name = "";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().getValue().toString();
                if ("name()".equals(key)) {
                    name = "quarkus." + value;
                    continue;
                }
                if (!"phase()".equals(key)) continue;
                configPhase = ConfigPhase.valueOf(value);
            }
            if (name.isEmpty() && (nameMatcher = Constants.CONFIG_ROOT_PATTERN.matcher(clazz.getSimpleName())).find()) {
                name = "quarkus." + DocGeneratorUtil.hyphenate(nameMatcher.group(1));
            }
            String extensionName = pkgMatcher.group(1);
            ConfigRootInfo configRootInfo = new ConfigRootInfo(name, clazz, extensionName, configPhase);
            this.configRoots.add(configRootInfo);
            break;
        }
    }

    public void writeExtensionConfiguration(Properties javaDocProperties) throws IOException {
        Map<String, List<ConfigItem>> extensionsConfigurations = this.findExtensionsConfigurationItems(javaDocProperties);
        for (Map.Entry<String, List<ConfigItem>> entry : extensionsConfigurations.entrySet()) {
            List<ConfigItem> configItems = entry.getValue();
            Collections.sort(configItems);
            StringBuilder doc = new StringBuilder(this.summaryTableDocFormatter.format(configItems));
            doc.append("\n\n");
            doc.append(this.descriptiveDocFormatter.format(configItems));
            String generatedDoc = doc.toString();
            if (generatedDoc.contains(Constants.DURATION_INFORMATION)) {
                doc.append("\n[NOTE]\n[[duration-note-anchor]]\n.About the Duration format\n====\nThe format for durations uses the standard `java.time.Duration` format.\nYou can learn more about it in the link:https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html#parse-java.lang.CharSequence-[Duration#parse() javadoc].\n\nYou can also provide duration values starting with a number.\nIn this case, if the value consists only of a number, the converter treats the value as seconds.\nOtherwise, `PT` is implicitly appended to the value to obtain a standard `java.time.Duration` format.\n====\n");
            }
            if (generatedDoc.contains(Constants.MEMORY_SIZE_INFORMATION)) {
                doc.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
            FileOutputStream out = new FileOutputStream(Constants.GENERATED_DOCS_PATH.resolve(entry.getKey()).toFile());
            Throwable throwable = null;
            try {
                out.write(doc.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private Map<String, List<ConfigItem>> findExtensionsConfigurationItems(Properties javaDocProperties) throws IOException {
        Map<String, List<ConfigItem>> inMemoryConfigurationItems = this.findInMemoryConfigurationItems(javaDocProperties);
        if (!inMemoryConfigurationItems.isEmpty()) {
            if (!Constants.GENERATED_DOCS_DIR.exists()) {
                Constants.GENERATED_DOCS_DIR.mkdirs();
            }
            if (!Constants.ALL_CR_GENERATED_DOC.exists()) {
                Constants.ALL_CR_GENERATED_DOC.createNewFile();
            }
        }
        Properties allExtensionGeneratedDocs = new Properties();
        if (Constants.ALL_CR_GENERATED_DOC.exists()) {
            Throwable object = null;
            try (BufferedReader bufferedReader = Files.newBufferedReader(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8);){
                allExtensionGeneratedDocs.load(bufferedReader);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        if (!inMemoryConfigurationItems.isEmpty()) {
            for (Map.Entry entry : inMemoryConfigurationItems.entrySet()) {
                String serializableConfigRootDoc = OBJECT_MAPPER.writeValueAsString(entry.getValue());
                allExtensionGeneratedDocs.put(entry.getKey(), serializableConfigRootDoc);
            }
            Throwable throwable = null;
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                allExtensionGeneratedDocs.store(bufferedWriter, "");
            }
            catch (Throwable serializableConfigRootDoc) {
                Throwable throwable3 = serializableConfigRootDoc;
                throw serializableConfigRootDoc;
            }
        }
        HashMap<String, List<ConfigItem>> foundExtensionConfigurationItems = new HashMap<String, List<ConfigItem>>();
        for (String member : this.processorClassMembers) {
            String fileName;
            List previousExtensionConfigItems;
            List configItems = inMemoryConfigurationItems.get(member);
            if (configItems == null) {
                String serializedContent = allExtensionGeneratedDocs.getProperty(member);
                if (serializedContent == null) continue;
                configItems = (List)OBJECT_MAPPER.readValue(serializedContent, (TypeReference)new TypeReference<List<ConfigItem>>(){});
            }
            if ((previousExtensionConfigItems = (List)foundExtensionConfigurationItems.get(fileName = this.computeExtensionDocFileName(member))) == null) {
                foundExtensionConfigurationItems.put(fileName, configItems);
                continue;
            }
            previousExtensionConfigItems.addAll(configItems);
        }
        return foundExtensionConfigurationItems;
    }

    private Map<String, List<ConfigItem>> findInMemoryConfigurationItems(Properties javaDocProperties) {
        HashMap<String, List<ConfigItem>> configOutput = new HashMap<String, List<ConfigItem>>();
        for (ConfigRootInfo configRootInfo : this.configRoots) {
            TypeElement element = configRootInfo.getClazz();
            ArrayList<ConfigItem> configItems = new ArrayList<ConfigItem>();
            this.recordConfigItems(configItems, element, configRootInfo.getName(), configRootInfo.getConfigPhase(), false, javaDocProperties);
            configOutput.put(configRootInfo.getClazz().getQualifiedName().toString(), configItems);
        }
        return configOutput;
    }

    String computeExtensionDocFileName(String configRoot) {
        Matcher matcher = Constants.PKG_PATTERN.matcher(configRoot);
        if (!matcher.find()) {
            return configRoot + ".adoc";
        }
        String extensionName = matcher.group(1);
        String subgroup = matcher.group(2);
        StringBuilder key = new StringBuilder("quarkus");
        key.append("-");
        if ("deployment".equals(extensionName) || "runtime".equals(extensionName)) {
            String configClass = configRoot.substring(configRoot.lastIndexOf(46) + 1);
            extensionName = DocGeneratorUtil.hyphenate(configClass);
            key.append("core-");
            key.append(extensionName);
        } else if (subgroup != null && !"deployment".equals(subgroup) && !"runtime".equals(subgroup) && !"common".equals(subgroup) && subgroup.matches("^[a-z0-9]+$")) {
            key.append(extensionName);
            key.append("-");
            key.append(subgroup);
            String qualifier = matcher.group(3);
            if (qualifier != null && !"deployment".equals(qualifier) && !"runtime".equals(qualifier) && !"common".equals(qualifier) && qualifier.matches("^[a-z0-9]+$")) {
                key.append("-");
                key.append(qualifier);
            }
        } else {
            key.append(extensionName);
        }
        key.append(".adoc");
        return key.toString();
    }

    private void recordConfigItems(List<ConfigItem> configItems, Element element, String parentName, ConfigPhase configPhase, boolean withinAMap, Properties javaDocProperties) {
        for (Element element2 : element.getEnclosedElements()) {
            boolean isStaticField;
            if (!element2.getKind().isField() || (isStaticField = element2.getModifiers().stream().anyMatch(Modifier.STATIC::equals))) continue;
            String name = "";
            String defaultValue = "<<no default>>";
            TypeMirror typeMirror = element2.asType();
            String type = typeMirror.toString();
            List<String> acceptedValues = null;
            Element configGroup = this.configGroups.get(type);
            boolean isConfigGroup = configGroup != null;
            String fieldName = element2.getSimpleName().toString();
            List<? extends AnnotationMirror> annotationMirrors = element2.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigItem")) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().getValue().toString();
                    if ("name()".equals(key)) {
                        switch (value) {
                            case "<<hyphenated element name>>": {
                                name = parentName + '.' + DocGeneratorUtil.hyphenate(fieldName);
                                break;
                            }
                            case "<<parent>>": {
                                name = parentName;
                                break;
                            }
                            default: {
                                name = parentName + '.' + value;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!"defaultValue()".equals(key)) continue;
                    defaultValue = value;
                }
            }
            if (name.isEmpty()) {
                name = parentName + '.' + DocGeneratorUtil.hyphenate(fieldName);
            }
            if ("<<no default>>".equals(defaultValue)) {
                defaultValue = "";
            }
            if (isConfigGroup) {
                this.recordConfigItems(configItems, configGroup, name, configPhase, withinAMap, javaDocProperties);
                continue;
            }
            ConfigItem configItem = new ConfigItem();
            configItem.setWithinAMap(withinAMap);
            TypeElement typeElement = (TypeElement)element;
            String javaDocKey = typeElement.getQualifiedName().toString() + '.' + fieldName;
            if (!typeMirror.getKind().isPrimitive()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    if (typeArguments.size() == 2) {
                        String mapKey = String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, DocGeneratorUtil.hyphenate(fieldName));
                        type = typeArguments.get(1).toString();
                        configGroup = this.configGroups.get(type);
                        if (configGroup != null) {
                            this.recordConfigItems(configItems, configGroup, name + mapKey, configPhase, true, javaDocProperties);
                            continue;
                        }
                        name = name + mapKey;
                        configItem.setWithinAMap(true);
                    } else {
                        TypeMirror realTypeMirror = typeArguments.get(0);
                        type = this.simpleTypeToString(realTypeMirror);
                        if (this.isEnumType(realTypeMirror)) {
                            acceptedValues = this.extractEnumValues(realTypeMirror);
                        }
                    }
                } else {
                    type = this.simpleTypeToString(declaredType);
                    if (this.isEnumType(declaredType)) {
                        acceptedValues = this.extractEnumValues(declaredType);
                    }
                }
            }
            String rawJavaDoc = javaDocProperties.getProperty(javaDocKey);
            String doc = this.javaDocParser.parse(rawJavaDoc);
            configItem.setConfigDoc(doc);
            configItem.setDefaultValue(defaultValue);
            configItem.setConfigPhase(configPhase);
            configItem.setKey(name);
            configItem.setType(type);
            configItem.setAcceptedValues(acceptedValues);
            configItems.add(configItem);
            configItem.setJavaDocSiteLink(DocGeneratorUtil.getJavaDocSiteLink(type));
        }
    }

    private String simpleTypeToString(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        String knownGenericType = DocGeneratorUtil.getKnownGenericType((DeclaredType)typeMirror);
        return knownGenericType != null ? knownGenericType : typeMirror.toString();
    }

    private List<String> extractEnumValues(TypeMirror realTypeMirror) {
        Element declaredTypeElement = ((DeclaredType)realTypeMirror).asElement();
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Element element : declaredTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            acceptedValues.add(DocGeneratorUtil.hyphenateEnumValue(element.getSimpleName().toString()));
        }
        return acceptedValues;
    }

    private boolean isEnumType(TypeMirror realTypeMirror) {
        return realTypeMirror instanceof DeclaredType && ((DeclaredType)realTypeMirror).asElement().getKind() == ElementKind.ENUM;
    }

    public String toString() {
        return "GenerateExtensionConfigurationDoc{javaDocParser=" + this.javaDocParser + ", configRoots=" + this.configRoots + ", processorClassMembers=" + this.processorClassMembers + ", configGroups=" + this.configGroups + ", descriptiveDocFormatter=" + this.descriptiveDocFormatter + ", summaryTableDocFormatter=" + this.summaryTableDocFormatter + '}';
    }
}

