/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

final class JavaDocParser {
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);
    private static final Pattern REPLACE_WINDOWS_EOL = Pattern.compile("\r\n");
    private static final Pattern REPLACE_MACOS_EOL = Pattern.compile("\r");
    private static final String HASH = "#";
    private static final String STAR = "*";
    private static final String S_NODE = "s";
    private static final String UNDERSCORE = "_";
    private static final String NEW_LINE = "\n";
    private static final String LINK_NODE = "a";
    private static final String BOLD_NODE = "b";
    private static final String BIG_NODE = "big";
    private static final String DEL_NODE = "del";
    private static final String ITALICS_NODE = "i";
    private static final String TEXT_NODE = "#text";
    private static final String UNDERLINE_NODE = "u";
    private static final String NEW_LINE_NODE = "br";
    private static final String PARAGRAPH_NODE = "p";
    private static final String SMALL_NODE = "small";
    private static final String EMPHASIS_NODE = "em";
    private static final String LIST_ITEM_NODE = "li";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String STRIKE_NODE = "strike";
    private static final String SUB_SCRIPT_NODE = "sub";
    private static final String ORDERED_LIST_NODE = "ol";
    private static final String SUPER_SCRIPT_NODE = "sup";
    private static final String UN_ORDERED_LIST_NODE = "ul";
    private static final String INLINE_JAVA_DOC_TAG_FORMAT = "`%s`";
    private static final String BIG_ASCIDOC_STYLE = "[.big]";
    private static final String LINK_ATTRIBUTE_FORMAT = "[%s]";
    private static final String SUB_SCRIPT_ASCIDOC_STYLE = "~";
    private static final String SUPER_SCRIPT_ASCIDOC_STYLE = "^";
    private static final String SMALL_ASCIDOC_STYLE = "[.small]";
    private static final String ORDERED_LIST_ITEM_ASCIDOC_STYLE = " . ";
    private static final String UNORDERED_LIST_ITEM_ASCIDOC_STYLE = " - ";
    private static final String UNDERLINE_ASCIDOC_STYLE = "[.underline]";
    private static final String LINE_THROUGH_ASCIDOC_STYLE = "[.line-through]";

    JavaDocParser() {
    }

    public String parse(String javadocComment) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            return "";
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        if (this.isAsciidoc(javadoc)) {
            String asciidoc = javadoc.getDescription().toText();
            asciidoc = REPLACE_WINDOWS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
            asciidoc = REPLACE_MACOS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
            return asciidoc;
        }
        return this.htmlJavadocToAsciidoc(javadoc.getDescription());
    }

    private boolean isAsciidoc(Javadoc javadoc) {
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            if (!"asciidoclet".equals(blockTag.getTagName())) continue;
            return true;
        }
        return false;
    }

    private String htmlJavadocToAsciidoc(JavadocDescription javadocDescription) {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement javadocDescriptionElement : javadocDescription.getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: {
                        sb.append(String.format(INLINE_JAVA_DOC_TAG_FORMAT, content));
                        break;
                    }
                    case LINK: 
                    case LINKPLAIN: {
                        if (content.startsWith(HASH)) {
                            content = DocGeneratorUtil.hyphenate(content.substring(1));
                        }
                        sb.append(String.format(INLINE_JAVA_DOC_TAG_FORMAT, content));
                        break;
                    }
                    default: {
                        sb.append(content);
                        break;
                    }
                }
                continue;
            }
            this.appendHtml(sb, (Node)Jsoup.parseBodyFragment((String)javadocDescriptionElement.toText()));
        }
        return sb.toString().trim();
    }

    private void appendHtml(StringBuilder sb, Node node) {
        block36: for (Node childNode : node.childNodes()) {
            switch (childNode.nodeName()) {
                case "p": {
                    sb.append(NEW_LINE);
                    this.appendHtml(sb, childNode);
                    continue block36;
                }
                case "ol": 
                case "ul": {
                    this.appendHtml(sb, childNode);
                    continue block36;
                }
                case "li": {
                    String marker = childNode.parent().nodeName().equals(ORDERED_LIST_NODE) ? ORDERED_LIST_ITEM_ASCIDOC_STYLE : UNORDERED_LIST_ITEM_ASCIDOC_STYLE;
                    sb.append(NEW_LINE);
                    sb.append(marker);
                    this.appendHtml(sb, childNode);
                    continue block36;
                }
                case "a": {
                    String link = childNode.attr(HREF_ATTRIBUTE);
                    sb.append(link);
                    StringBuilder caption = new StringBuilder();
                    this.appendHtml(caption, childNode);
                    sb.append(String.format(LINK_ATTRIBUTE_FORMAT, caption.toString().trim()));
                    continue block36;
                }
                case "b": 
                case "em": {
                    sb.append(STAR);
                    this.appendHtml(sb, childNode);
                    sb.append(STAR);
                    continue block36;
                }
                case "i": {
                    sb.append(UNDERSCORE);
                    this.appendHtml(sb, childNode);
                    sb.append(UNDERSCORE);
                    continue block36;
                }
                case "u": {
                    sb.append(UNDERLINE_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block36;
                }
                case "small": {
                    sb.append(SMALL_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block36;
                }
                case "big": {
                    sb.append(BIG_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block36;
                }
                case "sub": {
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    continue block36;
                }
                case "sup": {
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    continue block36;
                }
                case "del": 
                case "s": 
                case "strike": {
                    sb.append(LINE_THROUGH_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block36;
                }
                case "br": {
                    sb.append(NEW_LINE);
                    continue block36;
                }
                case "#text": {
                    TextNode textNode = (TextNode)childNode;
                    sb.append(textNode.text());
                    continue block36;
                }
            }
            this.appendHtml(sb, childNode);
        }
    }
}

