/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ConfigDocWriter {
    private final DocFormatter summaryTableDocFormatter = new SummaryTableDocFormatter();

    public void writeExtensionConfigDocumentation(Map<String, List<ConfigDocItem>> extensionsConfigurations) throws IOException {
        for (Map.Entry<String, List<ConfigDocItem>> entry : extensionsConfigurations.entrySet()) {
            List<ConfigDocItem> configDocItems = entry.getValue();
            String extensionFileName = entry.getKey();
            ConfigDocWriter.sort(configDocItems);
            this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve(extensionFileName), configDocItems);
        }
    }

    public void writeAllExtensionConfigDocumentation(Map<String, List<ConfigDocItem>> extensionsConfigurations) throws IOException {
        ArrayList<ConfigDocItem> allItems = new ArrayList<ConfigDocItem>();
        TreeMap<String, List<ConfigDocItem>> sortedExtensions = new TreeMap<String, List<ConfigDocItem>>();
        sortedExtensions.putAll(extensionsConfigurations);
        for (Map.Entry entry : sortedExtensions.entrySet()) {
            List configDocItems = (List)entry.getValue();
            ConfigDocWriter.sort(configDocItems);
            ConfigDocSection header = new ConfigDocSection();
            String title = (String)entry.getKey();
            if (title.startsWith("quarkus-")) {
                title = title.substring(8);
            }
            if (title.endsWith(".adoc")) {
                title = title.substring(0, title.length() - 5);
            }
            if (title.endsWith("-config")) {
                title = title.substring(0, title.length() - 7);
            }
            if (title.endsWith("-configuration")) {
                title = title.substring(0, title.length() - 14);
            }
            title = title.replace('-', ' ');
            title = this.capitalize(title);
            header.setSectionDetailsTitle(title);
            allItems.add(new ConfigDocItem(header, null));
            allItems.addAll(configDocItems);
        }
        this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve("all-config.adoc"), allItems);
    }

    private String capitalize(String title) {
        char[] chars = title.toCharArray();
        boolean capitalize = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isSpaceChar(c)) {
                capitalize = true;
                continue;
            }
            if (!capitalize) continue;
            if (Character.isLetter(c)) {
                chars[i] = Character.toUpperCase(c);
            }
            capitalize = false;
        }
        return new String(chars);
    }

    private static void sort(List<ConfigDocItem> configDocItems) {
        Collections.sort(configDocItems);
        for (ConfigDocItem configDocItem : configDocItems) {
            if (!configDocItem.isConfigSection()) continue;
            ConfigDocWriter.sort(configDocItem.getConfigDocSection().getConfigDocItems());
        }
    }

    private void generateDocumentation(Path targetPath, List<ConfigDocItem> configDocItems) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, new OpenOption[0]);){
            this.summaryTableDocFormatter.format((Writer)writer, configDocItems);
            boolean hasDuration = false;
            boolean hasMemory = false;
            for (ConfigDocItem item : configDocItems) {
                if (item.hasDurationInformationNote()) {
                    hasDuration = true;
                }
                if (!item.hasMemoryInformationNote()) continue;
                hasMemory = true;
            }
            if (hasDuration) {
                writer.append("\n[NOTE]\n[[duration-note-anchor]]\n.About the Duration format\n====\nThe format for durations uses the standard `java.time.Duration` format.\nYou can learn more about it in the link:https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html#parse-java.lang.CharSequence-[Duration#parse() javadoc].\n\nYou can also provide duration values starting with a number.\nIn this case, if the value consists only of a number, the converter treats the value as seconds.\nOtherwise, `PT` is implicitly appended to the value to obtain a standard `java.time.Duration` format.\n====\n");
            }
            if (hasMemory) {
                writer.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
        }
    }
}

