/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

final class SummaryTableDocFormatter
implements DocFormatter {
    private static final String TABLE_CLOSING_TAG = "\n|===";
    private static final String TABLE_ROW_FORMAT = "\n\na|%s `%s`\n\n[.description]\n--\n%s\n--|%s %s\n|%s\n";
    private static final String TABLE_SECTION_ROW_FORMAT = "\n\n3+h|%s";
    private static final String TABLE_HEADER_FORMAT = "[.configuration-legend]%s\n[.configuration-reference, cols=\"80,.^10,.^10\"]\n|===\n|Configuration property|Type|Default";

    SummaryTableDocFormatter() {
    }

    @Override
    public void format(Writer writer, List<ConfigDocItem> configDocItems) throws IOException {
        String tableHeaders = String.format(TABLE_HEADER_FORMAT, Constants.CONFIG_PHASE_LEGEND);
        writer.append(tableHeaders);
        for (ConfigDocItem configDocItem : configDocItems) {
            configDocItem.accept(writer, this);
        }
        writer.append(TABLE_CLOSING_TAG);
    }

    @Override
    public void format(Writer writer, ConfigDocKey configDocKey) throws IOException {
        String typeContent = "";
        if (configDocKey.hasAcceptedValues()) {
            typeContent = DocGeneratorUtil.joinAcceptedValues(configDocKey.getAcceptedValues());
        } else if (configDocKey.hasType()) {
            typeContent = configDocKey.computeTypeSimpleName();
            String javaDocLink = configDocKey.getJavaDocSiteLink();
            if (!javaDocLink.isEmpty()) {
                typeContent = String.format("link:%s[%s]\n", javaDocLink, typeContent);
            }
        }
        if (configDocKey.isList()) {
            typeContent = "list of " + typeContent;
        }
        String doc = configDocKey.getConfigDoc();
        String typeDetail = DocGeneratorUtil.getTypeFormatInformationNote(configDocKey);
        String defaultValue = configDocKey.getDefaultValue();
        String required = configDocKey.isOptional() || !defaultValue.isEmpty() ? "" : "required icon:exclamation-circle[title=Configuration property is required]";
        writer.append(String.format(TABLE_ROW_FORMAT, configDocKey.getConfigPhase().getIllustration(), configDocKey.getKey(), doc.replace("|", "\\|"), typeContent, typeDetail, defaultValue.isEmpty() ? required : String.format("`%s`", defaultValue)));
    }

    @Override
    public void format(Writer writer, ConfigDocSection configDocSection) throws IOException {
        String sectionRow = String.format(TABLE_SECTION_ROW_FORMAT, configDocSection.getSectionDetailsTitle());
        writer.append(sectionRow);
        for (ConfigDocItem configDocItem : configDocSection.getConfigDocItems()) {
            configDocItem.accept(writer, this);
        }
    }
}

