/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDoItemFinder;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.ScannedConfigDocsItemHolder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public final class ConfigDocItemScanner {
    private static final String EXTENSION_LIST_SEPARATOR = ",";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String IO_QUARKUS_TEST_EXTENSION_PACKAGE = "io.quarkus.extest.";
    private final Set<ConfigRootInfo> configRoots = new HashSet<ConfigRootInfo>();
    private final Set<String> processorClassMembers = new HashSet<String>();
    private final Map<String, TypeElement> configGroups = new HashMap<String, TypeElement>();

    public void addProcessorClassMember(String member) {
        this.processorClassMembers.add(member);
    }

    public void addConfigGroups(TypeElement configGroup) {
        String configGroupName = configGroup.getQualifiedName().toString();
        Matcher pkgMatcher = Constants.PKG_PATTERN.matcher(configGroupName);
        if (!pkgMatcher.find() || configGroupName.startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        this.configGroups.put(configGroupName, configGroup);
    }

    public void addConfigRoot(PackageElement pkg, TypeElement clazz) {
        Matcher pkgMatcher = Constants.PKG_PATTERN.matcher(pkg.toString());
        if (!pkgMatcher.find() || pkg.toString().startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            Matcher nameMatcher;
            String annotationName = annotationMirror.getAnnotationType().toString();
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            String name = "";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().getValue().toString();
                if ("name()".equals(key)) {
                    name = "quarkus." + value;
                    continue;
                }
                if (!"phase()".equals(key)) continue;
                configPhase = ConfigPhase.valueOf(value);
            }
            if (name.isEmpty() && (nameMatcher = Constants.CONFIG_ROOT_PATTERN.matcher(clazz.getSimpleName())).find()) {
                name = "quarkus." + DocGeneratorUtil.hyphenate(nameMatcher.group(1));
            }
            String extensionName = pkgMatcher.group(1);
            ConfigRootInfo configRootInfo = new ConfigRootInfo(name, clazz, extensionName, configPhase);
            this.configRoots.add(configRootInfo);
            break;
        }
    }

    public ScannedConfigDocsItemHolder scanExtensionsConfigurationItems(Properties javaDocProperties) throws IOException {
        ConfigDoItemFinder configDoItemFinder = new ConfigDoItemFinder(this.configRoots, this.configGroups, javaDocProperties);
        ScannedConfigDocsItemHolder inMemoryScannedItemsHolder = configDoItemFinder.findInMemoryConfigurationItems();
        if (!inMemoryScannedItemsHolder.isEmpty()) {
            this.createOutputFolder();
        }
        Properties allExtensionGeneratedDocs = this.loadAllExtensionConfigItemsParConfigRoot();
        Properties configurationRootsParExtensionFileName = this.loadExtensionConfigRootList();
        if (!inMemoryScannedItemsHolder.isEmpty()) {
            this.updateScannedExtensionArtifactFiles(inMemoryScannedItemsHolder, allExtensionGeneratedDocs, configurationRootsParExtensionFileName);
        }
        Map<String, List<ConfigDocItem>> allConfigItemsPerExtension = this.computeAllExtensionConfigItems(inMemoryScannedItemsHolder, allExtensionGeneratedDocs, configurationRootsParExtensionFileName);
        Map<String, List<ConfigDocItem>> configGroupConfigItems = this.computeConfigGroupFilesNames(inMemoryScannedItemsHolder);
        return new ScannedConfigDocsItemHolder(allConfigItemsPerExtension, configGroupConfigItems);
    }

    private void createOutputFolder() throws IOException {
        if (!Constants.GENERATED_DOCS_DIR.exists()) {
            Constants.GENERATED_DOCS_DIR.mkdirs();
        }
        if (!Constants.ALL_CR_GENERATED_DOC.exists()) {
            Constants.ALL_CR_GENERATED_DOC.createNewFile();
        }
        if (!Constants.EXTENSION_CONFIGURATION_ROOT_LIST.exists()) {
            Constants.EXTENSION_CONFIGURATION_ROOT_LIST.createNewFile();
        }
    }

    private Properties loadAllExtensionConfigItemsParConfigRoot() throws IOException {
        Properties allExtensionGeneratedDocs = new Properties();
        if (Constants.ALL_CR_GENERATED_DOC.exists()) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8);){
                allExtensionGeneratedDocs.load(bufferedReader);
            }
        }
        return allExtensionGeneratedDocs;
    }

    private Properties loadExtensionConfigRootList() throws IOException {
        Properties configurationRootsParExtensionFileName = new Properties();
        if (Constants.EXTENSION_CONFIGURATION_ROOT_LIST.exists()) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(Constants.EXTENSION_CONFIGURATION_ROOT_LIST.toPath(), StandardCharsets.UTF_8);){
                configurationRootsParExtensionFileName.load(bufferedReader);
            }
        }
        return configurationRootsParExtensionFileName;
    }

    private void updateConfigurationRootsList(Properties configurationRootsParExtensionFileName, Map.Entry<String, List<ConfigDocItem>> entry) {
        String extensionFileName = DocGeneratorUtil.computeExtensionDocFileName(entry.getKey());
        String extensionList = configurationRootsParExtensionFileName.computeIfAbsent(extensionFileName, (Function<? super Object, ?>)((Function<Object, Object>)key -> (String)entry.getKey())).toString();
        if (!extensionList.contains(entry.getKey())) {
            configurationRootsParExtensionFileName.put(extensionFileName, extensionList + EXTENSION_LIST_SEPARATOR + entry.getKey());
        }
    }

    private void updateScannedExtensionArtifactFiles(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder, Properties allExtensionGeneratedDocs, Properties configurationRootsParExtensionFileName) throws IOException {
        for (Map.Entry<String, List<ConfigDocItem>> entry : inMemoryScannedItemsHolder.getAllConfigItemsPerExtension().entrySet()) {
            String serializableConfigRootDoc = OBJECT_MAPPER.writeValueAsString(entry.getValue());
            allExtensionGeneratedDocs.put(entry.getKey(), serializableConfigRootDoc);
            this.updateConfigurationRootsList(configurationRootsParExtensionFileName, entry);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Constants.EXTENSION_CONFIGURATION_ROOT_LIST.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            configurationRootsParExtensionFileName.store(bufferedWriter, "");
        }
        bufferedWriter = Files.newBufferedWriter(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        var5_5 = null;
        try {
            allExtensionGeneratedDocs.store(bufferedWriter, "");
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                if (var5_5 != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    private Map<String, List<ConfigDocItem>> computeAllExtensionConfigItems(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder, Properties allExtensionGeneratedDocs, Properties configurationRootsParExtensionFileName) throws IOException {
        HashMap<String, List<ConfigDocItem>> configItemsParExtensionFileNames = new HashMap<String, List<ConfigDocItem>>();
        Set extensionFileNamesToGenerate = this.processorClassMembers.stream().filter(allExtensionGeneratedDocs::containsKey).map(member -> DocGeneratorUtil.computeExtensionDocFileName(member)).collect(Collectors.toSet());
        for (String extensionFileName : extensionFileNamesToGenerate) {
            String[] extensionConfigRoots;
            String extensionConfigRootsProperty = configurationRootsParExtensionFileName.getProperty(extensionFileName);
            if (extensionConfigRootsProperty == null || "".equals(extensionConfigRootsProperty.trim())) continue;
            for (String configRoot : extensionConfigRoots = extensionConfigRootsProperty.split(EXTENSION_LIST_SEPARATOR)) {
                List configDocItems = inMemoryScannedItemsHolder.getAllConfigItemsPerExtension().get(configRoot);
                if (configDocItems == null) {
                    String serializedContent = allExtensionGeneratedDocs.getProperty(configRoot);
                    configDocItems = (List)OBJECT_MAPPER.readValue(serializedContent, (TypeReference)new TypeReference<List<ConfigDocItem>>(){});
                }
                List existingConfigDocItems = configItemsParExtensionFileNames.computeIfAbsent(extensionFileName, key -> new ArrayList());
                DocGeneratorUtil.appendConfigItemsIntoExistingOnes(existingConfigDocItems, configDocItems);
            }
        }
        return configItemsParExtensionFileNames;
    }

    private Map<String, List<ConfigDocItem>> computeConfigGroupFilesNames(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder) {
        HashMap<String, List<ConfigDocItem>> configItemsParConfigGroupFileNames = new HashMap<String, List<ConfigDocItem>>();
        for (Map.Entry<String, List<ConfigDocItem>> entry : inMemoryScannedItemsHolder.getConfigGroupConfigItems().entrySet()) {
            String extensionDocFileName = DocGeneratorUtil.computeConfigGroupDocFileName(entry.getKey());
            configItemsParConfigGroupFileNames.put(extensionDocFileName, entry.getValue());
        }
        return configItemsParConfigGroupFileNames;
    }

    public Map<String, List<ConfigDocItem>> loadAllExtensionsConfigurationItems() throws IOException {
        if (!Constants.GENERATED_DOCS_DIR.exists()) {
            Constants.GENERATED_DOCS_DIR.mkdirs();
        }
        Properties allExtensionGeneratedDocs = new Properties();
        if (Constants.ALL_CR_GENERATED_DOC.exists()) {
            BufferedReader bufferedReader = Files.newBufferedReader(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8);
            Object object = null;
            try {
                allExtensionGeneratedDocs.load(bufferedReader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bufferedReader != null) {
                    if (object != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        HashMap<String, List<ConfigDocItem>> foundExtensionConfigurationItems = new HashMap<String, List<ConfigDocItem>>();
        for (String string : allExtensionGeneratedDocs.keySet()) {
            String serializedContent = allExtensionGeneratedDocs.getProperty(string);
            if (serializedContent == null) continue;
            List configDocItems = (List)OBJECT_MAPPER.readValue(serializedContent, (TypeReference)new TypeReference<List<ConfigDocItem>>(){});
            foundExtensionConfigurationItems.put(string, configDocItems);
        }
        return foundExtensionConfigurationItems;
    }

    public String toString() {
        return "ConfigDocItemScanner{, configRoots=" + this.configRoots + ", processorClassMembers=" + this.processorClassMembers + ", configGroups=" + this.configGroups + '}';
    }
}

